#!/usr/local/bin/perl
# photometry.pl 
# Created: Yoshifusa Ita, 06-Aug-28

if(@ARGV < 6){
    die "Usage: photometry.pl 1.9077 0.0675 582.1 8.713 20.0 *.mag.dat\n";
}

$conv = $ARGV[0];
$conv_err = $ARGV[1];
chomp $conv_err;
$zero = $ARGV[2];
chomp $zero;
$zero_err = $ARGV[3];
chomp $zero_err;
$zmag = $ARGV[4];
chomp $zmag;
$fname = $ARGV[5];
open(IN, $fname) || die "$ARGV[5] : $!";

while(<IN>){
    chomp;
    if($_ !~ /^#/){ #comment$B9T$G$O$J$+$C$?$i(B
       ($fm, $fm_err) = (split(/\s+/,$_))[11,12];
       if($fm !~ "INDEF" && $fm_err !~ "INDEF"){

	   $jy = $conv * 10**(0.4*($zmag - $fm));
	   $mag = -2.5 * log($jy/$zero)/log(10);
#	   print("$fm $fm_err $jy $mag\n");

	   # error propagation

	   $jy_c    = 10**(0.4*($zmag - $fm));
	   $jy_fm   = $conv*log(10)*(10**(0.4*($zmag - $fm)))/2.5;
	   $e_jy    = ($jy_c**2)*($conv_err**2) + ($jy_fm**2)*($fm_err**2);
	   
	   $m_jy    = 2.5/(log(10))/$jy;
	   $m_jz    = 2.5/(log(10))/$zero;
	   $e_mag   = ($m_jy**2)*$e_jy + ($m_jz**2)*($zero_err**2);
	   $e_mag   = sqrt($e_mag);
	   
	   # jy in [mJy]
	   printf("%s %6.3f %6.3f %f %f\n", $_, $mag, $e_mag, $jy_fm*1000., sqrt($e_jy)*1000.);
       }
    }
}

close(IN);
