#!/usr/local/bin/perl

if(@ARGV < 3){
    die "Usage: bandmerge.pl N2.apt.resut S7.apt.resut L15.apt.result\n";
}

$fname0 = $ARGV[0];
open(IN0, $fname0) || die "$ARGV[0] : $!";
$fname1 = $ARGV[1];
open(IN1, $fname1) || die "$ARGV[1] : $!";
$fname2 = $ARGV[2];
open(IN2, $fname2) || die "$ARGV[2] : $!";

$i=0;
while(<IN0>){
    chomp;
    ($ra0[$i], $dec0[$i], $m0[$i], $me0[$i], $j0[$i], $je0[$i]) = (split(/\s+/,$_))[2,3,14,15,16,17];
    $data0[$i] = $_;
#    print("$ra0[$i] $dec0[$i]\n");
    $i += 1;
}

$i=0;
while(<IN1>){
    chomp;
    ($ra1[$i], $dec1[$i], $m1[$i], $me1[$i], $j1[$i], $je1[$i]) = (split(/\s+/,$_))[2,3,14,15,16,17];
    $data1[$i] = $_;
#    print("$ra1[$i] $dec1[$i]\n");
    $i += 1;
}

$i=0;
while(<IN2>){
    chomp;
    ($ra2[$i], $dec2[$i], $m2[$i], $me2[$i], $j2[$i], $je2[$i]) = (split(/\s+/,$_))[2,3,14,15,16,17];
    $data2[$i] = $_;
#    print("$ra2[$i] $dec2[$i]\n");
    $i += 1;
}

$n0 = @ra0;
$n1 = @ra1;
$n2 = @ra2;

for($i=0;$i<$n0;$i+=1){
    for($j=0;$j<$n1;$j+=1){
	for($k=0;$k<$n2;$k+=1){

	    $d01 = $dec0[$i] - $dec1[$j];
	    $r01 = $ra0[$i]*cos($dec0[$i])  - $ra1[$j]*cos($dec1[$j]);
	    $a01 = sqrt($d01**2 + $r01**2)*3600.;
	    
	    $d02 = $dec0[$i] - $dec2[$k];
	    $r02 = $ra0[$i]*cos($dec0[$i])  - $ra2[$k]*cos($dec2[$k]);
	    $a02 = sqrt($d02**2 + $r02**2)*3600.;
	    
	    $d21 = $dec2[$k] - $dec1[$j];
	    $r21 = $ra2[$k]*cos($dec2[$k])  - $ra1[$j]*cos($dec1[$j]);
	    $a21 = sqrt($d21**2 + $r21**2)*3600.;

	    if($a01 < 4.0 && $a02 < 4.0 && $a21 < 4.0 ){
		print("$ra0[$i] $dec0[$i] $m0[$i] $me0[$i] $j0[$i] $je0[$i] $ra1[$j] $dec1[$j] $m1[$j] $me1[$j] $j1[$j] $je1[$j] $ra2[$k] $dec2[$k] $m2[$k] $me2[$k] $j2[$k] $je2[$k] \n");
	    }

	}
    }
}

close(IN0);
close(IN1);
close(IN2);
