#!/usr/local/bin/perl
# photometry.pl 
# Created: Yoshifusa Ita, 06-Aug-28

if(@ARGV < 2){
    die "Usage: photometry.pl *.apt .dat *.all.dat\n";
}

# aperture$BB,8w$N7k2L(B
$fname = shift(@ARGV);
open(IN, $fname) || die "$ARGV[0] : $!";

$fname2 = (split(/\./,$fname))[0];
$fname2 .= ".fits.pst.1";

$i = 0;
while(<IN>){
    $data1 = $_;
    chomp($data1);
    if($data1 !~ /^\#/){
	$a1[$i] = $data1;
	($x1, $y1, $m, $e)=(split(/\s+/, $data1))[1,2,11,12];
	# *.pst.1$B$r$_$F!"$=$NCf$K$"$k@1$HF1$8J*$@$1$rH4$-=P$9!#(B
	open(IN2, $fname2);
        while(<IN2>){
            $data2 = $_;
            chomp($data2);
            if($data2 !~ /^\#/){
                ($x2, $y2) = (split(/\s+/,$data2))[1,2];
                $dx = ($x2 - $x1)*($x2 - $x1);
                $dy = ($y2 - $y1)*($y2 - $y1);
                $dr = sqrt($dx + $dy);
                if($dr < 0.01){
		    $x1[$i] = $x1;
		    $y1[$i] = $y1;
		    $m1[$i] = $m;
		    $e1[$i] = $e;
		    $i += 1;
                }
	    }
	}
        close(IN2);
    }
}
close(IN);
$n1 = @x1;

# psf fit$BB,8w$N7k2L(B
$fname = shift(@ARGV);
open(IN, $fname) || die "$ARGV[0] : $!";
$i = 0;
while(<IN>){
    chomp;
    if($_ !~ /^\#/){
	$a2[$i] = $_;
	($x2[$i], $y2[$i], $m2[$i], $e2[$i])=(split(/\s+/, $_))[1,2,5,6];
#    print( "$x2[$i] $y2[$i]\n" );
	$i += 1;
    }
}
close(IN);
$n2 = @x2;


for($i=0;$i<$n1;$i+=1){
    for($j=0;$j<$n2;$j+=1){
	$dx = $x1[$i] - $x2[$j];
	$dy = $y1[$i] - $y2[$j];
	$r = sqrt($dx*$dx + $dy*$dy);
#	print("$dx $dy $r\n");
	if($r<1.0){
	    if($m1[$i] != INDEF && $m2[$j] != INDEF){
		$dm = $m1[$i] - $m2[$j]; # AP mag - Fit mag
		print("$m1[$i] $m2[$j] $dm\n");
#		print("$x1[$i] $y1[$i]\n");
	    }
	}
    }
}
