#!/usr/local/bin/perl
# format2mass.pl -- To format the retrieved 2mass catalog data
#                   OUTPUT  format is  "ID RA DEC Kmag eKmag ..."
# Created: Yoshifusa Ita, 19-Dec-05
# Modified: Takehiko Wada, 28-July-07
#           add color magnitude selection for MIR-S/L and  help (with -p option :-P)
# Modified: Takehiko Wada, 11-Oct-07
#           robustness for change of the format.
#           search index number for each items from the header of the 2mass catalog.
#           PLEASE let me know the description of the header of  VizieR Astronomical Server output file!!!
#
# Limitations: lines which starts with [0-9] must be a valid data entry.
#              line which contains  "RAJ2000" and "DEJ2000" must be the line which dscribes the sequence of each item
#

$verbose=0;

$color_mag_selection=0;
$j_h_criterion=0.6;
$h_k_criterion=0.2;
$k_criterion=12;
$color_factor=0;
$outfile="2mass.radec";

$check_q_flag_u=1;

sub help{
    printf(STDERR "Example: cat 2mass.out | format2mass.pl\n");
    printf(STDERR "Options:\n");
    printf(STDERR "  -p: print help\n");
    printf(STDERR "  -s: apply color and magnitude selection.\n");
    printf(STDERR "      use sources if they match one of the followings\n");
    printf(STDERR "      K   < %f, bright star is visible in S/L.\n",$k_criterion);
    printf(STDERR "      J-H > %f\n",$j_h_criterion);
    printf(STDERR "      H-K > %f\n",$h_k_criterion);
    printf(STDERR "      these reject faint main sequence stars\n");
    printf(STDERR "      useful for MIR-S/L\n");
    printf(STDERR "  -j J-H: set J-H criterion\n");
    printf(STDERR "  -h H-K: set H-K criterion\n");
    printf(STDERR "  -k K  : set H   criterion\n");
    printf(STDERR "  -c color_factor: use K-color_factor*(H-K), the default is %f\n",$color_factor);
    printf(STDERR "  -v verbose_level: output debug message if not 1, the default is %d\n",$verbose);
    printf(STDERR "  -o output_file_name: the default is %d\n",$outfile);
    printf(STDERR "  -i : ignore U in quality flag, otherwise reject entries with 'U' in quality flag.\n");
}

use Getopt::Std;
getopts('pv:j:h:k:c:so:i',\%options); #%options̵ϡopt_dͤꤵ
if(defined $options{p}){
    &help();
    exit(0);
}

if(defined $options{v}){
    $verbose=$options{v};
}

if(defined $options{j}){
    $j_h_criterion=$options{j};
}
if(defined $options{h}){
    $h_k_criterion=$options{h};
}
if(defined $options{k}){
    $k_criterion=$options{k};
}
if(defined $options{c}){
    $color_factor=$options{c};
}
if(defined $options{s}){
    $color_mag_selection=1;
}
if(defined $options{o}){
    $outfile=$options{o};
}
if(defined $options{i}){
    $check_q_flag_u=0;
}

if($color_mag_selection==0){
    $j_h_criterion=-99;
    $h_k_criterion=-99;
    $k_criterion=99;
}
printf(STDERR "#selection criterions is %10.2f%10.2f%10.2f\n"
		   ,$j_h_criterion
		   ,$h_k_criterion
		   ,$k_criterion) if($verbose>0);

open(OUT, "> " . $outfile) || die "Cannot write 2mass.radec";


$index_idname=0;
$index_ra=1;
$index_dec=2;
$index_j_mag=3;
$index_j_mag_e=4;
$index_h_mag=5;
$index_h_mag_e=6;
$index_k_mag=7;
$index_k_mag_e=8;
$index_q_flag=9;

line: while ($line = <>){
    chomp $line;

    # ɬפʹܤindexõ
    if($line =~m/RAJ2000/  && $line =~m/DEJ2000/){
	@items=split(/\t+/,$line); # ֤Ƕڤ
	for($i=0; $i<=$#items;$i++){
	    $index_idname=$i  if($items[$i] eq "Seq#");
	    $index_ra=$i      if($items[$i] eq "RAJ2000");
	    $index_dec=$i     if($items[$i] eq "DEJ2000");
	    $index_j_mag=$i   if($items[$i] eq "Jmag");     
	    $index_j_mag_e=$i if($items[$i] eq "e_Jmag");   
	    $index_h_mag=$i   if($items[$i] eq "Hmag");     
	    $index_h_mag_e=$i if($items[$i] eq "e_Hmag");   
	    $index_k_mag=$i   if($items[$i] eq "Kmag");     
	    $index_k_mag_e=$i if($items[$i] eq "e_Kmag");   
	    $index_q_flag=$i  if($items[$i] eq "Qflag");
	}
    }

#    if($line !~ /^\#/){ # ȹԤǤʤä
    if($line =~ /^[0-9]/){ # Ƭä
	@buf1=split(/\t+/,$line); # ֤Ƕڤ
	if($check_q_flag_u==1){
#	    if($buf1[$index_q_flag] =~ /\w\wU/){ # if K mag is not reliable.
	    if($buf1[$index_q_flag] =~ /U/){     # if one of J, H ,K or more  is not reliable.
		next line;
	    }
	}
	if(1){ 
	    $idname=$buf1[$index_idname]; # idname
	    $ra    =$buf1[$index_ra];     # ra [degree]
	    $dec   =$buf1[$index_dec];    # dec [degree]
	    $jmag  =$buf1[$index_j_mag];   # jmag [mag]
	    if($buf1[$index_j_mag_e] !~ /[0-9]/){
		$jmag_e=0.444;
	    }else{
		$jmag_e=$buf1[$index_j_mag_e]; # jerr [mag]
	    }

	    $hmag  =$buf1[$index_h_mag];   # hmag [mag]
	    if($buf1[$index_h_mag_e] !~ /[0-9]/){
		$hmag_e=0.444;
	    }else{
		$hmag_e=$buf1[$index_h_mag_e]; # herr [mag]
	    }

	    $kmag  =$buf1[$index_k_mag];   # kmag [mag]
	    if($buf1[$index_k_mag_e] !~ /[0-9]/){
		$kmag_e=0.444;
	    }else{
		$kmag_e=$buf1[$index_k_mag_e]; # kerr [mag]
	    }

	    $mag=$kmag - $color_factor * ($hmag - $kmag);
	    printf(STDERR "%10.2f%10.2f%10.2f %d\n"
		   ,$jmag-$hmag
		   ,$hmag-$kmag
		   ,$mag
		   ,$idname
		   ) if($verbose>0);

	    if(  ($jmag - $hmag)>$j_h_criterion ||
		 ($hmag - $kmag)>$h_k_criterion ||
		 $kmag          <$k_criterion){
		printf(OUT "%5d %f %f %6.3f %5.3f\n",
			    $idname, # idname
			    $ra,     # ra [degree]
			    $dec,    # dec [degree]
			    $mag,    # kmag or corrected kmag [mag]
			    $kmag_e  # kerr [mag]
			    );
	    }else{
		printf(STDERR "Hi %10.2f%10.2f%10.2f\n"
		   ,$jmag-$hmag
		   ,$hmag-$kmag,
		   $mag) if($verbose>0);
	    }
	}
    }
}
close(OUT);
