#!/usr/local/bin/perl
# formatlog.pl -- To format the original observing log file
# Created: Yoshifusa Ita, 14-Jul-05
# 18-Sep-05 - Add MIR filter name check (Y. Ita)

# File Open
open(IN,   "header_temp")  || die "Cannot read header_temp"; 
open(OUT,  "> irclog.tmp") || die "Cannot write irclog.tmp";
open(OUT2, "> filter.tmp") || die "Cannot write filter.tmp";

# Add annotation
print OUT "# FRAME OBJECT NAXIS1 FILTER RA-SET DEC-SET AOT EXPID IDNUM SUBID\n";

while ($line = <IN>){
    chomp $line; # $B2~9T5-9f$r$H$k(B
    @h=split(/\t/,$line); # $B%?%V5-9f$G%i%$%sJ,3d(B
    $filename=(split(/\./,$h[0]))[0]; # $BKvHx$N(B.fits$B$r$H$j$?$$(B

    # MIR$B$N%U%#%k%?>pJs$rF@$k(B
    if($h[7] =~ "MIRS"){ # MIRS$B$@$C$?$i(B
	@h[3] = (split(/,/,$h[3]))[0]; # $B%U%#%k%?L>$rD4$Y$k(B
    }elsif($h[7] =~ "MIRL"){ # MIRL$B$@$C$?$i(B
	@h[3] = (split(/,/,$h[3]))[1];
    }

    print OUT "$filename $h[1] $h[2] $h[3] $h[4] $h[5] $h[6] $h[8] $h[9] $h[10]\n";
    print OUT2 "$filename $h[3]\n";
}

close(OUT);
close(OUT2);
close(IN);
