#!/usr/local/bin/perl
# get2mass.pl -- To retrieve 2mass all sky survey catalog data 
#                from the VizieR upon request
# Usage: get2mass.pl 05:25:33.4 -69:19:30.0 10.0
# Created: Yoshifusa Ita, 19-Dec-05
# Modified by Wada, 2007/07/28 look for backup sites, options, help...
#                              jis->euc
# Modified by Wada, 2007/08/05 connect-timeout
# Modified by Wada, 2007/10/10 maximum time for the job

# default verbose level:  =zero no debug message, >zero....
$debug=0;
#$debug=1;

#$time_out=0; #try forever
$time_out=30; # wait 30 sec to connect, then try the other site..

$time_max=3600; # wait 3600 sec to finish the job, then try the other site..

# default 2mass server site 
#$site="vizier.u-strasbg.fr";
$site="vizier.nao.ac.jp";
	  
# backup  2mass server sites 
#@sites=qw("vizier.u-strasbg.fr"
#	  "vizier.nao.ac.jp" 
#	  "vizier.hia.nrc.ca" 
#	  "vizier.ast.cam.ac.uk" 
#	  "vizier.iucaa.ernet.in" 
#	  "data.bao.ac.cn" 
#	  "vizier.cfa.harvard.edu" 
#	  "vizier.ukirt.jach.hawaii.edu");
@sites=qw(vizier.u-strasbg.fr
	  vizier.nao.ac.jp 
	  vizier.hia.nrc.ca 
	  vizier.ast.cam.ac.uk 
	  vizier.iucaa.ernet.in 
	  data.bao.ac.cn 
	  vizier.cfa.harvard.edu 
	  vizier.ukirt.jach.hawaii.edu);

# default output file name
$out_file="2mass.out";

sub help{
    printf(STDERR "Usage:   get2mass.pl alpha(deg) delta(deg)  fov(arcmin)\n");
    printf(STDERR "example: get2mass.pl 12.34 -12.34 10.0\n");
    printf(STDERR "Options:\n");
    printf(STDERR "  -h: print help\n");
    printf(STDERR "  -s server: 2mass catalog site name, the default is %s\n",$site);
    printf(STDERR "  -o output: output catalog file name, the default is %s\n",$out_file);
    printf(STDERR "  -v verbose_level: output debug message if not 1, the default is %d\n",$debug);
    printf(STDERR "  -c connection_timeout: the default is %d\n",$time_out);
    printf(STDERR "  -m maximum_timeout: the default is %d\n",$time_max);
}

use Getopt::Std;
getopts('hs:o:v:c:m:',\%options); #%options̵ϡopt_dͤꤵ
if(defined $options{h}){
    &help();
    exit(0);
}
if(defined $options{s}){
    $site=$options{s};
}
if(defined $options{o}){
    $out_file=$options{o};
}
if(defined $options{c}){
    $time_out=$options{c};
}
if(defined $options{m}){
    $time_max=$options{m};
}
if(defined $options{v}){
    $debug=$options{v};
}

if(@ARGV < 3){
    die "Usage: get2mass.pl 12.34 -12.34 10.0\n";
}

$ra  = $ARGV[0]; # ra  [degree]
chomp $ra;
$dec = $ARGV[1]; # dec [degree]
chomp $dec;
$box = $ARGV[2]; # box [arcmin]
chomp $box;
printf(STDERR "%s %s %s\n",$ra,$dec,$box) if($debug);

$url = sprintf("\"http://%s/viz-bin/asu-acl?-source=2MASS&-c.ra=%s&-c.dec=%s&-c.bm=$box&-out.max=99999\"",$site,$ra,$dec);
printf(STDERR "%s\n",$url) if($debug);

print "Now retrieving and downloading 2mass catalog data\n";
#system("curl -# -o 2mass.out -O $url");
#$result=system("curl -# -o $out_file -O $url");
$result=system("curl --connect-timeout $time_out --max-time $time_max -# -o $out_file -O $url");
$result/=256;
printf(STDERR "exit code is %d\n",$result) if($debug) ;
if($result ==0){ 
    exit;    
}
printf(STDERR "Failed to access 2mass server. Try backups\n");

for($i=0;$i<$#sites;$i++){
    $url = sprintf("\"http://%s/viz-bin/asu-acl?-source=2MASS&-c.ra=%s&-c.dec=%s&-c.bm=$box&-out.max=99999\"",$sites[$i],$ra,$dec);
    printf(STDERR "%s\n",$url) if($debug);
    print "Now retrieving and downloading 2mass catalog data\n";
#    $result=system("curl -# -o $out_file -O $url");
    $result=system("curl --connect-timeout $time_out  --max-time $time_max -# -o $out_file -O $url");
    $result/=256;
    printf(STDERR "exit code is %d\n",$result) if($debug);
    if($result ==0){
	exit;    
    }
}
printf(STDERR "Failed to access backup 2mass servers.\n");
exit;


# Strasbourg, France 
# $url = "\"http://vizier.u-strasbg.fr/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";
# Tokyo Japan
#$url = "\"http://vizier.nao.ac.jp/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";
# Canada
#$url = "\"http://vizier.hia.nrc.ca/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";
# UK, Cambridge
#$url = "\"http://vizier.ast.cam.ac.uk/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";
# India, Pune
#$url = "\"http://vizier.iucaa.ernet.in/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";
# China
#$url = "\"http://data.bao.ac.cn/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";
# Harvard, USA
#$url = "\"http://vizier.cfa.harvard.edu/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";
# Hawaii, USA
#$url = "\"http://vizier.ukirt.jach.hawaii.edu/viz-bin/asu-acl?-source=2MASS&-c.ra=${ra}&-c.dec=${dec}&-c.bm=$box&-out.max=99999\"";


#printf("%s\n",$url);

print "Now retrieving and downloading 2mass catalog data\n";
system("curl -# -o 2mass.out -O $url");
print "\n";

