#!/usr/local/bin/perl
# mkdark.pl -- To sort dark image
# Created: Yoshifusa Ita, 16-Sep-05

# File Open
open(IN, "filename.list") || die "Cannot read filename.list"; 
open(NIR_S, "> nir_shrt.list") || die "Cannot write nir_shrt.list";
open(NIR_L, "> nir_long.list") || die "Cannot write nir_long.list";
open(MRS_S, "> mrs_shrt.list") || die "Cannot write mrs_shrt.list";
open(MRS_L, "> mrs_long.list") || die "Cannot write mrs_long.list";
open(MRL_S, "> mrl_shrt.list") || die "Cannot write mrl_shrt.list";
open(MRL_L, "> mrl_long.list") || die "Cannot write mrl_long.list";


# Write file

while (<IN>){
    chomp; 
    @buf1=split(/\t/,$_); 
    if($buf1[1] =~ "NIR"){ # NIR
	if($buf1[2] == 1){ # Short exposure
	    printf NIR_S ("%s\n", $buf1[0]);
	}else{ # Long exposure
	    printf NIR_L ("%s\n", $buf1[0]);
	}	    
    }elsif($buf1[1] =~ "MIRS"){ # MIRS
	if($buf1[2] == 1){ # Short exposure
	    printf MRS_S ("%s\n", $buf1[0]);
	}else{ # Long exposure
	    printf MRS_L ("%s\n", $buf1[0]);
	}	    
    }elsif($buf1[1] =~ "MIRL"){ # MIRL
	if($buf1[2] == 1){ # Short exposure
	    printf MRL_S ("%s\n", $buf1[0]);
	}else{ # Long exposure
	    printf MRL_L ("%s\n", $buf1[0]);
	}	    
    } 
}

close(IN);
close(NIR_S);
close(NIR_L);
close(MRS_S);
close(MRS_L);
close(MRL_S);
close(MRL_L);
