#!/usr/local/bin/perl

$gain = $ARGV[0];
chomp $gain;
$pixscale = $ARGV[1];
chomp $pixscale;
$seeing = $ARGV[2];
chomp $seeing;

open(OUT, "> default.param") || die "default.param";
print OUT ("X_IMAGE\nY_IMAGE\nMAG_AUTO\n");
close(OUT);

open(OUT, "> default.sex") || die "default.sex";
@a=`sex -dd`;
$n=@a;
for($i=0;$i<$n;$i+=1){
    next if ( $a[$i] !~ m/^[a-zA-Z]/);
    ($kw,$val)=(split(/\s+/,$a[$i]))[0,1];
    if( $kw =~ m/^CATALOG_TYPE$/ ){
	print OUT ("CATALOG_TYPE ASCII\n");
    }elsif( $kw =~ m/^DETECT_THRESH$/ ){
	print OUT ("DETECT_THRESH 1.05\n");
    }elsif( $kw =~ m/^ANALYSIS_THRESH$/ ){
	print OUT ("ANALYSIS_THRESH 1.05\n");
    }elsif( $kw =~ m/^FILTER$/ ){
	print OUT ("FILTER N\n");
    }elsif( $kw =~ m/DEBLEND_NTHRESH$/ ){
	print OUT ("DEBLEND_NTHRESH 64\n");
    }elsif( $kw =~ m/DEBLEND_MINCONT$/ ){
	print OUT ("DEBLEND_MINCONT 0.000001\n");
    }elsif( $kw =~ m/CLEAN$/ ){
	print OUT ("CLEAN N\n");
    }elsif( $kw =~ m/MAG_ZEROPOINT$/ ){
	print OUT ("MAG_ZEROPOINT 20\n");
    }elsif( $kw =~ m/GAIN$/ ){
	print OUT ("GAIN $gain\n");
    }elsif( $kw =~ m/PIXEL_SCALE$/ ){
	print OUT ("PIXEL_SCALE $pixscale\n");
    }elsif( $kw =~ m/SEEING_FWHM$/ ){
	print OUT ("SEEING_FWHM $seeing\n");
    }else{
	print OUT ("$a[$i]");
    }
}
close(OUT);
