## pipeline1.cl -- IRC imaging data reduction pipeline step1
##                 based on pipeline.cl created by Y. Ita
## created: F. Egusa, 2010/09/02, introduced 'blank' parameter
## modified: 2010/10/13 (F. Egusa), add 'newflat.cl', 'makelist.cl'
##	     2010/10/18 (F. Egusa), the calibration order corrected (w->n->l->D)
##           2010/11/08 (F. Egusa), add 'subsky' option
##	     2010/11/11 (F. Egusa), add 'smdark' option
##           2010/12/01 (F. Egusa), set max value for BLANK
##	     2010/12/13 (F. Egusa), add 'delsmd' option
##	     2011/02/09 (F. Egusa), add 'subLscat' option
## updated: 2013/10/01 (F. Egusa)
##          stop if the logfile is empty
## 2014/02/28 (F. Egusa) - add 'pllog' option
## 2015/01/23 (F. Egusa) - stop if ../dark needed but not found
## 2015/03/03 (F. Egusa) - stop if no imaging frames in the logfile

procedure pipeline1

string  ircconst 	 {"constants.database", prompt="IRC constants database file name"}
string 	obslog 		 {"irclog", prompt="output of mkirclog"}
bool 	cosmicray = yes  {prompt="Detect and replace cosmic rays?"}
bool 	interactive = no {prompt="Run pipeline interactively?"}
bool 	deltemp = yes    {prompt="Delete temporary files?"}
bool 	verbose = no     {prompt="Print verbose progress messages?"}
real    blankvalue       {-9999.9,max=-1000., prompt="value for blank/masked pixels"}
string  darktype         {'ne',prompt="type of dark: ne (neighbor), su (super), se (self), us (user)"}
string  darkfile         {"userdark.dat", prompt="list of dark files when darktype=us"}
bool	smdark = yes	 {prompt="Apply self-made dark for NIR-long?"}
bool	delsmd = yes	 {prompt="Delete proccessed self-made dark for each frame?"}
bool	subsky = yes	 {prompt="Subtract constant sky?"}
bool   subLscat = yes	 {prompt="Subtract scattered light pattern in MIR-L?"}
string  pllog {'ircpipeline.log',prompt='log file for pipeline processes'}

string  mode="al"

begin
 string irc_const
 string logfile,flog
 bool  ia, verb, deltmp, cosmic, sub_sky, sm_dark, del_smd, sub_L
 string ans
 string prefix = ""
 real blank
 string dtype, darklist
 int nfits
 string date,time

## Get query parameters
 irc_const = ircconst
 logfile = obslog
 ia = interactive
 deltmp = deltemp
 verb = verbose
 cosmic = cosmicray
 blank = blankvalue
 dtype = darktype
 sub_sky = subsky
 sm_dark = smdark
 del_smd = delsmd
 sub_L = subLscat
 flog=pllog
 if (dtype == "us")  { 
    darklist = darkfile
 } else {
    darklist = "dark.list"
 }


## make sure that prepipeline has been processed.
 if( !access(logfile) ){
	print ("You should run prepipeline first.")
	bye
 }

## stop if the logfile is empty. (2013/10/01, FE)
## or no imaging frames are recorded. (2015/03/03, FE)
# print('! wc '//logfile) | cl | scan(nfits)
 print('! grep -v "#" '//logfile//' | wc') | cl | scan(nfits)
 if (nfits==0) {
    print("### ERROR: '"//logfile//"' is empty or has no imaging frames!")
    bye
 }

## stop if neighbor dark will be used but no "../dark/" found (2015/01/23, FE)
 if (dtype=='ne') {
    if (! access('../dark')) {
       print('### ERROR: ../dark/ not found!')
       bye
    }
 }


 print ("\n")
 print ("### PIPELINE step1 ###\n")
 print ("IRC imaging data reduction pipeline start...\n")

 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('\n- %s %s\n',date,time, >> flog)
 print('pipeline1(ircconst='//irc_const//',obslog='//logfile//',cosmicray='//cosmic//',interactive='//ia//',deltemp='//deltmp//',verbose='//verb//',blankvalue='//blank//',darktype='//dtype//',darkfile='//darklist//',smdark='//sm_dark//',delsmd='//del_smd//',subsky='//sub_sky//',subLscat='//sub_L//',pllog='//flog//')', >> flog)

## if interactive = yes
 if (ia) print("Pipeline runs in INTERACTIVE mode\n")


## make a list of input files for each filter & exposure
 if(ia){
	print("\n \nMake a list of input files.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("MAKELIST is skipped.\n") ; prefix = ""//prefix ; goto next01
	}
 }
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' makelist(logfile='//logfile//')', >> flog)
 makelist(logfile)


next01:
## Correct wraparound pixels
## add prefix of "w"
 if(ia){
	print("\n \nCorrect wraparound pixels.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("WRAPAROUND is skipped.\n") ; prefix = ""//prefix ; goto next02
	}
 }
## set deltmp=no to keep the original images!
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' wraparound(ircconst='//irc_const//',logfile='//logfile//',prefixs='//prefix//',deltemp=no,verbose='//verb//')', >> flog)
 wraparound(irc_const, logfile, prefix, no, verb); prefix = "w"//prefix


next02:
## Fowler sampling/bit shift renormalization
## add prefix of "n"
 if(ia){
	print("\n \nFowler sampling/bit shift renormalization.\n")
	print("Proceed ? -> y/e (Yes/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        } # ircnorm must be done and cannot be skipped.
 }
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' ircnorm(ircconst='//irc_const//',logfile='//logfile//',prefixs='//prefix//',deltemp='//deltmp//',verbose='//verb//')', >> flog)
 ircnorm(irc_const, logfile, prefix, deltmp, verb) ; prefix = "n"//prefix


## Linearize 
## add prefix of "l"
## 0 value pixels -> 0
 if(ia){
	print("\n \nLinearity correction.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("LINEARITY CORRECTION is skipped.\n") ; prefix = ""//prefix ; goto next03
	}
 }
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' linearity(ircconst='//irc_const//',logfile='//logfile//',prefixs='//prefix//',deltemp='//deltmp//',verbose='//verb//')', >> flog)
 linearity(irc_const, logfile, prefix, deltmp, verb); prefix = "l"//prefix


next03:
## Dark subtraction
## add prefix of "D"
## wraparound, ircnorm, linearity are applied to dark image before subtraction
 if(ia){
	print("\n \nDark subtraction.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("DARK SUBTRACTION is skipped.\n") ; prefix = ""//prefix ; goto next04
	}
 }
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' dark(ircconst='//irc_const//',darkfile='//darklist//',logfile='//logfile//',prefixs='//prefix//',darktype='//dtype//',deltemp='//deltmp//',verbose='//verb//',smdark='//sm_dark//',delsmd='//del_smd//')', >> flog)
 dark(irc_const,darklist,logfile,prefix,dtype,deltmp,verb,sm_dark,del_smd)
 prefix = "D"//prefix


next04:
## Subtract scattered light pattern
## add prefix of "c"
 if(ia){
	print("\n \nSubtract scattering light pattern.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("SCATTERING LIGHT PATTERN SUBTRACTION is skipped.\n") ; prefix = ""//prefix ; goto next05
	}
 }
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' scatt_light(ircconst='//irc_const//',logfile='//logfile//',prefixs='//prefix//',deltemp='//deltmp//',verbose='//verb//')', >> flog)
 scatt_light(irc_const, logfile, prefix, deltmp, verb) ; prefix = "c"//prefix


next05:
## Cosmic ray rejection
## add prefix of "C"
 if(ia){
	print("\n \nDetect and replace cosmic rays in MIRS images.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("COSMICRAY is skipped.\n") ; prefix = ""//prefix ; goto next06
	}else{
		cosmic = yes
	}
 }
 if (cosmic) {
    print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
    printf('- %s %s\n',date,time, >> flog)
    print(' cosmic_ray(ircconst='//irc_const//',logfile='//logfile//',prefixs='//prefix//',deltemp='//deltmp//',verbose='//verb//')', >> flog)
    cosmic_ray(irc_const, logfile, prefix, deltmp, verb) ; prefix = "C"//prefix
 }


next06:
## new flat correction
## (if sub_sky = yes, subtract constant sky)
## (if sub_sky = yes & sub_L = yes, subtract sky with old flat and then devide by new flat)
## add prefix of "f"
 if(ia){
        print("\n \n Flat fielding.\n")
        print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
        ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
                bye
        }else if(ans=="s"||ans=="S"){
                print("FLAT FIELDING is skipped.\n") ; prefix = ""//prefix ; goto finish
        }
 }
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' flat(ircconst='//irc_const//',logfile='//logfile//',prefixs='//prefix//',blank='//blank//',deltemp='//deltmp//',verbose='//verb//',subsky='//sub_sky//',subLscat='//sub_L//',pllog='//flog//')', >> flog)
 flat(irc_const, logfile, prefix, blank, deltmp, verb, sub_sky, sub_L,flog) ; prefix = "f"//prefix



finish:
# Finish
 print ("\n")
 print ("### PIPELINE step1 finished!! ###\n")


end
