## pipeline2.cl -- IRC imaging data reduction pipeline step2
##                 based on pipeline.cl created by Y. Ita
## created: F. Egusa, 2010/10/25
## modified: 2010/12/01 (F. Egusa), not to delete the original input files
##                                  set max value for BLANK
## updated: 2013/10/01 (F. Egusa)
##          stop if the logfile is empty
## 2014/03/03 (F. Egusa) - add 'double','ndmask','ndhot','pllog' options
## 2014/03/12 (F. Egusa) - add 'tolerance', 'wipestar' for putwcs, 
##   and add 'fluxcal'
## 2015/01/23 (F. Egusa) - stop if ../dark needed but not found
## 2015/03/03 (F. Egusa) - stop if no imaging frames in the logfile

procedure pipeline2

string  ircconst 	 {"constants.database", prompt="IRC constants database file name"}
string 	com_mode 	 {"median", prompt="combine mode: average/median"}
int	com_area 	 {2,min=1,max=2, prompt="stack area: 1:common area 2:whole area"}
int	sky_area 	 {2,min=1,max=2, prompt="sky matching area: 1:common area 2:whole area"}
real    det_sig          {3.,min=1.,max=1000., prompt="Threshold in sigma for source detection"}
real    sig_rej          {3.,min=0.,max=100., prompt="Rejection unit in sigmas"}
int     max_itr          {10,min=1,max=10, prompt="Maximum number of iterations"}
string 	obslog 		 {"irclog", prompt="output of the mkirclog"}
bool 	wcs = no         {prompt="Try to compute wcs and write it in the header?"}
bool 	coaddshort = no  {prompt="Coadd short exposure frames?"}
bool 	interactive = no {prompt="Run pipeline interactively?"}
bool 	deltemp = yes    {prompt="Delete intermediate files?"}
string  rejection        {"sigclip", prompt="rej in coadd:minmax|ccdclip|crreject|sigclip|avsigclip|pclip|none"}
bool    rej_sky = yes    {prompt="Remove image(s) with outlier sky level?"}
bool    skip_L = no      {prompt="Skip coadding MIRL images?"}
bool    submedsky = no   {prompt="Subtract median filtered sky in adjust_sky?"}
bool 	coadd   = yes    {prompt="Coadd?"}
bool 	verbose = no     {prompt="Print verbose progress messages?\n"}
string  prefixs          {"fCcDlnw", prompt="Prefix after pipeline1"}
real    blankvalue       {-9999.9,max=-1000., prompt="value for blank/masked pixels"}
bool    double = yes     {prompt="Double the image size?"}
bool    ndmask = yes {prompt="Mask hot pixels in neighbor dark?"}
real    ndhot    {500.,prompt="Lowest value for hot pixels in neighbor dark"}
string  pllog {'ircpipeline.log',prompt='log file for pipeline processes'}
real    tolerance {1.5, min=0.1, max=10.0, prompt="The WCS matching tolerance in arcsec"}
real    wipestar = 0.0 {prompt="The searching radius in pixels for pre-selection of xyxymatch in putwcs (0.0: disable)"}
bool	fluxcal = yes     {prompt='Apply flux calibration factor?'}

string  mode="al"
struct 	*list0

begin
 string irc_const
 string commode
 int comarea
 int skyarea
 real detsig
 real sigrej
 int maxitr
 string logfile
 bool coadd_short, ia, verb, deltmp, setwcs, rejsky, skipl, sub_medsky, coadd_frames, cosmic, dpix, nmask,fcal
 string ans
 string rejtype
 string prefix, flog
 real blank, nhot, tole, wipe_stars
 int nfits
 string date,time


## Get query parameters
 irc_const = ircconst
 commode = com_mode
 comarea = com_area
 skyarea = sky_area
 detsig = det_sig
 sigrej = sig_rej
 maxitr = max_itr
 logfile = obslog
 setwcs = wcs
 coadd_short = coaddshort
 ia = interactive
 deltmp = deltemp
 rejtype = rejection
 verb = verbose
 rejsky = rej_sky
 sub_medsky = submedsky
 skipl = skip_L
 coadd_frames=coadd
 prefix = prefixs
 blank = blankvalue
 dpix=double
 nmask=ndmask
 nhot=ndhot
 flog=pllog
 tole=tolerance
 wipe_stars = wipestar
 fcal=fluxcal


# make sure that prepipeline has been processed.
 if( !access(logfile) ){
	print ("You should run prepipeline first.")
	bye
 }

## stop if the logfile is empty. (2013/10/01, FE)
## or no imaging frames are recorded. (2015/03/03, FE)
# print('! wc '//logfile) | cl | scan(nfits)
 print('! grep -v "#" '//logfile//' | wc') | cl | scan(nfits)
 if (nfits==0) {
    print("### ERROR: '"//logfile//"' is empty or has no imaging frames!")
    bye
 }

## stop if "../dark/" needed but not found (2015/01/23, FE)
 if (nmask) {
    if (! access('../dark')) {
       print('### ERROR: ../dark/ not found!')
       bye
    }
 }


 print ("\n")
 print ("### PIPELINE step2 ###\n")
 print ("IRC imaging data reduction pipeline start...\n")

 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('\n- %s %s\n',date,time, >> flog)
 printf('pipeline2(ircconst=%s,com_mode=%s,com_area=%d,sky_area=%d,det_sig=%.0f,sig_rej=%.0f,max_itr=%d,obslog=%s,wcs=%b,coaddshort=%b,interactive=%b,deltemp=%b,rejection=%s,rej_sky=%b,skip_L=%b,submedsky=%b,coadd=%b,verbose=%b,prefixs=%s,blankvalue=%.1f,double=%b,ndmask=%b,ndhot=%.1f,pllog=%s,tolerance=%.1f,wipestar=%.1f,fluxcal=%b)\n',irc_const,commode,comarea,skyarea,detsig,sigrej,maxitr,logfile,setwcs,coadd_short,ia,deltmp,rejtype,rejsky,skipl,sub_medsky,coadd_frames,verb,prefix,blank,dpix,nmask,nhot,flog,tole,wipe_stars,fcal, >> flog)

## if interactive = yes
 if (ia) print("Pipeline runs in INTERACTIVE mode\n")


## mask hot/bad pixels, slit area, saturated pixels
## add prefix of "m"
## add 'blank' in the header
 if(ia){
        print("\n \n Masking hot/bad pixels, slit area, saturated pixels.\n")
        print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
        ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
                bye
        }else if(ans=="s"||ans=="S"){
                print("MASKING is skipped.\n") ; prefix = ""//prefix ; goto next01
        }
 }
 ## set deltmp = no to keep the original inputs
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 printf(' maskall(ircconst=%s,logfile=%s,prefixs=%s,blankval=%.1f,deltemp=NO,verbose=%b,ndmask=%b,ndhot=%.1f,pllog=%s)\n',irc_const,logfile,prefix,blank,verb,nmask,nhot,flog, >> flog)
 maskall(irc_const, logfile, prefix, blank, no, verb,nmask,nhot,flog) ; prefix = "m"//prefix


next01:
## Aspect ratio resampling
## add prefix of "e"
## resampled to 1:1
 if(ia){
	print("\n \nResample aspect ratio.\n")
	print("Proceed ? -> y/e (Yes/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }
 }
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 printf(' aspect_ratio(ircconst=%s,logfile=%s,prefixs=%s,blankval=%.1f,deltemp=%b,verbose=%b,double=%b)\n',irc_const,logfile,prefix,blank,deltmp,verb,dpix, >> flog)
 aspect_ratio(irc_const, logfile, prefix, blank, deltmp, verb,dpix) ; prefix = "e"//prefix


next02:
## Coadd
 if(ia){
	print("\n \nStack images and put wcs.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		goto finish
        }else if(ans=="s"||ans=="S"){
		print("Image stacking is skipped.\n") ; goto finish
	}else{
		coadd_frames = yes
	}
 }
 if (coadd_frames) {
    print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
    printf('- %s %s\n',date,time, >> flog)
    printf(' coadd(ircconst=%s,det_sig=%.1f,sig_rej=%.1f,max_itr=%d,com_mode=%s,com_area=%d,sky_area=%d,logfile=%s,prefixs=%s,rejection=%s,rej_sky=%b,coaddshort=%b,wcs=%b,skip_L=%b,submedsky=%b,deltemp=%b,verbose=%b,blankval=%.1f,pllog=%s,double=%b,tolerance=%.1f,wipestar=%.1f)\n',irc_const,detsig,sigrej,maxitr,commode,comarea,skyarea,logfile,prefix,rejtype,rejsky,coadd_short,setwcs,skipl,sub_medsky,deltmp,verb,blank,flog,dpix,tole,wipe_stars, >> flog)
    coadd(irc_const, detsig, sigrej, maxitr, commode, comarea, skyarea, logfile, prefix, rejtype, rejsky, coadd_short, setwcs, skipl, sub_medsky, deltmp, verb,blank,flog,dpix,tolerance=tole,wipestar=wipe_stars)

    if (fcal) {
       print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
       printf('- %s %s\n',date,time, >> flog)
       printf(' calflux(ircconst=%s,logfile=%s,blankval=%.1f,overwrite=NO)\n',irc_const,logfile,blank, >> flog)
       calflux(ircconst=irc_const,logfile=logfile,blankval=blank,over-)
    }
 }



finish:
## Finish
 print ("\n")
 print ("### PIPELINE step2 finished!! ###\n")
 print ("\n\n")

 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print('  all pipeline processes successfully ended', >> flog)

end
