# adjust_sky.cl -- To adjust sky level
# Created: Yoshifusa Ita, 19-Oct-05
# Updated: Yoshifusa Ita, 18-Aug-06 add subtracting median sky mode
#				    add a function to reject images taken during maneuver
# Add a function to consider sky with structure: Yoshifusa Ita, 16-Jan-06
## modified: 2010/10/27 (F. Egusa), keep 'blank' value in sky-adjusted images
##           2011/07/22 (F. Egusa), skip non-existent files
##           2013/11/15 (F. Egusa), skip if no valid shift values for all frames
## 2014/03/04 (F. Egusa) - add 'nb' option

## note: prefixs not used

procedure adjust_sky (prefixs, badconst, list_name, sky_area, data_max, sig_rej, max_itr, rej_sky, submedsky, verbose,nb)
string  mode="al"

string prefixs    {"SemfCcDlnw", prompt="Prefix of the filename"}
real   badconst   {-9999.9,min=-100000.0,max=0., prompt="constants for bad/no data"}
string list_name  {"pair0001_L15.list_long", prompt="list name to be matched"}
int    sky_area   {2,min=1,max=2, prompt="sky matching area: 1:common area 2:whole area"}
real   data_max   {50000.,min=0.,max=60000., prompt="Initial upper limit for data range [ADU]"}
real   sig_rej    {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
int    max_itr    {10,min=1,max=10, prompt="Maximum number of iterations"}
bool   rej_sky = yes   {prompt="Reject image(s) with outlier sky level?"}
bool   submedsky = no  {prompt="Subtract median filtered sky?"}
bool   verbose = no    {prompt="Print verbose progress messages?"}
int    nb         {128,prompt='number of pixels of the border'}

bool   rmmedsky = yes  {prompt="remove (delete) median filtered image?"}
int    x_box      {20,min=1,max=100, prompt="If submedsky=yes, x box car size"}
int    y_box      {20,min=1,max=100, prompt="If submedsky=yes, y box car size\n"}

struct *list0

begin

 real lower, upper, ll, ul
 real sigrej
 int maxitr, skyarea,nborder
 string area, detector, outname
 string listname, outlist, image, prefix, text
 int i, npix, nid
 real mean, median, modee, sigma
 bool verb, sub_medsky, rm_medsky, rejsky
 real dx, dy, angle
 real dxmax, dxmin, dymax, dymin
 int naxis1, naxis2, xmax, xmin, ymax, ymin
 real all_median, all_sigma, adsky
 int xbox, ybox


## Get query parameter
 prefix = prefixs
 listname = list_name
 skyarea = sky_area
 upper = data_max
 lower = badconst
 sigrej = sig_rej
 maxitr = max_itr
 rejsky = rej_sky
 verb = verbose
 sub_medsky = submedsky
 nborder=nb

 rm_medsky = rmmedsky
 xbox = x_box
 ybox = y_box


# get sky value
 outlist = "sky"//listname
 if (access(outlist)) delete(outlist, ver-)
# $B$^$:!"(Bmatching$B$K@.8y$7$?$b$N$K$D$$$F$N$_!"%9%+%$$NCM$rD4$Y$k!#(B
 if (!access(listname//".shift")) {
    print("Warning: File "//listname//".shift not found and skipped.")
    goto scriptend
 }
 printf("! sed -e \'s/.fits.coo.1//g\' %s > %s\n", listname//".shift", listname//".shift.0") | cl
 list0 = listname//".shift.0"
 while (fscan (list0, image, dx, dy, angle, nid) != EOF) {
    if (nid > 1) {
       text = "R"//image//".fits"
       if (!access(text)) {
       	  print("Warning: File "//text//" not found and skipped.")
	  goto nextfile
       }
       hselect(text, fields="DETECTOR", expr="yes") | scan(detector)
       hselect(text,fields='NAXIS1,NAXIS2',exp='yes') | scan(naxis1,naxis2)
       if (skyarea == 1) { # exclude the border area
          xmin=nborder+1
	  ymin=xmin
	  xmax=naxis1-nborder
	  ymax=naxis2-nborder
       } else { # use the entire image
          xmin=1
	  ymin=xmin
	  xmax=naxis1
	  ymax=naxis2
       }
       area = "["//xmin//":"//xmax//","//ymin//":"//ymax//"]"
## 2010/10/27 (FE) add margin of 0.1 for upper & lower limits
       imstat(text//area, fields="npix,mean,midpt,mode,stddev", lower=lower+0.1, upper=upper-0.1, nclip=maxitr, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
       i = 0
       while (i < maxitr) {
          ll = mean - (sigrej*sigma)
	  ul = mean + (sigrej*sigma)
	  if (lower != INDEF && ll < lower) ll = lower + 0.1
	  if (upper != INDEF && ul > upper) ul = upper - 0.1
	  imstat(text//area, fields="npix,mean,midpt,mode,stddev", lower=ll, upper=ul, nclip=maxitr, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
	  i += 1
       }
       printf("%s %10.4f %10.4f %10.4f %10.4f\n",image,mean,median,modee,sigma, >> outlist)
    }
    nextfile:
 }


## 2013/11/15 (FE) skip the following procedures if shift values 
## not determined for all the frames
 print('! wc -l '//outlist) | cl | scan(nid)
 if (nid < 2) goto scriptend


# skypair $B%U%!%$%k$rD4$Y$F!"A42hA|$N(Bsky$B$NCM$H(Bsigma$B$r8+$F!"$=$N(Bmedian$B$rF@$k!#(B
 text = osfn("ircperl$")
 text = text//"median.sh"
 printf("! sh %s %s\n", text, outlist) | cl | scan(all_median, all_sigma)

# sky$B$,30$lCM$r;}$C$F$$$k%G!<%?$r$_$D$1$F%j%9%H$K$7$F$*$/!#(B
 if (rejsky) {
    if (access(listname//".maneuver")) delete(listname//".maneuver", ver-)
    list0 = outlist
    while (fscan (list0, image, mean, median, modee, sigma) != EOF) {
       if (median < all_median - all_sigma*5. || median > all_median + all_sigma*5.) {
          printf("A%s.fits\n",image, >> listname//".maneuver")
       }
    }
 }


## adjust sky
 list0 = outlist
 while (fscan (list0, image, mean, median, modee, sigma) != EOF) {
    text    = "R"//image//".fits"
    outname = "A"//image//".fits"
    if ( access(outname) ){ imdel(outname, ver-) }
    if (sub_medsky) {
       if ( access("median.fits") ){ imdel("median.fits", ver-) }
       median(text, "median.fits", xbox, ybox, zloreject=0., boundary="constant", constant=0., verbose=verb)
## 2010/10/27 (FE) keep the blank value (lower) after calculation
#      imarith(text, "-", "median.fits", outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
       imexpr("abs(a-c) > 0.1 ? a-b : c",outname,text,"median.fits",lower,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",verb-,intype='real')
       hedit(outname,"MED_SKY","YES",add+,delete-,ver-,show-,update+)
       if (!rm_medsky) {
       	  if (access("median"//image//".fits")) imdel("median"//image//".fits", ver-)
	  imrename ("median.fits", "median"//image//".fits", verbose=no)
       }
    } else {
## 2010/10/27 (FE) keep the blank value (lower) after calculation
#      imarith(text, "-", median, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
       imexpr("abs(a-c) > 0.1 ? a-b : c",outname,text,median,lower,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",verb-,intype='real')
    }
## 2010/10/27 (FE) keep the blank value (lower) after calculation
#   imarith(outname, "+", all_median, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
    if (access("tmp.fits")) imdel("tmp.fits")
    imexpr("abs(a-c) > 0.1 ? a+b : c","tmp.fits",outname,all_median,lower,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",verb-,intype='real')
    print("! mv -f tmp.fits "//outname) | cl
    adsky = all_median - median
    hedit(outname,"ADJ_SKY",adsky,add+,delete-,ver-,show-,update+)
 }


 scriptend:
 if (access("median.fits")) imdel("median.fits", ver-)

end
