## calcshift.cl -- To calculate shift and rotation value between images
# Created: Yoshifusa Ita, 28-Dec-05
## modified: 2010/10/27 (F. Egusa), introduced 'blankval' parameter & use drizzl
##           2010/11/10 (F. Egusa), handle shifted mask regions more robustly
##           2010/12/27 (F. Egusa), mask handling updated
##           2011/07/19 (F. Egusa), minor bug fixed
## 2014/03/04 (F.Egusa), add 'double' option
## 2014/04/22 (F.Egusa), selection by shift statistics for MIR-S & -L added
## 2014/11/17 (F.Egusa), selection updated to include IRC00
## 2015/01/19 (F.Egusa), selection scheme revised
## 2015/02/04 (F.Egusa), min of minstar and minmatch revised

## note: n_margin not used 

procedure calcshift(list_name, prefixs, sig_rej, max_itr, maxstar, minstar, minmatch, step, n_margin, verbose, blankval, double)
string  mode="al"

string list_name    {"long_exp.list", prompt="Name of the coadd list"}
string prefixs      {"SemfCcDlnw", prompt="Prefix of the filename"}
real   sig_rej      {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
int    max_itr      {10,min=1,max=10, prompt="Maximum number of iterations"}
int    maxstar      {100, min=10, max=5000, prompt="Max # of stars in xymatching"}
int    minstar      {7, min=7, max=15, prompt="Min # of stars in xymatching"}
int    minmatch     {7, min=7, max=5000, prompt="Min # of stars matched"}
int    step         {5, min=1, max=10, prompt="Step"}
int    n_margin     {0, min=0, max=100, prompt="Margin pixels from image edge"}
bool   verbose = no {prompt="Print verbose progress messages?"}
real   blankval     {-9999.9,max=-1000., prompt="value for blank pixels"}
bool   double = yes {prompt="Double the image size?"}
real   tolerance    {1.5, min=0.1, max=10.0, prompt="The matching tolerance in pixels"}
string ircconst     {"constants.database", prompt="IRC constants database file name"}

struct *list0
struct *list1

begin

 string listname, prefix, lname, filename, text, output
 real   sigrej, tole
 int    i, maxitr, max_star, min_star, min_match, stp, margin, n_refstar, n_inpstar
 int    naxis1, naxis2, n_matched
 string refname, inpname, aot
 real   dx, dy, mag, x_ref, y_ref, x_in, y_in, anglex, angley, xrms, yrms
 bool   verb, dpix
 string filter, detector
 real   ra, dec
 int    expid, idnum, preidnum, subid, presubid, multi, ndither
 real   xoffset, yoffset, rotation, refrot, angle
 real   limit
 real thblank,blank
 string irc_const,libpath
 real xmean[4],ymean[4],amean
 real xlow[4],xup[4],ylow[4],yup[4],alow,aup
 real p1,p2,p3,p4,dxlow,dxup,dylow,dyup

## Get query parameters
 listname = list_name
 prefix = prefixs
 sigrej = sig_rej
 maxitr = max_itr
 max_star = maxstar
 min_star = minstar
 min_match = minmatch
 stp = step
 margin = n_margin
 verb = verbose
 blank=blankval
 dpix = double

 tole = tolerance 
 irc_const = ircconst

## set default/initial parameters
 naxis1 = 0
 naxis2 = 0
 thblank = -0.1

 libpath = osfn("irclib$")
 irc_const = libpath//irc_const
 print("! head -1 `head -1 "//listname//"` | awk '{print $8}'") | cl | scan(aot)
 if (aot=='IRC02' || aot=='IRC03') {
    print("! grep shift_x_IRC0203_mean "//irc_const) | cl | scan(text,p1,p2,p3,p4)
    xmean[1]=p1
    xmean[2]=p2
    xmean[3]=p3
    xmean[4]=p4
    print("! grep shift_x_IRC0203_ll "//irc_const) | cl | scan(text,p1,p2,p3,p4)
    xlow[1]=p1
    xlow[2]=p2
    xlow[3]=p3
    xlow[4]=p4
    print("! grep shift_x_IRC0203_ul "//irc_const) | cl | scan(text,p1,p2,p3,p4)
    xup[1]=p1
    xup[2]=p2
    xup[3]=p3
    xup[4]=p4
    print("! grep shift_y_IRC0203_mean "//irc_const) | cl | scan(text,p1,p2,p3,p4)
    ymean[1]=p1
    ymean[2]=p2
    ymean[3]=p3
    ymean[4]=p4
    print("! grep shift_y_IRC0203_ll "//irc_const) | cl | scan(text,p1,p2,p3,p4)
    ylow[1]=p1
    ylow[2]=p2
    ylow[3]=p3
    ylow[4]=p4
    print("! grep shift_y_IRC0203_ul "//irc_const) | cl | scan(text,p1,p2,p3,p4)
    yup[1]=p1
    yup[2]=p2
    yup[3]=p3
    yup[4]=p4
 } else if (aot=='IRC05' || aot=='IRC00') {
    print("! grep shift_x_IRC05_mean "//irc_const) | cl | scan(text,p1)
    xmean[1]=p1
    print("! grep shift_x_IRC05_ll "//irc_const) | cl | scan(text,p1)
    xlow[1]=p1
    print("! grep shift_x_IRC05_ul "//irc_const) | cl | scan(text,p1)
    xup[1]=p1
    print("! grep shift_y_IRC05_mean "//irc_const) | cl | scan(text,p1)
    ymean[1]=p1
    print("! grep shift_y_IRC05_ll "//irc_const) | cl | scan(text,p1)
    ylow[1]=p1
    print("! grep shift_y_IRC05_ul "//irc_const) | cl | scan(text,p1)
    yup[1]=p1
 }
 print("! grep angle_mean "//irc_const) | cl | scan(text,amean)
 print("! grep angle_ll	 "//irc_const) | cl | scan(text,alow)
 print("! grep angle_ul "//irc_const) | cl | scan(text,aup)


# calculate shift
 list0 = listname
 while (fscan (list0, lname) != EOF){
    list1 = lname
    i = 0              # file$BHV9f$r=i4|2=$9$k(B
    max_star = maxstar # max_star$B$r=i4|2=$9$k!#(B
    n_refstar = 0      # $B0LCV$N%j%U%!%l%s%9%$%a!<%8$G8!=P$5$l$?@1?t$r=i4|2=$9$k!#(B
    multi = 0          # $BJ#?t(Bpointing$B$r%+%&%s%H$9$k(Bcounter
    ndither = -1       # dithering$B2s?t$r%+%&%s%H$9$k(Bcounter
    preidnum = 0
    presubid = 0
    rotation = 0.0
    refrot   = 0.0
    if (access(lname//".shift")) delete(lname//".shift", ver-)
    while (fscan(list1,filename,filter,ra,dec,expid,idnum,subid,aot) != EOF) {
       text = prefix//filename//".fits"
       output = "R"//text # $B2sE>(B&$B%7%U%H8e$N2hA|$O(BR$B$r$D$1$k;v$K$9$k!#(B
       if (!access(text)) {
       	  print("Warning: File ",text," not found and skipped.")
	  goto nextfile
       }
       hselect(text, fields="DETECTOR", expr="yes") | scan(detector)

       # from here --> added 061021 $B2sE>3Q$H!"(Bxy$B%*%U%;%C%H$NM=B,CM$rF~$l$k(B
       # NIR$B$N$H$-$+$>$($9$.$K$J$k$,!"(BNIR$B$N$H$-$O=i4|9MN8$r$7$J$$$N$GL5;k$9$k!#(B
       if (expid == 1 || expid == 2) {
       	  ndither += 1
       }
       if (preidnum != idnum || presubid != subid) {
       	  multi   += 1
	  preidnum = idnum
	  presubid = subid
	  if (filter == "N2" || filter == "N3" || filter == "N4") {
	     hselect(text, fields="PA-N", expr="yes") | scan(rotation)
	  } else if (filter == "S7" || filter == "S9W" || filter == "S11") {
	     hselect(text, fields="PA-S", expr="yes") | scan(rotation)
	  } else if (filter == "L15" || filter == "L18W" || filter == "L24") {
	     hselect(text, fields="PA-L", expr="yes") | scan(rotation)
	  } else {
	     printf("Filter name is wrong.\n")
	     bye
	  }
       }

       # rotation$B$N=i4|CM(B
       angle = rotation - refrot

       # MIRS&L$B$N%G%#%6%j%s%0$K$h$k(Bxy$B%*%U%;%C%H$N(Bfirst guess[pixels]
       if (multi == 1) {
       	  # 1pointing$BL\$N%G!<%?$K$D$$$F$O(Bxyoffset$B$r9MN8(B
	  if (aot=="IRC02" || aot=="IRC03") {
	     if (ndither<4) {
	     	xoffset=xmean[ndither+1]
	     	yoffset=ymean[ndither+1]
		dxlow=xlow[ndither+1]
		dxup=xup[ndither+1]
		dylow=ylow[ndither+1]
		dyup=yup[ndither+1]
             } else {
	        xoffset=INDEF
		yoffset=INDEF
             }
	  } else if (aot=='IRC05' || aot=='IRC00') {
	     xoffset=xmean[1]
	     yoffset=ymean[1]
	     dxlow=xlow[1]
	     dxup=xup[1]
	     dylow=ylow[1]
	     dyup=yup[1]
	  } else {
	     xoffset=INDEF
	     yoffset=INDEF
	  }
	  limit = 50.0
       } else {
          # 2pointing$BL\0J9_$O!"2sE>3Q$@$19MN8(B
	  xoffset = INDEF
	  yoffset = INDEF
	  # 070627 limit=200.0 -> 800.0
	  limit = 800.0
       }

       ## for double-sized images (2014/03/04, FE)
       if (dpix) {
          if (xoffset != INDEF) {
	     xoffset=xoffset*2.
	     dxlow=dxlow*2.
	     dxup=dxup*2.
	  }
          if (yoffset != INDEF) {
	     yoffset=yoffset*2.
	     dylow=dylow*2.
	     dyup=dyup*2.
	  }
       }

       # <-- to here added 061021
       if (i == 0) { # $B%G%#%6%j%s%00LCV4p=`%U%l!<%`$@$C$?$i(B
       	  refrot = rotation
	  hselect(text, fields="NAXIS1, NAXIS2", expr="yes") | scan(naxis1, naxis2)
	  refname = text//".coo.1"
	  printf("! wc -l %s\n",refname) | cl | scan(n_refstar)
	  if (n_refstar < maxstar) {
	     max_star = n_refstar
	  } else {
	     max_star = maxstar
	  }
	  if (detector == "NIR") {
	     min_match = 15
	     stp = 5
	  } else {
	     if (detector == "MIRS") {
	     	min_match = minmatch
	     } else {
		min_match = 4
	     }
	     stp = 1
	  }
	  if (n_refstar <= 20) { # $B$b$H$b$H?t$,>/$J$$>l9g$O!">r7o$f$k$/$9$k!#(B
	     stp = 1
	     min_star = 7
	     min_match = 7
	     tole = 1.6
	  }
	  if( access("xy.reference") ){ delete("xy.reference", ver-) }
	  printf("! head -n %d %s > xy.reference \n", max_star, refname) | cl
	  printf("%s 0.0 0.0 0.0 %d\n", refname,n_refstar, >> lname//".shift")
	  if( access(output) ){ imdel(output, ver-) }
	  imcopy(text, output, verbose=no)

       } else { ## for 2nd and later frames (i>0)
          inpname = text//".coo.1"

	  # reference$B$K$b@1$,$9$/$J$9$.$F!"$=$b$=$b9g$o$;$i$l$=$&$K$J$$>l9g$OAa!9$K$"$-$i$a$k(B
	  if (n_refstar <= 4) goto fail 
	  # input$B$K:G=i$+$i@1$,$9$/$J$$>l9g$b!"Aa!9$K$"$-$i$a$k(B
	  printf("! wc -l %s\n",inpname) | cl | scan(n_inpstar)
	  if (n_inpstar <= 4) goto fail 
	  # if( max_star > n_inpstar ){ max_star = n_inpstar }

	  again:
	  if (max_star <= 30) { # $B>/$J$/$J$C$F$-$?$i%a%C%7%e$r:Y$+$/(B&$B>r7o$r4K$/$9$k(B
	     stp = 1
	     min_star = 7
	     min_match = 7
	     tole = 1.6
	  }

	  # printf("debug %s %d %d %d %d %d\n",inpname,n_refstar,n_inpstar,min_match,min_star,max_star)

	  if (max_star <= min_star) {
	     fail:
	     if (verb) {
		print("\t Matching failed!!!\n")
		printf("\t ref:%s inp:%s\n", refname, inpname)
	     }
#	     printf("%s 999.99 999.99 999.99 0\n", inpname, >> lname//".shift")
	     printf("%s 999.99 999.99 999.99 %d\n", inpname,-max_star, >> lname//".shift")
	     printf("Matching failed! (too few stars) ref: %s inp: %s\n", refname, inpname, >> "calcshift.log")
	     goto endloop
 	  }
	  if (access("xy.reference.tmp")) delete("xy.reference.tmp", ver-) 
	  printf("! head -n %d xy.reference > xy.reference.tmp\n", max_star) | cl
	  if (access("xy.inp")) delete("xy.inp", ver-)
	  printf("! head -n %d %s > xy.inp \n", max_star, inpname) | cl
	  if (access("matched")) delete("matched", ver-)
	  if (detector == "NIR") {
	     # 070104 separation=9.0 -> 10.0
	     # 070627 xyrotation=INDEF -> angle
	     # 070627 separation=10.0 -> 4.0
	     # 070627 ratio=10.0 -> 5.0
	     xyxymatch("xy.inp", "xy.reference.tmp", "matched", tole, refpoints="", xin=INDEF, yin=INDEF, xmag=1., ymag=1., xrotation=angle, yrotation=angle, xref=INDEF, yref=INDEF, xcolumn=1, ycolumn=2, xrcolumn=1, yrcolumn=2, separation=4., matching="triangles", nmatch=30, ratio=5., nreject=10, xformat="%13.4f", yformat="%13.4f", interactive=no, verbose=verb, icommands="")
          } else {
	     # printf("debug: x:%f y:%f r:%f\n",xoffset,yoffset,angle)
	     # 070615 ratio=10.0 -> 5.0
	     xyxymatch("xy.inp", "xy.reference.tmp", "matched", tole, refpoints="", xin=xoffset, yin=yoffset, xmag=1., ymag=1., xrotation=angle, yrotation=angle, xref=0.0, yref=0.0, xcolumn=1, ycolumn=2, xrcolumn=1, yrcolumn=2, separation=4., matching="triangles", nmatch=30, ratio=5., nreject=10, xformat="%13.4f", yformat="%13.4f", interactive=no, verbose=verb, icommands="")
	  }
	  ! sed -e '/^$/d' matched | sed -e '/#/d' > matched.tmp
	  if (!access("matched.tmp")) print("! touch matched.tmp\n") | cl
	  ! \mv matched.tmp matched
	  print("! wc -l matched\n") | cl | scan(n_matched)
 	  if (n_matched < min_match) {
  	     max_star -= stp
  	     goto again
 	  } else {
	     if (verb) {
		printf("\t Successfully %d stars matched!!\n", n_matched)
		printf("\t ref:%s inp:%s\n", refname, inpname)
             }
	     printf("%3d stars matched! ref: %s inp: %s\n", n_matched, refname, inpname, >> "calcshift.log")
	  }
          if (access("matched.inv")) delete("matched.inv", ver-)
	  fields("matched", "1,2,3,4", lines="1-", quit_if_miss=no, print_file_n=no, > "matched.inv" )
	  if (access("database")) delete("database", ver-)
	  if (access("summary.dat")) delete("summary.dat", ver-)
	  geomap("matched.inv", "database", 1, naxis1, 1, naxis2, transforms="record.dat", results="summary.dat", fitgeometry="rotate", function="polynomial", xxorder=2, xyorder=2, xxterms="full", yxorder=2, yyorder=2, yxterms="full", maxiter=maxitr, reject=sigrej, calctype="double", verbose=verb, interactive=no, graphics="stdgraph", cursor="")

	  # $B>e$G5a$a$?JQ49%^%H%j%/%9$K$7$?$,$C$F!"2hA|$r%7%U%H(B&$B2sE>$9$k!#(B
	  if (access(output)) imdel(output, ver-)
       	  if (access("drizzle.fits")) imdel("drizzle.fits")
## 2010/10/27 (FE) use drizzle option and blank value
	  geotran(text, "drizzle.fits", "database", "record.dat", geometry="linear", xin=INDEF, yin=INDEF, xshift=INDEF, yshift=INDEF, xout=INDEF, yout=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1.0, yscale=1.0, ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., interpolant="drizzle[0.5]", boundary="constant", constant=blank, fluxconserve=yes, nxblock=2048, nyblock=2048, verbose=verb)

## 2010/12/27 (FE) mask handling updated
   	  if (access("blank.fits")) imdel("blank.fits")
   	  if (access("blank.dri.fits")) imdel("blank.dri.fits")
	  imexpr("abs(a-b)<0.1 ? b : 0.","blank.fits",text,blank,"","","","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real",intype='real')
	  geotran("blank.fits","blank.dri.fits","database", "record.dat", geometry="linear", xin=INDEF, yin=INDEF, xshift=INDEF, yshift=INDEF, xout=INDEF, yout=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1.0, yscale=1.0, ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., interpolant="drizzle[0.5]", boundary="constant", constant=blank, fluxcon-, nxblock=2048, nyblock=2048, verbose=verb)
#	  print("! \cp blank.dri.fits blank."//output) | cl
    	  imexpr("b>d ? a : c",output,"drizzle.fits","blank.dri.fits",blank,thblank,"","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real",intype='real')

	  print("! grep xrefmean database") | cl | scan(text, x_ref)
	  print("! grep yrefmean database") | cl | scan(text, y_ref)
	  print("! grep xmean database") | cl | scan(text, x_in)
	  print("! grep ymean database") | cl | scan(text, y_in)
	  print("! grep xshift database") | cl | scan(text, dx)
	  print("! grep yshift database") | cl | scan(text, dy)
	  print("! grep xrotation database") | cl | scan(text, anglex)
	  print("! grep yrotation database") | cl | scan(text, angley)
	  print("! grep xrms database") | cl | scan(text, xrms)
	  print("! grep yrms database") | cl | scan(text, yrms)
#	  printf("%s: dx=%5.1f, dy=%5.1f\n",inpname,dx,dy)
	  if (anglex>180.) anglex=anglex-360.

	  ## selection by shift values (for MIR)
	  if (((detector=='MIRS' || detector=='MIRL') && multi==1) && (xoffset!=INDEF && yoffset!=INDEF)) {
	     ## if dx, dy, angle all fall between upper and lower limits (2015/01/19, FE)
#	     if ((abs(dx-xoffset)/xoffrms<clipsig && abs(dy-yoffset)/yoffrms<clipsig) && abs(anglex-amean)/asig<clipsig) {
	     if (((dx > dxlow && dx < dxup) && (dy > dylow && dy < dyup)) && (anglex > alow && anglex < aup)) {
   	        printf("! \cp database %s%s.fits.shift\n",prefix,filename) | cl
	        printf("%s %.3f %.3f %.5f %d\n", inpname, dx, dy, anglex, n_matched, >> lname//".shift")
		printf("\t X and Y fit rms: %f %f\n", xrms, yrms, >> "calcshift.log")
             } else {
	        printf("%s %.3f %.3f %.5f %d\n", inpname, dx, dy, anglex, -n_matched, >> lname//".shift")
		printf("Matching failed! (dx/dy/anglex too small/large) ref: %s inp: %s\n", refname, inpname, >> "calcshift.log")
	     }
	  } else { ## for NIR or multi>1
	     if (abs(dx) < limit && abs(dy) < limit) {
	        printf("! \cp database %s%s.fits.shift\n",prefix,filename) | cl
	        printf("%s %.3f %.3f %.5f %d\n", inpname, dx, dy, anglex, n_matched, >> lname//".shift")
	        printf("\t X and Y fit rms: %f %f\n", xrms, yrms, >> "calcshift.log")
             } else {
#	        printf("%s 999.99 999.99 999.99 0\n", inpname, >> lname//".shift")
	        printf("%s %.3f %.3f %.5f %d\n", inpname, dx, dy, anglex, -n_matched, >> lname//".shift")
	        printf("Matching failed! (dx/dy too small/large) ref: %s inp: %s\n", refname, inpname, >> "calcshift.log")
	     }
	  } 
       }
       endloop:

       # max_star$B$r:FEY=i4|2=(B
       if (n_refstar < maxstar) {
       	  max_star = n_refstar
	  min_star = minstar
	  min_match = minmatch
       } else {
       	  max_star = maxstar
	  if (detector == "NIR") {
	     min_match = 15
	     stp = 5
	  } else {
	     min_match = minmatch
	     stp = 1
	  }
       }
       nextfile:
       i+=1
    }
 }


# cleaning
 if( access("summary.dat") ){ delete("summary.dat", ver-) }
 if( access("database") ){ delete("database", ver-) }
 delete("xy.*", ver-)
 delete("matched*", ver-)

end
