## calflux.cl -- To apply flux conversion factor to stacked images
## 2014/03/12 (F. Egusa) - created
## 2014/12/17 (F. Egusa) - copy inf to outf if calflux done and over-
## 2015/03/13 (F. Egusa) - revised for IRC05

procedure calflux

string ircconst  {"constants.database", prompt="IRC constants database file name"}
string logfile   {"irclog", prompt="Output of mkirclog"}
real   blankval  {-9999.9,max=-1000., prompt="blank value"}
bool   overwrite = no {prompt='overwrite input images?'}

string  mode="al"

struct *list0

begin

 string irc_const,irclog
 real blank
 bool owrite

 string libpath,obj,inf,outf,band,keyw,bunit,aot
 int expid
 real dn2Jyf,cal


 print ("\n")
 print ("### CALFLUX ###\n")

## Get query parameters
 irc_const = ircconst
 irclog = logfile
 blank=blankval
 owrite=overwrite

## Set default parameters
 libpath = osfn("irclib$")
 irc_const = libpath//irc_const
 print("! grep dn2Jyfactor "//irc_const//" | awk '{print $2}'") | cl | scan(dn2Jyf)

## make list of files to be calibrated
 print("! grep -v '#' "//irclog//" | head -1 | awk '{print $1\".fits\"}'") | cl | scan(inf)
 hselect(inf,fields='OBJECT',expr='yes') | scan(obj)
 if (access('fname.list')) del('fname.list')
 print("! ls stacked_IM/"//obj//"*.fits | grep _long.fits > fname.list") | cl
 print("! ls stacked_IM/"//obj//"*.fits | grep _short.fits >> fname.list") | cl

## main loop
 list0='fname.list'
 while (fscan(list0,inf) != EOF) {
    ## check if calflux already done
    bunit=''
    hselect(inf,fields='BUNIT',expr='yes') | scan(bunit)
    if (bunit == 'microJy/pix') {
       if (owrite) {
          print('### Warning: CALFLUX maybe already done for '//inf)
	  print('             will skip this file')
       } else {
       	  print('! echo '//inf//' | sed s/.fits/.f.fits/g ') | cl | scan(outf)
          print('### Warning: CALFLUX maybe already done for '//inf)
	  print('             just copy to '//outf)
	  if (access(outf)) imdel(outf)
	  imcopy(inf,outf,ver-)
       }
       goto skip
    }

    ## read conversion factor
    hselect(inf,fields='FILTER,EXPID,AOT',expr='yes') | scan(band,expid,aot)
    if (expid == 1) {
       keyw=band//'short'
    } else { 
       if ((aot == 'IRC05')&&(substr(band,1,1) == 'N')) {
          keyw=band//'long05'
       } else {
          keyw=band//'long'
       }
    }
    print('! grep '//keyw//' '//irc_const//" | head -1 | awk '{print $2}'") | cl | scan(cal)
    cal=cal*dn2Jyf*10.**6. # [ADU] -> [microJy]

    ## apply the factor
    if (access('tmp.fits')) imdel('tmp.fits')
    imexpr('abs(a-b)<0.01 ? b : a*c','tmp.fits',inf,blank,cal,"","","","","","","","","","","","","","","","","","","","","","","",intype='real',outtype="real",verb-)
    if (owrite) {
       outf=inf
    } else {
       print('! echo '//inf//' | sed s/.fits/.f.fits/g ') | cl | scan(outf)
    }
    print('! mv -f tmp.fits '//outf) | cl
    printf('Input: %s -> Output: %s\n',inf,outf)

    ## update the header
    ccdhedit(outf,paramete='BUNIT',value='microJy/pix',type='string')

    skip:
 }


 print ("\n### CALFLUX finished!! ###\n")

end
