# extendwcs.cl -- To put wcs to the input image using the other band image.
# Created: Tomohiko Nakamura, 18-Mar-13

procedure extendwcs (image, refimage)
string  mode="al"

string image {"", prompt="The image which will inherit the wcs of the reference image"}
string refimage {"", prompt="The reference image"}
bool putwcs = yes {prompt="execute catalog matching with the new wcs value"}
bool force = no {prompt="force to extend WCS"}

begin
	string wcsroot
	string ra_s, dec_s
	string filter_inp, filter_ref
	real crpix1, crpix2
	real ra, dec, ra2, dec2
	real x, y, t
	real scale_x, scale_y
	real theta_r, theta_i
	real crpix1r, crpix2r, crval1r, crval2r
	real x0, y0, xc, yc
	real cdi_11, cdi_12, cdi_21, cdi_22
	real cdr_11, cdr_12, cdr_21, cdr_22
	real sgn
	real xmag, ymag
	real lngref, latref
	real ra_diff, dec_diff
	real pixscale
	int star_num
	string catalog
	string none

	real pi = 3.1415926535
	real d2r
	d2r = pi / 180.0

	stsdas | scan(none)
	toolbox
	imgtools

	print  ('### Extend WCS ###')
	printf ('    input image: %s\n', image)
	printf ('reference image: %s\n', refimage)

	hselect(image, "WCSROOT", yes) | scan(wcsroot)
	if(!force && !(wcsroot == "AOCS")) {
		print ("WCSROOT of the input image is NOT 'AOCS'.\nEnable 'force' option to extend the reference WCS.")
		bye
	}

	hselect(image, "CRPIX1, CRPIX2, FILTER", yes) | scan(x, y, filter_inp)
	if(substr(filter_inp,1,1) == 'S' || substr(filter_inp,1,1) == 'L'){
		hselect(image, "CRPIX1"//substr(filter_inp,1,1)//", CRPIX2"//substr(filter_inp,1,1), yes) | scan(crpix1, crpix2)
	} else {
		crpix1 = x; crpix2 = y
	}
	hselect(image, "CD1_1, CD1_2, CD2_1, CD2_2", yes) | scan(cdi_11, cdi_12, cdi_21, cdi_22)
	hselect(refimage, "FILTER", yes) | scan(filter_ref)
	hselect(refimage, "CD1_1, CD1_2, CD2_1, CD2_2", yes) | scan(cdr_11, cdr_12, cdr_21, cdr_22)
	hselect(refimage, "CRPIX1, CRPIX2, CRVAL1, CRVAL2", yes) | scan(crpix1r, crpix2r, crval1r, crval2r)

	# (x0, y0) : the coodinates of the point of the input image (0, 0) on the reference image
	if(substr(filter_ref,1,1) == 'S' && substr(filter_inp,1,1) == 'N'){
		t  = -89.5*pi/180.
		scale_x = 0.616
		scale_y = 0.620

		if(filter_ref == 'S7' && filter_inp == 'N3'){
			x0 = 268.0; y0 = -4.6
		}else if(filter_ref == 'S11' && filter_inp == 'N4'){
			x0 = 267.9; y0 = -7.4
		}else {
			print ('*** Bad image set ***'); bye
		}
	}else if(substr(filter_ref,1,1) == 'N' && substr(filter_inp,1,1) == 'S'){
		t  = 89.5*pi/180.
		scale_x = 1.622
		scale_y = 1.611

		if(filter_ref == 'N3' && filter_inp == 'S7'){
			x0 = 2.8; y0 = 433.9
		}else if(filter_ref == 'N4' && filter_inp == 'S11'){
			x0 = 7.4; y0 = 432.8
		}else {
			print ('*** Bad image set ***'); bye
		}
	}else if(substr(filter_ref,1,1) == 'S' && substr(filter_inp,1,1) == 'L'){
		t  = 1.20*pi/180.
		scale_x = 1.015
		scale_y = 1.020

		if(filter_ref == 'S7' && filter_inp == 'L15'){
			x0 = 515.6; y0 = -156.0
		}else if(filter_ref == 'S11' && filter_inp == 'L24'){
			x0 = 520.0; y0 = -151.5
		}else if(filter_ref == 'S9W' && filter_inp == 'L18W'){
			x0 = 515.0; y0 = -148.4
		}else {
			print ('*** Bad image set ***'); bye
		}
	}else if(substr(filter_ref,1,1) == 'L' && substr(filter_inp,1,1) == 'S'){
		t  = -1.20*pi/180.
		scale_x = 0.985
		scale_y = 0.980

		if(filter_ref == 'L15' && filter_inp == 'S7'){
			x0 = -510.6; y0 = 142.1
		}else if(filter_ref == 'L24' && filter_inp == 'S11'){
			x0 = -515.2; y0 = 137.9
		}else if(filter_ref == 'L18W' && filter_inp == 'S9W'){
			x0 = -509.4; y0 = 134.9
		}else {
			print ('*** Bad image set ***'); bye
		}
	}else {
		print ('*** Bad image set ***'); bye
	}

	# "i": input image, "r": reference image
	# [CDi11 CDi12] = [scale_x    0   ] [CDr11 CDr12] [cos(t)  -sin(t)]
	# [CDi21 CDi22]   [   0    scale_y] [CDr21 CDr22] [sin(t)   cos(t)]
	# scale_x = CDELTi1/CDELTr1, scale_y = CDELTi2/CDELTr2
	# t = theta_i-theta_r

	cdi_11 = scale_x * (cdr_11*cos(t) - cdr_12*sin(t))
	cdi_12 = scale_x * (cdr_11*sin(t) + cdr_12*cos(t))
	cdi_21 = scale_y * (cdr_21*cos(t) - cdr_22*sin(t))
	cdi_22 = scale_y * (cdr_21*sin(t) + cdr_22*cos(t))

	# (x0,y0)->(ra,dec) on the refimage
	# [ 0, 0]           on the input image
	dec = cdr_21*(x0-crpix1r) + cdr_22*(y0-crpix2r) + crval2r
	ra = (cdr_11*(x0-crpix1r) + cdr_12*(y0-crpix2r))/cos(dec*d2r) + crval1r

	# calculate coodinates at (CRPIX1x, CRPIX2x) on the input image
	yc = dec + (cdi_21*crpix1 + cdi_22*crpix2)
	xc = ra  + (cdi_11*crpix1 + cdi_12*crpix2) / cos(yc*d2r)

	# write coodinates on the input image
	hedit(image, "RA-"//substr(filter_inp,1,1), xc, ver-, show-)
	hedit(image, "DEC-"//substr(filter_inp,1,1), yc, ver-, show-)
	hedit(image, "CRVAL1", xc, ver-, show-)
	hedit(image, "CRVAL2", yc, ver-, show-)
	hedit(image, "CRPIX1", crpix1, ver-, show-)
	hedit(image, "CRPIX2", crpix2, ver-, show-)
	hedit(image, "CD1_1", cdi_11, ver-, show-)
	hedit(image, "CD1_2", cdi_12, ver-, show-)
	hedit(image, "CD2_1", cdi_21, ver-, show-)
	hedit(image, "CD2_2", cdi_22, ver-, show-)
	if(substr(filter_inp,1,1) == 'S' || substr(filter_inp,1,1) == 'L'){
		hedit(image, "CRVAL1"//substr(filter_inp,1,1), xc, ver-, show-)
		hedit(image, "CRVAL2"//substr(filter_inp,1,1), yc, ver-, show-)
		hedit(image, "CRPIX1"//substr(filter_inp,1,1), crpix1, ver-, show-)
		hedit(image, "CRPIX2"//substr(filter_inp,1,1), crpix2, ver-, show-)
		hedit(image, "CD1_1"//substr(filter_inp,1,1), cdi_11, ver-, show-)
		hedit(image, "CD1_2"//substr(filter_inp,1,1), cdi_12, ver-, show-)
		hedit(image, "CD2_1"//substr(filter_inp,1,1), cdi_21, ver-, show-)
		hedit(image, "CD2_2"//substr(filter_inp,1,1), cdi_22, ver-, show-)
	}
	hedit(image, "WCSROOT", 'SELF', ver-, show-)

	print('### ExtendWCS done!! ###')

	if(putwcs){
		if(access('coord.db')){ delete('coord.db', ver-) }
		if(substr(filter_inp,1,1) == 'N' || filter_inp == 'S7'){
			catalog = '2MASS'
			putwcs(image, minstar=4, minmatch=4, tolerance=2.0, dboutput='coord.db', catalog=catalog, wipestar=0.0, overwrite=no)
		} else if (filter_inp == 'S9W' || filter_inp == 'S11') {
			catalog = 'WISE'
			putwcs(image, minstar=4, minmatch=4, tolerance=2.0, det_sig=4.0, dboutput='coord.db', catalog=catalog, wipestar=0.0, overwrite=no)
		} else {
			catalog = 'WISE'
			putwcs(image, minstar=4, minmatch=4, tolerance=2.0, det_sig=4.0, dboutput='coord.db', catalog=catalog, wipestar=10.0, overwrite=no)
		}

		# if putwcs failed then exit
		if(!access('coord.db')){ bye }

		type('coord.db') | grep xmag | scan(none, xmag)        # X pixel scale [arcsec/pix]
		type('coord.db') | grep ymag | scan(none, ymag)        # Y pixel scale [arcsec/pix]

		type('coord.db') | grep lngref | scan(none, lngref)    # putwcs results
		type('coord.db') | grep latref | scan(none, latref)    # 
		type('coord.db') | grep xpixref | scan(none, x)        # 
		type('coord.db') | grep ypixref | scan(none, y)        # 

		# (x,y) -> (ra,dec) on the input image
		dec = cdi_21*(x-crpix1) + cdi_22*(y-crpix2) + yc
		ra = (cdi_11*(x-crpix1) + cdi_12*(y-crpix2))/cos(dec*d2r) + xc

		# difference between the extendWCS result and the putWCS result (arcsec)
		ra_diff = (ra-lngref)*cos(latref*pi/180)*60*60
		dec_diff = (dec-latref)*60*60

		# load the expected pixel scale
		if(substr(filter_inp,1,1) == 'N'){
			pixscale = 1.446
		} else if(substr(filter_inp,1,1) == 'S'){
			pixscale = 2.340
		} else if(substr(filter_inp,1,1) == 'L'){
			pixscale = 2.384
		}

		# confirm the pixel scales and the difference
		printf('difference between the extendWCS and the putWCS [arcsec]: %f\n\n',
                sqrt(ra_diff**2+dec_diff**2))

		if(sqrt(ra_diff**2+dec_diff**2) < 60.){
			ccsetwcs(image, 'coord.db', 'solution')
			hedit(image, 'WCSROOT', catalog, ver-)
			print ('### WCS is updated!! ###\n')
		} else {
			print ('*** It seems a wrong match. The putWCS result was discarded. ***\n')
			bye
		}
		if(access('coord.db')){ delete('coord.db', ver-) }
	}

end

