# putwcs.cl -- To put wcs to one or more image(s)
# by matching 2MASS catalog coordinates.
# Created: Yoshifusa Ita, 30-Jun-06
# Updated: Yoshifusa Ita, 18-Jul-06  Delete unnecessary headers before putting new wcs
# Updated: Shinki Oyabu,  09-Dec-06  Wildcard input is available.
# Updated: Tomohiko Nakamura, 16-Apr-13  Add the option "catalog (2MASS/WISE)", "wipestar"
## 2014/03/10 (F. Egusa) - updated for double-sized images,
##   tot_rms revised, comparison with original PA added

procedure putwcs (inlist)
string  mode="al"

string inlist {"input.fits", prompt="input fits file name"}
real   foview   {14.0, min=1., max=16., prompt="FOV of the image"}
int    maxstar  {300,  min=50, max=5000, prompt="Max # of stars in xymatching"}
int    minstar  {7, min=3, max=15, prompt="Min # of stars in xymatching"}
int    minmatch {7, min=3, max=9999, prompt="Min # of stars matched"}
int    step     {1, min=1, max=10, prompt="Step"}
real   sig_rej  {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
real   det_sig  {5.,min=1.,max=100., prompt="Detection threshold in sigma"}
real   tolerance {1.5, min=0.1, max=10.0, prompt="The matching tolerance in arcsec"}
real   wipestar = 0.0 {prompt="The searching radius in pixels for pre-selection of xyxymatch (0.0: disable)"}
string ircconst {"constants.database", prompt="IRC constants database file name"}
string catalog {"default", prompt="Catalog name for WCS coordinate matching"}
string dboutput {"", prompt="CCmap output file name"}
bool   chk_scale = yes  {prompt="Check pixel scale and angle of the calculated matrix"}
bool   overwrite = yes  {prompt="Overwrite WCS coodinates in the input fits"}
bool   verbose = no {prompt="Print verbose progress messages?"}
bool   cleanfile = yes {prompt="cleaning intermediate files (no for debug)"}

struct *list0,*imglist


begin

 string fname, irc_const
 real fov, sigrej, detsig
 int max_star, min_star, min_match, stp, det_id
 string text, pcommand, exec, libpath, cat_name, filter, band_name, dbout
 int i, n_matched, best_order, order
 real ra, dec, pa, pfov, fwhm, ftmp
 real xrms, yrms, tot_rms
 real xmag, ymag, xrot, yrot
 real crpix1, crpix2, cd11, cd12, cd21, cd22, cddet
 int naxis1, naxis2
 real epadu, exptime, rnoise, tole, wipe_stars
 real pi, deg2rad
 int wid
 real wra, wdec, wx, wy, jy, ejy, wxx, wyy

 bool update, check_pfov, clean_files, dpix
 string imginlist,infile,filename
 string none


## set default parameters
 imginlist=inlist
 infile=mktemp("tmp$putwcs");
 sections(imginlist,option="root", > infile)
 imglist=infile
 pi = 3.141592653589793238462643383279
 deg2rad = pi/180.
 dpix=no

 print ("\n### PUTWCS ###\n")

	
 while(fscan(imglist,filename) != EOF){
# get query parameters
	fname = filename
	fov   = foview
	max_star = maxstar
	min_star = minstar
	min_match = minmatch
	stp = step
	sigrej = sig_rej
	detsig = det_sig
	cat_name = catalog
	dbout = dboutput
	wipe_stars = wipestar
	check_pfov = chk_scale
	irc_const = ircconst
	verb = verbose
	update = overwrite
	tole = tolerance
	clean_files = cleanfile

	## 2014/03/10 (FE) check if double-sized image or not
	text=''
	hselect(fname,fields='DBLPIX',expr='yes') | scan(text)
	if (text=='yes' || text=='YES') {
	   dpix=yes 
	   print('The input is double-sized image.')
	}

# read ra and dec from header
	print ("Read RA and DEC from header...\n")
	if( access("radec.dat") ){ delete("radec.dat", ver-) }
	hselect(fname, fields="DETECTOR", expr="yes") | scan(text)
	if(text == "NIR"){
		det_id = 1
	}else if(text == "MIRS"){
		det_id = 2
	}else if(text == "MIRL"){
		det_id = 3
	}else{
		print ("### ERROR: wrong 'DETECTOR' in the header.")
		bye
	}

	if(det_id == 1){ # NIR
		hselect(fname, fields="$I, RA-N, DEC-N, PA-N, NAXIS1, NAXIS2, CRPIX1, CRPIX2, CD1_1, CD1_2, CD2_1, CD2_2", expr="yes", > "radec.dat")
		pfov = 1.446
	} else if(det_id == 2){ # MIRS
		hselect(fname, fields="$I, RA-S, DEC-S, PA-S, NAXIS1, NAXIS2, CRPIX1S, CRPIX2S, CD1_1S, CD1_2S, CD2_1S, CD2_2S", expr="yes", > "radec.dat")
		pfov = 2.340
	} else if(det_id == 3){ # MIRL
		hselect(fname, fields="$I, RA-L, DEC-L, PA-L, NAXIS1, NAXIS2, CRPIX1L, CRPIX2L, CD1_1L, CD1_2L, CD2_1L, CD2_2L", expr="yes", > "radec.dat")
		pfov = 2.384
	} else {
		print ("detector ID should be 1:NIR, 2:MIRS or 3:MIRL.")
		bye
	}
	## 2014/03/10 (FE)
	if (dpix) pfov = pfov/2.
	printf("! wc -w radec.dat\n") | cl | scan(i, text)
	if(i == 12){
		printf("! cat radec.dat\n") | cl | scan(text, ra, dec, pa, naxis1, naxis2, crpix1, crpix2, cd11, cd12, cd21, cd22)
		pa = -atan2(sign(cd11*cd22-cd12*cd21)*cd12, cd22)*180.0/pi
		## 2014/03/10 (FE) for comparison after ccmap
		if (pa < 0.) pa=pa+360.
	}else{
		printf("Couldn't find RA DEC in the header of "//fname//"\n")
		bye
	}
	if( access("radec.dat") ){ delete("radec.dat", ver-) }
	printf("\t RA %s  DEC %s  PA %s \n\n", ra, dec, pa)
		

# $B0-$5$r$9$k%X%C%@$r>C$9(B
	ccdhedit (fname, paramete="WCSDIM", value=2, type="integer")
	hedit (fname, "LTM3_3"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
	hedit (fname, "WAXMAP01", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
	hedit (fname, "WAT3_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)

	# set default catalog: NIR=>2MASS (K-band), MIR-S,L=>WISE (W3-band)
	if(cat_name == "default"){
		if(det_id == 1){
			cat_name = "2MASS"
		} else {
			cat_name = "WISE"
		}
	}
	if(cat_name == "WISE"){
		hselect(fname, fields="FILTER", expr="yes") | scan(filter)
		if(filter=="L24"){
			band_name = "W4"
		} else {
			band_name = ""
		}
	} else {
		band_name = ""
	}

	printf ("Downloading %s catalog...\n", cat_name)
	pcommand = osfn("ircperl$")
	pcommand = pcommand//"getcatalog.pl"
	printf("! %s %s%s %s %s %f\n", pcommand, cat_name, band_name, ra, dec, fov) | cl

# convert 2MASS/WISE radec to wcs xy
	exec = osfn("ircbin$")
	exec = exec//"convert2mass"
	printf("! %s 2mass.radec %f %f %f\n", exec, ra, dec, pfov) | cl
	delete("2mass.radec", ver-)

# read fwhm from ircconst
	libpath = osfn("irclib$")
	irc_const = libpath//irc_const
	if(det_id == 1){ # NIR
		printf("! grep fwhm_nir  %s\n", irc_const) | cl | scan(text, fwhm)
	}else if(det_id == 2){ # MIRS
		printf("! grep fwhm_mirs %s\n", irc_const) | cl | scan(text, fwhm)
	}else if(det_id == 3){ # MIRL
		printf("! grep fwhm_mirl %s\n", irc_const) | cl | scan(text, fwhm)
	}
	## 2014/03/10 (FE)
	if (dpix) fwhm=fwhm*2.

# source extraction
	print ("Extracting sources...\n")
	hselect(fname, fields="GAIN"    , expr="yes") | scan(epadu)
	hselect(fname, fields="EXPTIME" , expr="yes") | scan(exptime)
	hselect(fname, fields="RNOISE"  , expr="yes") | scan(rnoise)
	if( access(fname//".coo.0") ){ delete(fname//".coo.0", ver-) } 
	source_extract2(fname, detid=det_id, det_sig=detsig, sig_rej=sigrej, exp_time=exptime, data_max=50000, bad_data=-1000., ep_adu=epadu, r_noise=rnoise, fwathm=fwhm, verbose=verb)
		
# sort & textdump
	# $BL@$i$+$K2hLL$N$=$H$K$"$k@1$r$H$j$N$>$/(B 
	## 2014/03/10 (FE) margin=0.1*naxis1
	list0 = "2mass.wcs"
	if( access("2mass.wcs.2") ){ delete("2mass.wcs.2", ver-) } 
	while(fscan(list0, wid, wra, wdec, wx, wy, jy, ejy) != EOF){
		wxx = wx*cos(pa*deg2rad) + wy*sin(pa*deg2rad)
		wyy = -wx*sin(pa*deg2rad) + wy*cos(pa*deg2rad)
		if (abs(wxx)<naxis1*.6 && abs(wyy)<naxis1*.6) printf("%d %11.7f %11.7f %9.4f %9.4f %8.3f %10.6f\n",wid,wra,wdec,(wxx+crpix1),(wyy+crpix2),jy,ejy, >> "2mass.wcs.2")
	}
        ! \mv 2mass.wcs.2 2mass.wcs

	# 2MASS/WISE$B%+%?%m%0$rL@$k$$=gHV$KJB$SBX$($k!#(B
	if(det_id == 1){
		! sort -n -k 6 -o reference.tmp.xy 2mass.wcs
		! awk '{if($6>7&&$6<16)print}' reference.tmp.xy > reference.xy
	        ! \rm -rf reference.tmp.xy
	}else{
		! sort -n -k 6 -o reference.xy 2mass.wcs
	}
	print("! wc -l reference.xy\n") | cl | scan(i, text)
	printf("number of reference stars: %d\n", i)
	if(max_star > i){ max_star = i}

	# input$B@1%+%?%m%0$rL@$k$$=gHV$KJB$SBX$($k!#(B
	text = fname//".coo.0"
	if( access("image.xy") ){ delete("image.xy", ver-) }
	txdump(text, "XCENTER,YCENTER,MAG", "yes", headers=no, parameters=no, >> "image.xy")
	! sort -n -k 3,3 -o image.xy image.xy 
	print("! wc -l image.xy\n") | cl | scan(i, text)
	printf("number of stars in image: %d\n\n", i)
	if( max_star > i ){ max_star = i}
		
	## wipe stars if requested
	if (wipe_stars>0.0) {
		printf("Execuing wipe stars...\n")
		printf("! %swipestars image.xy reference.xy image.new.xy reference.new.xy %f\n", osfn("ircbin$"), wipe_stars) | cl
		printf("done!!\n\n")
	}

	# matching reference.xy and image.xy
	print ("Matching reference coordinates...\n")

	again:
	if(max_star < min_star){
		print ("\t Matching failed!!!\n")
		goto finish
	}
	if( access("xy.inp") ){ delete("xy.inp", ver-) }
	if( access("xy.ref") ){ delete("xy.ref", ver-) }
	if (wipe_stars>0.0) {
		printf("! head -n %d image.new.xy > xy.inp\n", max_star) | cl
		printf("! head -n %d reference.new.xy > xy.ref\n", max_star) | cl
	} else {
		printf("! head -n %d image.xy > xy.inp\n", max_star) | cl
		printf("! head -n %d reference.xy > xy.ref\n", max_star) | cl
	}
	if( access("matched") ){ delete("matched", ver-) }
#	xyxymatch("xy.inp", "xy.ref", "matched", tole, refpoints="", xin=INDEF, yin=INDEF, xmag=1.0, ymag=1.0, xrotation=pa, yrotation=pa, xref=0.0, yref=0.0, xcolumn=1, ycolumn=2, xrcolumn=4, yrcolumn=5, separation=5., matching="triangles", nmatch=30, ratio=5., nreject=10, xformat="%13.4f", yformat="%13.4f", interactive=no, verbose=verb, icommands="")
	xyxymatch("xy.inp", "xy.ref", "matched", tole, refpoints="", xin=INDEF, yin=INDEF, xmag=1.0, ymag=1.0, xrotation=0.0, yrotation=0.0, xref=0.0, yref=0.0, xcolumn=1, ycolumn=2, xrcolumn=4, yrcolumn=5, separation=5., matching="triangles", nmatch=30, ratio=5., nreject=10, xformat="%13.4f", yformat="%13.4f", interactive=no, verbose=verb, icommands="")

	# $B6uGr9T$H%3%a%s%H9T$r<h$j=|$/(B
	! sed -e '/^$/d' matched | sed -e '/#/d' > matched.tmp 
	if( !access("matched.tmp") ){ print("! touch matched.tmp\n") | cl }
	! \mv matched.tmp matched
	print("! wc -l matched\n") | cl | scan(n_matched)
	if(n_matched < min_match){
		max_star -= stp
		goto again
	}else{
		goto success
	}

	success:
	printf("\t Successfully %d stars matched!! \n\n", n_matched)


# calculate wcs coordinates and put it in the header
	if( access("matched.inv") ){ delete("matched.inv", ver-) }
	fields("matched", "3,4,1,2", lines="1-", quit_if_miss=no, print_file_n=no, > "matched.inv" )
	pcommand = osfn("ircperl$")
	pcommand = pcommand//"wcs2mass.pl"
	printf("! %s 2mass.wcs\n", pcommand) | cl

# check matched stars if they were real
	print("Checking...\n")
	print("! wc -l ccmap.input\n") | cl | scan(n_matched)
	if(n_matched < min(4,min_match)){
		print("\t They were phantom stars that were matched!!\n")
		print("\t Matching was actually failed.\n")
		print("\t Matching failed!!!\n")
		goto finish
	}else{
		print("\t Good!!!\n")
	}


# use ccmap to calculate transformation matrix
	print("Calculating transformation matrix...\n")
	best_order = 2
	ftmp = 50000.0
	for(order=2 ; order<5 ; order+=1){
		if( access("database2")    ){ delete("database2", ver-) }
		if( access("summary2.dat") ){ delete("summary2.dat", ver-) }
		ccmap("ccmap.input", "database2", solutions="solution", images=fname, results="summary2.dat", xcolumn=6, ycolumn=7, lngcolumn=2, latcolumn=3, xmin=1., xmax=naxis1, ymin=1., ymax=naxis2, lngunits="degrees", latunits="degrees", insystem="j2000", refpoint="coords", lngref="INDEF", latref="INDEF", refsystem="INDEF", lngrefunits="degrees", latrefunits="degrees", projection="tan", fitgeometry="general", function="polynomial", xxorder=order, xyorder=order, xxterms="full", yxorder=order, yyorder=order, yxterms="full", maxiter=10, reject=sig_rej, update=no, pixsystem="logical", verbose=verb, interactive=no, graphics="stdgraph", cursor="")
		if( access("tmp.txt") ){ delete("tmp.txt", ver-) }
		! grep "wcs rms" summary2.dat | perl -e 'while(<>){chomp; @buf1=split(/\s+/,$_); printf("%f  %f\n",$buf1[6],$buf1[7]);}' > tmp.txt
		list0 = "tmp.txt"

		i = fscan(list0, xrms, yrms)
		if( access("tmp.txt") ){ delete("tmp.txt", ver-) }
		print("! grep Warning summary2.dat\n") | cl | scan(text)
		## 2014/03/10 (FE) tot_rms [pixel]
		tot_rms = sqrt(xrms*xrms + yrms*yrms)
		if(tot_rms > tole){
			printf("\t total rms = %.2f > tolerance = %.2f\n",tot_rms,tole)
			printf("\t Wrong match!! matching stars again.\n\n")
			max_star = max_star - 1
			goto again
		}
		## 2014/03/10 (FE) comparison with original PA added
		# compare expected pixel scales + original pa and those in the ccmap result
		if(check_pfov){
			type('database2') | grep xmag | scan(none, xmag)
			type('database2') | grep ymag | scan(none, ymag)
			type('database2') | grep xrotation | scan(none, xrot)
			type('database2') | grep yrotation | scan(none, yrot)
			if(xmag<0.9*pfov || xmag>1.1*pfov || ymag<0.9*pfov || ymag>1.1*pfov || abs(xrot-yrot)<170. || abs(xrot-yrot)>190. || abs(yrot-pa)>20.){
				printf('X pixel scale [arcsec/pix]: %.2f\n', xmag)
				printf('Y pixel scale [arcsec/pix]: %.2f\n', ymag)
				printf('X rotation angle [deg]: %.1f\n', xrot)
				printf('Y rotation angle [deg]: %.1f\n', yrot)
				printf('original PA [deg]: %.1f\n',pa)
				printf("\t Wrong match!! matching stars again.\n\n")
				delete("database2", ver-)
				max_star = max_star - 1
				goto again
			}
		}
		if(text=="#"){
			printf("\t The rms in %2dth order fit-  # Warning: singular fit\n", order)
		}else{
			printf("\t The rms in %2dth order fit-  x:%10.5f, y:%10.5f\n", order, xrms, yrms)
			if(tot_rms < ftmp){
				best_order = order
				ftmp = tot_rms
			}
		}
	}
#	printf("The best order is: %d\n", best_order)
	order = best_order
	if( access("database2") ){ delete("database2", ver-) }
	if( access("summary2.dat") ){ delete("summary2.dat", ver-) }
# $B0lHV(Brms$B$N>.$5$$(Border$B$G$b$&0lEY%U%#%C%H$9$k!#(Boverwrite=yes$B$N>l9g$O(BWCS$B$r>e=q$-!#(B
	ccmap("ccmap.input", "database2", solutions="solution", images=fname, results="summary2.dat", xcolumn=6, ycolumn=7, lngcolumn=2, latcolumn=3, xmin=1., xmax=naxis1, ymin=1., ymax=naxis2, lngunits="degrees", latunits="degrees", insystem="j2000", refpoint="coords", lngref="INDEF", latref="INDEF", refsystem="INDEF", lngrefunits="degrees", latrefunits="degrees", projection="tan", fitgeometry="general", function="polynomial", xxorder=order, xyorder=order, xxterms="full", yxorder=order, yyorder=order, yxterms="full", maxiter=10, reject=sig_rej., update=update, pixsystem="logical", verbose=verb, interactive=no, graphics="stdgraph", cursor="")

	printf('\n### Summary: %s, %d stars matched, %dth order fit with rms=%.2f arcsec\n\n',fname,n_matched,order,ftmp)
		
# WCS flag
	if (update) {
	   ccdhedit (fname, paramete="WCSROOT", value=cat_name, type="string")
	   ccdhedit (fname, paramete="WCSNSTAR", value=n_matched, type="integer")
	   ccdhedit (fname, paramete="WCSORDER", value=order, type="integer")
	   ccdhedit (fname, paramete="WCSERROR", value=ftmp, type="real")
	   ccdhedit(fname,paramete='WIPERAD',value=wipe_stars,type='real')
	}
	if( access("database2") && dbout != ""){ copy ("database2", dbout) }

	finish:

# cleaning
	if(clean_files){
		if( access("ccmap.input") ){ delete("ccmap.input", ver-) }
		if( access("matched") ){ delete("matched", ver-) }
		if( access("matched.inv") ){ delete("matched.inv", ver-)} 
		if( access("matched_xy") ){ delete("matched_xy", ver-)} 
		if( access("2mass.wcs") ){ delete("2mass.wcs", ver-) }
		if( access("NIR.radec") ){ delete("NIR.radec", ver-) }
		if( access("NIR.coo") ){ delete("NIR.coo", ver-) }
		if( access("database2") ){ delete("database2", ver-) }
		if( access("summary2.dat") ){ delete("summary2.dat", ver-) }
		if( access("xy.inp") ){ delete("xy.inp", ver-) }
		if( access("xy.ref") ){ delete("xy.ref", ver-) }
		if( access(fname//".coo.0") ){ delete(fname//".coo.0", ver-) }
		if( access("image.xy") ){ delete("image.xy", ver-) }
		if( access("reference.xy") ){ delete("reference.xy", ver-) }
		if( access("image.new.xy") ){ delete("image.new.xy", ver-) }
		if( access("reference.new.xy") ){ delete("reference.new.xy", ver-) }
	}

 }

 print("### PUTWCS finished!! ###\n")

 del(infile)

end

