# source_extract.cl -- To extract sources
# Created: Yoshifusa Ita, 07-Jul-05
# Updated: Yoshifusa Ita, 16-May-07 remove cosmic_ray rejection
# Updated: Yoshifusa Ita, 24-Dec-10 remove skysubtraction section
## 2012/12/19 (F.Egusa), script reduced
## 2013/12/12 (F.Egusa), lower value revised
## 2014/03/05 (F.Egusa), 'nb' option added, statarea revised


procedure source_extract (img, detid, det_sig, sig_rej, exp_time, data_max, bad_data, ep_adu, r_noise, fwathm, verbose,nb)
string  mode="al"

string img        {"image.fits", prompt="image fits file name"}
int    detid      {1,min=1,max=3, prompt="Detector ID: 1NIR,2MIRS,3MIRL"}
real   det_sig    {2.5,min=1.,max=1000., prompt="Number of sigmas for detection limits"}
real   sig_rej    {2.5,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
real   exp_time   {51.4272,min=0.1,max=120., prompt="Integration time"}
real   data_max   {60000.,min=0.,max=99999., prompt="Initial upper limit for data range [ADU]"}
real   bad_data   {-5000.,min=-99999.,max=0., prompt="ignore any pixels below this level.[ADU]"}
real   ep_adu     {10.,min=1.,max=100., prompt="Analog to Digital unit/gain [electrons/ADU]"}
real   r_noise    {10.,min=1.,max=100., prompt="Read out noise [electrons]"}
real   fwathm     {1.,min=1.,max=50., prompt="Mean FWHM [pixels]"}
int    maxitr     {10,min=1,max=10, prompt="Maximum number of iterations"}
bool   verbose = no {prompt="Print verbose progress messages?"}
int    nb         {128,prompt='number of pixels of the border'}

struct *list0

begin

 string image, statarea
 real detsig, exptime, upper, lower, epadu, rnoise, fwhm
 real skyval, sdev_sky
 real mean, sigma, median, modee
 int i, npix, det_id, nborder
 real ll, ul
 int maxiter
 real nsigrej
 real baddata
 int expid, naxis1,naxis2,dx,dy,x1,x2,y1,y2

# Get query parameter
 image = img
 det_id = detid
 detsig = det_sig
 exptime = exp_time
 upper = data_max
 lower = bad_data + 1.
 epadu = ep_adu
 rnoise = r_noise
 fwhm = fwathm
 maxiter = maxitr
 nsigrej = sig_rej
 nborder=nb


## define area for sky statistics
 hselect(image,fields='NAXIS1,NAXIS2',expr='yes') | scan(naxis1,naxis2)
 dx=naxis1-nborder*2
 dy=naxis2-nborder*2
 if (det_id==1) {
    x1=nborder+1+int(dx*.01)
    y1=nborder+1+int(dy*.01)
    x2=nborder+1+int(dx*.99)
    y2=nborder+1+int(dy*.74) # to exclude the slit
#	statarea = "[308:715,257:635]" 
 } else if (det_id==2) {
    x1=nborder+1+int(dx*.125) # to exclude the slit
    y1=nborder+1+int(dy*.01)
    x2=nborder+1+int(dx*.98)
    y2=nborder+1+int(dy*.98) 
#	statarea = "[160:379,130:379]"
    detsig=2.5
 } else if (det_id==3) { # for L
    x1=nborder+1+int(dx*.05)
    y1=nborder+1+int(dy*.04)
    x2=nborder+1+int(dx*.95)
    y2=nborder+1+int(dy*.95) 
#	statarea = "[142:372,138:371]"
 }
 statarea='['//x1//':'//x2//','//y1//':'//y2//']'

## check long/short
 hselect(image, fields="EXPID"   , expr="yes") | scan(expid)


## robust statistics for sky
 imstat(image//statarea, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper, nclip=0, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
# printf("debug %s %d %f %f %f %f\n",originalname, npix, mean,median,modee,sigma)
 i = 1
 while(i <= maxiter){
 	ll = mean - (nsigrej*sigma)
 	ul = mean + (nsigrej*sigma)
 	if (lower != INDEF && ll < lower) ll = lower
 	if (upper != INDEF && ul > upper) ul = upper
 	imstat(image//statarea, fields="npix,mean,midpt,mode,stddev", lower=ll, upper=ul, nclip=0, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
 	i = i + 1
 }
# printf("debug2 %s %d %f %f %f %f\n",originalname, npix,mean,median,modee,sigma)
 skyval = median
 sdev_sky = sigma


## make parameter lists for daofind
 if( access("find.par") ) { delete("find.par", ver-) }
 if( access("data.par") ) { delete("data.par", ver-) }

 printf('threshold,r,h,%5.2f,,,\"Threshold in sigma for feature detection\"\n',detsig, >> 'find.par')
 print('nsigma,r,h,1.5,,,\"Width of convolution kernel in sigma\"', >> 'find.par')
 print('ratio,r,h,1.,0.,1.,\"Ratio of minor to major axis of Gaussian kernel\"', >> 'find.par')
 print('theta,r,h,107,0.,180.,\"Position angle of major axis of Gaussian kernel\"', >> 'find.par')
 print('sharplo,r,h,-1.5,,,\"Lower bound on sharpness for feature detection \"', >> 'find.par')
 print('sharphi,r,h,1.5,,,\"Upper bound on sharpness for feature detection\"', >> 'find.par')
 print('roundlo,r,h,-1.0,,,\"Lower bound on roundness for feature detection\"', >> 'find.par')
 print('roundhi,r,h,1.0,,,\"Upper bound on roundness for feature detection\"', >> 'find.par')
 print('mkdetections,b,h,no,,,\"Mark detections on the image display ?\"', >> 'find.par')
 print('mode,s,h,\"ql\",,,', >> 'find.par')

 print('scale,r,h,1.0,0.,,\"Image scale in units per pixel\"', >> 'data.par')
 printf('fwhmpsf,r,h,%5.2f,0.,,\"FWHM of the PSF in scale units\"\n',fwhm, >> 'data.par')
 print('emission,b,h,yes,,,\"Features are positive ?\"', >> 'data.par')
 printf('sigma,r,h,%8.3f,0.,,\"Standard deviation of background in counts\"\n',sdev_sky, >> 'data.par')
 printf('datamin,r,h,%8.1f,,,\"Minimum good data value\"\n',lower, >> 'data.par')
 printf('datamax,r,h,%8.1f,,,\"Maximum good data value\"\n',upper, >> 'data.par')
 print('noise,s,h,\"poisson\",|poisson|,,\"Noise model\"', >> 'data.par')
 print('ccdread,s,h,\"\",,,\"CCD readout noise image header keyword\"', >> 'data.par')
 print('gain,s,h,\"\",,,\"CCD gain image header keyword\"', >> 'data.par')
 printf('readnoise,r,h,%5.2f,,,\"CCD readout noise in electrons\"\n',rnoise, >> 'data.par')
 printf('epadu,r,h,%5.2f,,,\"Gain in electrons per count\"\n',epadu, >> 'data.par')
 print('exposure,s,h,\"\",,,\"Exposure time image header keyword\"', >> 'data.par')
 print('airmass,s,h,\"\",,,\"Airmass image header keyword\"', >> 'data.par')
 print('filter,s,h,\"\",,,\"Filter image header keyword\"', >> 'data.par')
 print('obstime,s,h,\"\",,,\"Time of observation image header keyword\"', >> 'data.par')
 printf('itime,r,h,%8.4f,,,\"Exposure time\"\n',exptime, >> 'data.par')
 print('xairmass,r,h,INDEF,,,\"Airmass\"', >> 'data.par')
 print('ifilter,s,h,INDEF,,,\"Filter\"', >> 'data.par')
 print('otime,s,h,INDEF,,,\"Time of observation\"', >> 'data.par')
 print('mode,s,h,\"ql\",,,', >> 'data.par')


## Source extraction with daofind
 if( access(image//".coo.0") ){	delete(image//".coo.0", ver-) }
 if (!deftask ("noao.digiphot.apphot.daofind")) {
	noao.digiphot.apphot
 }
 if(det_id==1){ # NIR
	 daofind (image, output=image//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
 }else{
      if(expid==1){
      	 daofind (image, output=image//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
      }else{
      	 daofind (image, output=image//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
      }
 }

## clean
 delete("find.par", ver-)
 delete("data.par", ver-)

end
