# source_extract.cl -- To extract sources
# Created: Yoshifusa Ita, 07-Jul-05

procedure source_extract2 (img, detid, det_sig, sig_rej, exp_time, data_max, bad_data, ep_adu, r_noise, fwathm, verbose)
string  mode="al"

string img        {"image.fits", prompt="image fits file name"}
int    detid      {1,min=1,max=3, prompt="Detector ID: 1NIR,2MIRS,3MIRL"}
real   det_sig    {3.,min=1.,max=1000., prompt="Number of sigmas for detection limits"}
real   sig_rej    {2.5,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
real   exp_time   {51.4272,min=0.1,max=120., prompt="Integration time"}
real   data_max   {60000.,min=0.,max=99999., prompt="Initial upper limit for data range [ADU]"}
real   bad_data   {-5000.,min=-99999.,max=0., prompt="egnore any pixels below this level.[ADU]"}
real   ep_adu     {10.,min=1.,max=100., prompt="Analog to Digital unit/gain [electrons/ADU]"}
real   r_noise    {10.,min=1.,max=100., prompt="Read out noise [electrons]"}
real   fwathm     {1.,min=1.,max=50., prompt="Mean FWHM [pixels]"}
int    maxitr     {10,min=1,max=10, prompt="Maximum number of iterations"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string image, originalname
 real detsig, exptime, upper, lower, epadu, rnoise, fwhm
 real skyval, sdev_sky
 real mean, sigma, median, modee
 int i, npix, det_id, expid
 real ll, ul
 int maxiter
 real nsigrej
 real baddata
 bool verb

# Get query parameter
 image = img
 det_id = detid
 detsig = det_sig
 exptime = exp_time
 upper = data_max
# lower = bad_data
 lower = -1000.0
 epadu = ep_adu
 rnoise = r_noise
 fwhm = fwathm
 maxiter = maxitr
 nsigrej = sig_rej
 verb = verbose


# S$B$H(BL$B$N>l9g$O!"%9%+%$$,$&$M$C$F$$$k$N$G!"(Bmedianbox$B%U%#%k%?$r$7$?2hA|$r0z$$$F(B
# $B%F%s%]%i%j$J%$%a!<%8$r:n$j!"$=$l$KBP$7$F(Bsource_extraction$B$9$k!#(B

 hselect(image, fields="EXPID"   , expr="yes") | scan(expid)

 originalname = image
 if(det_id!=1){ # NIR$B$8$c$J$+$C$?$i(B
	if(expid!=1){
		if( access("median.fits") ){ del("median.fits", ver-) }
		if( access("skysub.fits") ){ del("skysub.fits", ver-) }
		fmedian (image, "median.fits", 21, 21, hmin=-1000, hmax=5000, zmin=-1000, zmax=5000, zloreject=-1000, zhireject=5000, unmap=yes, boundary="nearest", constant=0., verbose=verb)
		imarith (image, "-", "median.fits", "skysub.fits", title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
		if( access("median.fits") ){ imdel("median.fits", ver-) }
		image = "skysub.fits"
	}
 }


# sky$B$N:G=i$N%m%P%9%H$JCM$rF@$k!#(B
 imstat(image, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper, nclip=0, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
# printf("debug %s %d %f %f %f %f\n",originalname, npix, mean,median,modee,sigma)
 i = 1
 while(i <= maxiter){
 	ll = mean - (nsigrej*sigma)
 	ul = mean + (nsigrej*sigma)
 	if (lower != INDEF && ll < lower) ll = lower
 	if (upper != INDEF && ul > upper) ul = upper
 	imstat(image, fields="npix,mean,midpt,mode,stddev", lower=ll, upper=ul, nclip=0, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
 	i = i + 1
 }
# printf("debug2 %s %d %f %f %f %f\n",originalname, npix,mean,median,modee,sigma)
 skyval = median
 sdev_sky = sigma


# make parameter lists for daofind
 if( access("find.par") ) { delete("find.par", ver-) }
 if( access("data.par") ) { delete("data.par", ver-) }

 printf("threshold,r,h,%5.2f,,,\"Threshold in sigma for feature detection\"\nnsigma,r,h,1.5,,,\"Width of convolution kernel in sigma\"\nratio,r,h,1.,0.,1.,\"Ratio of minor to major axis of Gaussian kernel\"\ntheta,r,h,107,0.,180.,\"Position angle of major axis of Gaussian kernel\"\nsharplo,r,h,-1.5,,,\"Lower bound on sharpness for feature detection \"\nsharphi,r,h,1.5,,,\"Upper bound on sharpness for feature detection\"\nroundlo,r,h,-1.0,,,\"Lower bound on roundness for feature detection\"\nroundhi,r,h,1.0,,,\"Upper bound on roundness for feature detection\"\nmkdetections,b,h,no,,,\"Mark detections on the image display ?\"\nmode,s,h,\"ql\",,,\n", detsig, >> "find.par")


# if(det_id == 1){ # NIR
#	 printf("threshold,r,h,%5.2f,,,\"Threshold in sigma for feature detection\"\nnsigma,r,h,2.0,,,\"Width of convolution kernel in sigma\"\nratio,r,h,1.0,0.,1.,\"Ratio of minor to major axis of Gaussian kernel\"\ntheta,r,h,45,0.,180.,\"Position angle of major axis of Gaussian kernel\"\nsharplo,r,h,0.2,,,\"Lower bound on sharpness for feature detection \"\nsharphi,r,h,1.,,,\"Upper bound on sharpness for  feature detection\"\nroundlo,r,h,-1.,,,\"Lower bound on roundness for feature detection\"\nroundhi,r,h,1.,,,\"Upper bound on roundness for feature detection\"\nmkdetections,b,h,no,,,\"Mark detections on the image display ?\"\nmode,s,h,\"ql\",,,\n", detsig, >> "find.par")
# }else if(det_id == 2){ # MIRS
#	 printf("threshold,r,h,%5.2f,,,\"Threshold in sigma for feature detection\"\nnsigma,r,h,2.0,,,\"Width of convolution kernel in sigma\"\nratio,r,h,1.0,0.,1.,\"Ratio of minor to major axis of Gaussian kernel\"\ntheta,r,h,0.,0.,180.,\"Position angle of major axis of Gaussian kernel\"\nsharplo,r,h,0.2,,,\"Lower bound on sharpness for feature detection \"\nsharphi,r,h,1.,,,\"Upper bound on sharpness for  feature detection\"\nroundlo,r,h,-1.,,,\"Lower bound on roundness for feature detection\"\nroundhi,r,h,1.,,,\"Upper bound on roundness for feature detection\"\nmkdetections,b,h,no,,,\"Mark detections on the image display ?\"\nmode,s,h,\"ql\",,,\n", detsig, >> "find.par")
# }else{
#	 printf("threshold,r,h,%5.2f,,,\"Threshold in sigma for feature detection\"\nnsigma,r,h,2.0,,,\"Width of convolution kernel in sigma\"\nratio,r,h,1.0,0.,1.,\"Ratio of minor to major axis of Gaussian kernel\"\ntheta,r,h,0.,0.,180.,\"Position angle of major axis of Gaussian kernel\"\nsharplo,r,h,0.2,,,\"Lower bound on sharpness for feature detection \"\nsharphi,r,h,1.,,,\"Upper bound on sharpness for  feature detection\"\nroundlo,r,h,-1.,,,\"Lower bound on roundness for feature detection\"\nroundhi,r,h,1.,,,\"Upper bound on roundness for feature detection\"\nmkdetections,b,h,no,,,\"Mark detections on the image display ?\"\nmode,s,h,\"ql\",,,\n", detsig, >> "find.par")
# }

 printf("scale,r,h,1.0,0.,,\"Image scale in units per pixel\"\nfwhmpsf,r,h,%5.2f,0.,,\"FWHM of the PSF in scale units\"\nemission,b,h,yes,,,\"Features are positive ?\"\nsigma,r,h,%8.3f,0.,,\"Standard deviation of background in counts\"\ndatamin,r,h,%8.1f,,,\"Minimum good data value\"\ndatamax,r,h,%8.1f,,,\"Maximum good data value\"\nnoise,s,h,\"poisson\",|poisson|,,\"Noise model\"\nccdread,s,h,\"\",,,\"CCD readout noise image header keyword\"\ngain,s,h,\"\",,,\"CCD gain image header keyword\"\nreadnoise,r,h,%5.2f,,,\"CCD readout noise in electrons\"\nepadu,r,h,%5.2f,,,\"Gain in electrons per count\"\nexposure,s,h,\"\",,,\"Exposure time image header keyword\"\nairmass,s,h,\"\",,,\"Airmass image header keyword\"\nfilter,s,h,\"\",,,\"Filter image header keyword\"\nobstime,s,h,\"\",,,\"Time of observation image header keyword\"\nitime,r,h,%8.4f,,,\"Exposure time\"\nxairmass,r,h,INDEF,,,\"Airmass\"\nifilter,s,h,INDEF,,,\"Filter\"\notime,s,h,INDEF,,,\"Time of observation\"\nmode,s,h,\"ql\",,,\n", fwhm, sdev_sky, lower, upper, rnoise, epadu, exptime, >> "data.par")

# Source extraction with daofind
 if( access(image//".coo.0") ){	delete(image//".coo.0", ver-) }
 if (!deftask ("noao.digiphot.apphot.daofind")) {
	noao.digiphot.apphot
 }
 if(det_id==1){ # NIR$B$@$C$?$i(B
	daofind (image, output=image//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
 }else{
	if(expid!=1){
	 daofind ("skysub.fits", output=originalname//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
	}else{
	 daofind (image, output=image//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
	}
 }

# clean
 if( access("skysub.fits") ){ imdel("skysub.fits", ver-) }
 delete("find.par", ver-)
 delete("data.par", ver-)

end
