# source_extract.cl -- To extract sources
# Created: Yoshifusa Ita, 07-Jul-05

procedure source_extract3 (img, detid, det_sig, sig_rej, exp_time, data_max, bad_data, ep_adu, r_noise, fwathm, verbose)
string  mode="al"

string img        {"image.fits", prompt="image fits file name"}
int    detid      {1,min=0,max=3, prompt="Detector ID: 0SPITXER,1NIR,2MIRS,3MIRL"}
real   det_sig    {3.,min=1.,max=1000., prompt="Number of sigmas for detection limits"}
real   sig_rej    {2.5,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
real   exp_time   {51.4272,min=0.1,max=120., prompt="Integration time"}
real   data_max   {60000.,min=0.,max=99999., prompt="Initial upper limit for data range [ADU]"}
real   bad_data   {-5000.,min=-99999.,max=0., prompt="egnore any pixels below this level.[ADU]"}
real   ep_adu     {10.,min=1.,max=100., prompt="Analog to Digital unit/gain [electrons/ADU]"}
real   r_noise    {10.,min=1.,max=100., prompt="Read out noise [electrons]"}
real   fwathm     {1.,min=1.,max=50., prompt="Mean FWHM [pixels]"}
int    maxitr     {10,min=1,max=10, prompt="Maximum number of iterations"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string image, originalname, pcommand
 real detsig, exptime, upper, lower, epadu, rnoise, fwhm
 real skyval, sdev_sky
 real mean, sigma, median, modee
 int i, npix, det_id
 real ll, ul
 int maxiter
 real nsigrej
 real baddata
 real pixscale
 bool verb

# Get query parameter
 image = img
 det_id = detid
 detsig = det_sig
 exptime = exp_time
 upper = data_max
# lower = bad_data
 lower = -1000.0
 epadu = ep_adu
 rnoise = r_noise
 fwhm = fwathm
 maxiter = maxitr
 nsigrej = sig_rej
 verb = verbose

 if(det_id==1){
	pixscale = 1.446
 }else if(det_id==2){
	pixscale = 2.340
 }else if(det_id==3){
	pixscale = 2.384
 }else if(det_id==0){
	pixscale = 1.199998800
 }else{
 	print("something is wrong!\n")
	bye
 }


# S$B$H(BL$B$N>l9g$O!"%9%+%$$,$&$M$C$F$$$k$N$G!"(Bmedianbox$B%U%#%k%?$r$7$?2hA|$r0z$$$F(B
# $B%F%s%]%i%j$J%$%a!<%8$r:n$j!"$=$l$KBP$7$F(Bsource_extraction$B$9$k!#(B
 originalname = image
 if(det_id!=1){ # NIR$B$8$c$J$+$C$?$i(B
	if( access("median.fits") ){ del("median.fits", ver-) }
	if( access("skysub.fits") ){ del("skysub.fits", ver-) }
	fmedian (image, "median.fits", 31, 31, hmin=0, hmax=60000, zmin=0, zmax=60000, zloreject=0, zhireject=60000, unmap=yes, boundary="nearest", constant=0., verbose=verb)
	imarith (image, "-", "median.fits", "skysub.fits", title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
	if( access("median.fits") ){ imdel("median.fits", ver-) }
	image = "skysub.fits"
 }


# source extractor$B$r$d$kA0$N=`Hw(B
 if( access("default.sex") ){ del("default.sex", ver-) }
 if( access("default.param") ){ del("default.param", ver-) }
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"mksextractor.pl"
 printf("! %s %f %f %f\n", pcommand, epadu, pixscale, fwhm) | cl


# source extractor$B$K$+$1$k(B
 printf("! sex %s\n", image) | cl
 if( access(originalname//".coo.0") ){ delete(originalname//".coo.0", ver-) } 
 printf("! awk '{if($3<80)print}' test.cat > %s.coo.0\n", originalname) | cl


# clean
 if( access("skysub.fits") ){ imdel("skysub.fits", ver-) }
 if( access("default.sex") ){ del("default.sex", ver-) }
 if( access("default.param") ){ del("default.param", ver-) }
 if( access("test.cat") ){ del("test.cat", ver-) }

end
