## aspect_ratio.cl -- To resample the aspect ratio -> x:y=1:1
## Created: Yoshifusa Ita, 11-Apr-07
## modified: 2010/10/25 (F. Egusa), add 'blank' option
##           2010/12/27 (F. Egusa), mask handling updated
##           2014/03/03 (F. Egusa), add 'double' option, 
##             if double=yes, linear interpolation is used instead of drizzle

procedure aspect_ratio(ircconst, logfile, prefixs, blankval, deltemp, verbose, double)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"mfCcDlnw", prompt="prefix string"}
real   blankval {-9999.9,max=-1000., prompt="value for blank/masked pixels"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
bool   double = yes {prompt="Double the image size?"}
struct *list0

begin

 string fname, outname
 string libpath, text
 string irc_const, irclog
 string prefix
 string detector
 real   nx, ny, sx, sy, lx, ly, rx, ry, jacobian
 bool   verb, deltmp, dpix
 real   blank, thblank

## get query parameters
 irc_const = ircconst
 irclog = logfile
 verb = verbose
 deltmp = deltemp
 prefix = prefixs
 blank = blankval
 dpix=double

## set default parameter
 libpath = osfn ("irclib$")
 thblank = -0.1

 print ("\n")
 print ("### ASPECT_RATIO ###\n")

## make input file list
 print ("Making the input file list...\n")
 if( access("temp.list") ){ delete("temp.list", ver-) }
 print("! grep -v '#' "//irclog//" | awk '{print $1}' > temp.list") | cl


## Read irc constants
 irc_const = libpath//irc_const
 ## Mask file name
 printf("! grep NIRXaspect  %s\n", irc_const) | cl | scan(text, nx)
 printf("! grep NIRYaspect  %s\n", irc_const) | cl | scan(text, ny)
 printf("! grep MIRSXaspect %s\n", irc_const) | cl | scan(text, sx)
 printf("! grep MIRSYaspect %s\n", irc_const) | cl | scan(text, sy)
 printf("! grep MIRLXaspect %s\n", irc_const) | cl | scan(text, lx)
 printf("! grep MIRLYaspect %s\n", irc_const) | cl | scan(text, ly)


## Resampling -> 1:1
 print("Resampling aspect ratio...\n")
 print("\t #This may take a while...\n")
 list0 = "temp.list"
 while (fscan(list0, fname) != EOF) {
    fname = prefix//fname//".fits"
    hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
    if (detector == "NIR") { # NIR
       rx = nx
       ry = ny
    } else if (detector == "MIRS") { # MIRS
       rx = sx
       ry = sy
    } else if (detector == "MIRL") { # MIRL
       rx = lx
       ry = ly
    }

    outname = "e"//fname
    if (access(outname)) imdel(outname, yes, verify=no, default_acti=yes)
    if (access("tmp.fits")) imdel("tmp.fits",yes,ver-,default+)
    if (dpix) {
       magnify(fname,"tmp.fits",rx*2.,ry*2.,x1=INDEF,x2=INDEF,dx=INDEF,y1=INDEF,y2=INDEF,dy=INDEF,interp="linear",boundary="constant",constant=blank,fluxcon+,logfile="")
    } else {
       magnify(fname,"tmp.fits",rx,ry,x1=INDEF,x2=INDEF,dx=INDEF,y1=INDEF,y2=INDEF,dy=INDEF,interp="drizzle[0.5]",boundary="constant",constant=blank,fluxcon+,logfile="")
    }

    ## make blank fits
    if (access("blank.fits")) imdel("blank.fits")
    if (access("blank.mag.fits")) imdel("blank.mag.fits")
    imexpr("abs(a-b)<0.1 ? b : 0.","blank.fits",fname,blank,"","","","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real",intype='real')
    if (dpix) {
       magnify("blank.fits","blank.mag.fits",rx*2.,ry*2.,x1=INDEF,x2=INDEF,dx=INDEF,y1=INDEF,y2=INDEF,dy=INDEF,interp="linear",boundary="constant",constant=blank,fluxcon-,logfile="")
    } else {
       magnify("blank.fits","blank.mag.fits",rx,ry,x1=INDEF,x2=INDEF,dx=INDEF,y1=INDEF,y2=INDEF,dy=INDEF,interp="drizzle[0.5]",boundary="constant",constant=blank,fluxcon-,logfile="")
    }

    ## mask pixels according to magnified blank fits
    imexpr("b>d ? a : c",outname,"tmp.fits","blank.mag.fits",blank,thblank,"","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real",intype='real')

    ## header update
    ccdhedit(outname,paramete='DBLPIX',value=dpix,type='string')

    if (deltmp) {
       imdel(fname, yes, verify=no, default_acti=yes)
    }
 }


## cleaning
 if( access("temp.list") ){ delete("temp.list", ver-) }

 print ("### ASPECT_RATIO finished!! ###\n")

end
