## dark.cl -- To subtract dark 
# Created: Yoshifusa Ita, 15-Sep-05
# 27-Sep-06 - Add function to account for the dark level change duling a pointing observation (Y. Ita)
# 09-Nov-06 (T.WADA) code reduced. share code in calculation of dark offset.
# 09-Nov-06 (T.WADA) code reduced. use build-in sigma cliping of imstat.
# 09-Nov-06 (T.WADA) avoid floating exception when most of
#             pixel has almost same value (short of NIR).
# 13-Nov-06 (T.WADA) bug fix. not use self dark for short exp frames 
# 15-Nov-06 (T.WADA) use HEADER KEYWORD EXPID to select long exp frames
# 15-Nov-06 (T.WADA) for making self dark
#                    median=>average
#                    sigclip=>ccdclip (use noise, epadu info from header)
#                    use hthreshold 1000=>INDEF (for MIR-L, where
#                    many hot pixels appear)
# 05-Feb-07 (T.WADA) masked region dark level analysis
#                    lower/upper limits, nclip changed
#                    use mode instead of median to be more robust
## modified: 2010/10/14 (F. Egusa), add the option darktype & darkfile
##   'wraparound', 'ircnorm', & 'linearize' for dark before subtraction
##           2010/11/10 (F. Egusa), add 'smdark' option
##	     2010/12/13 (F. Egusa), add 'delsmd' option
##           2014/02/28 (F. Egusa), updated for 'darktype=ne' option

procedure dark(ircconst,darkfile,logfile,prefixs,darktype,deltemp,verbose,smdark,delsmd)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string darkfile {prompt="list of dark files"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"D", prompt="prefix string"}
string darktype {prompt="type of dark: ne (neighbor), su (super), se (self), us (user)"}
bool deltemp = yes {prompt="Delete temporary files?"}
bool verbose = no  {prompt="Print verbose progress messages?"}
bool smdark = yes  {prompt="Apply self-made dark for NIR-long?"}
bool delsmd = yes  {prompt="Delete proccessed self-made dark for each frame?"}

struct *list0

begin
 string irc_const_org,irc_const,darklist,irclog,prefix,dtype
 bool verb,deltmp,sm_dark,del_smd

 string libpath
 string text
 string fname, outname, fname_org
 string n_short, n_long, s_short, s_long, l_short, l_long
 int expid
 string darkimage
 string aot, detector, dver
 string area
 int i, npix, sigrej
 real mean, median, modee, sigma, lower, upper, ll, ul, max, min
 real lowdef,updef
 real slitdark, slitsuperdark, darkshift
	
 real epadu_s,epadu_l
 real rnoise_s,rnoise_l

 string afits,bfits,smregion
 int maxitr,minnpix,n
 real const

 print ("\n")
 print ("### SUBTRACT DARK ###\n")


## get query parameters
 irc_const_org = ircconst
 irclog = logfile
 darklist = darkfile
 dtype = darktype
 verb = verbose
 deltmp = deltemp
 prefix = prefixs
 sm_dark = smdark
 del_smd = delsmd

## set default parameters
 libpath = osfn ("irclib$")
 sigrej = 2.0
 lowdef=-1000.
 updef=10000.

 afits = libpath//"dark/AKARIsmdark/NIR_aij.fits"
 bfits = libpath//"dark/AKARIsmdark/NIR_bij.fits"
 smregion = "[301:412,401:512]"
 maxitr = 10


## check input
 if (dtype != 'ne' && dtype != 'su' && dtype != 'se' && dtype != 'us') {
    print('## ERROR: darktype should be one of ne/su/se/us !')
    bye
}


## User dark (read darklist instead of irc_const)
 if (dtype == "us") {
    printf("! grep darkNIRshort  %s\n", darklist) | cl | scan(text, n_short)
    printf("! grep darkNIRlong   %s\n", darklist) | cl | scan(text, n_long)
    printf("! grep darkMIRSshort %s\n", darklist) | cl | scan(text, s_short)
    printf("! grep darkMIRSlong  %s\n", darklist) | cl | scan(text, s_long)
    printf("! grep darkMIRLshort %s\n", darklist) | cl | scan(text, l_short)
    printf("! grep darkMIRLlong  %s\n", darklist) | cl | scan(text, l_long)

 } else {

## if not User dark, make a list of super dark images except MIR long
## and copy them to CWD

    ## Read irc constants
    irc_const = libpath//irc_const_org
    printf("! grep darkNIRshort  %s\n", irc_const) | cl | scan(text, n_short)
    printf("! grep darkNIRlong   %s\n", irc_const) | cl | scan(text, n_long)
    printf("! grep darkMIRSshort %s\n", irc_const) | cl | scan(text, s_short)
    printf("! grep darkMIRLshort %s\n", irc_const) | cl | scan(text, l_short)
    printf("! grep darkver       %s\n", irc_const) | cl | scan(text, dver)

    ## find AOT parameter from the first frame on the list
    print("!grep -v '#' "//irclog//" | head -1 | awk '{print $1\".fits\"}'") | cl | scan(fname)
    hselect(fname,"AOT","yes") | scan(aot)
    if (aot == "IRC05") {
       text = "dark/aot05/"
    } else {
       text = "dark/"
    }

    ## make a list of dark images (darklist)
    if (access(darklist)) del(darklist)
    print("## list of dark images", > darklist)
    printf("darkNIRlong   %s\n", n_long, >> darklist) 
    printf("darkNIRshort  %s\n", n_short, >> darklist) 
    printf("darkMIRSshort %s\n", s_short, >> darklist) 
    printf("darkMIRLshort %s\n", l_short, >> darklist) 

    ## copy the dark images
    if (!sm_dark) { # no need to copy NIR long dark if using self made dark
       if (access(n_long)) imdel(n_long)
       imcopy(libpath//text//n_long,n_long,ver-)
    }
    if (access(n_short)) imdel(n_short)
    if (access(s_short)) imdel(s_short)
    if (access(l_short)) imdel(l_short)
    imcopy(libpath//text//n_short,n_short,ver-)
    imcopy(libpath//text//s_short,s_short,ver-)
    imcopy(libpath//text//l_short,l_short,ver-)

 }

## Super dark (update the list and copy MIR long from the toolkit)
 if (dtype == 'su') {
    printf("! grep darkMIRSlong %s | awk '{print $2}'\n", irc_const) | cl | scan(s_long)
    printf("! grep darkMIRLlong %s | awk '{print $2}'\n", irc_const) | cl | scan(l_long)
    printf("darkMIRSlong %s\n", s_long, >> darklist) 
    printf("darkMIRLlong %s\n", l_long, >> darklist) 
    if (access(s_long)) imdel(s_long)
    if (access(l_long)) imdel(l_long)
    imcopy(libpath//text//s_long,s_long,ver-)
    imcopy(libpath//text//l_long,l_long,ver-)
 }

## Neighbor dark (update the list and copy MIR long from ../dark)
 if (dtype == 'ne') {
    s_long='ndarkS.d0n11.fits'
    l_long='ndarkL.d0n11.fits'
    printf("darkMIRSlong %s\n", s_long, >> darklist) 
    printf("darkMIRLlong %s\n", l_long, >> darklist) 
    if (access(s_long)) imdel(s_long)
    if (access(l_long)) imdel(l_long)
    imcopy('../dark/'//s_long,s_long,ver-)
    imcopy('../dark/'//l_long,l_long,ver-)
 }

## Self dark (make MIR long from pre-dark frames)
 if (dtype == "se") {
    if (!access("darklist.before")) {
       print("cannot read darklist.before\n")
#       print("will use super-dark\n")
#       goto reduction
       bye
    }
    if (access("dark.mirs")) { delete("dark.mirs", ver-) }
    if (access("dark.mirl")) { delete("dark.mirl", ver-) }
    list0 = "darklist.before"
    while (fscan(list0,fname) != EOF) {
       fname = fname//".fits"
       hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
       # 2006/11/15 use long exp frame only for self dark
       hselect(fname, fields="EXPID"   , expr="yes") | scan(expid)
       if (expid != 1) {
	  if (detector == "MIRS") {
	     printf("%s\n", fname, >> "dark.mirs")
	     # for ccdcliping... 2006/11/15
	     hselect(fname, fields="GAIN"    , expr="yes") | scan(epadu_s)
	     hselect(fname, fields="RNOISE"  , expr="yes") | scan(rnoise_s)
	  } else if (detector == "MIRL") {
	     printf("%s\n", fname, >> "dark.mirl")
	     # for ccdcliping... 2006/11/15
	     hselect(fname, fields="GAIN"    , expr="yes") | scan(epadu_l)
	     hselect(fname, fields="RNOISE"  , expr="yes") | scan(rnoise_l)
	  }
       }
    }

## (1)sigclip is not valid for small number of frames
##    N^2 frames must be used for N sigma clipping at least.
##    number of dark in the pointing is small, so 
## (2) dark.mirs/l contains "short frame"! median is not bad idea, but..
## (3) some hot pixels of MIR-L exceed 1000[ADU] in long frame!
##    for this reason, combined dark of MIR-L has strange hot pixels
##    which have very low top but high wing.
##    This makes clear "hot" pixels on dark subtracted image and 
##    causes troubles when co-adding.
## 			
    if (access("dark_mirs_long.fits")) imdel("dark_mirs_long.fits", yes, verify=no, default_acti=yes) 
    if (access("dark_mirl_long.fits")) imdel("dark_mirl_long.fits", yes, verify=no, default_acti=yes) 
    if (access("dark.mirs")) {
       imcombine ("@dark.mirs", "dark_mirs_long.fits", headers="", bpmasks="", rejmasks="", nrejmasks="", expmasks="", sigmas="", logfile="", combine="average", reject="ccdclip", project=no, outtype="real", outlimits="", offsets="none", masktype="none", maskvalue=0., blank=0., scale="none", zero="none", weight="none", statsec="", expname="", lthreshold=-200, hthreshold=INDEF, nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=sigrej, hsigma=sigrej, rdnoise=rnoise_s, gain=epadu_s, snoise="0.", sigscale=0.1, pclip=-0.5, grow=0.)
       print("\t Made a dark image: dark_mirs_long.fits\n")

       ## update darklist & s_long
#       if (access("tmp.dlist")) del("tmp.dlist")
#       print("!grep -v darkMIRSlong "//darklist//" > tmp.dlist") | cl
#       print("darkMIRSlong  dark_mirs_long.fits", >> "tmp.dlist")
#       print("! mv -f tmp.dlist "//darklist) | cl
       s_long = "dark_mirs_long.fits"
       printf("darkMIRSlong %s\n", s_long, >> darklist) 
    }

    if (access("dark.mirl")) {
       imcombine ("@dark.mirl", "dark_mirl_long.fits", headers="", bpmasks="", rejmasks="", nrejmasks="", expmasks="", sigmas="", logfile="", combine="average", reject="ccdclip", project=no, outtype="real", outlimits="", offsets="none", masktype="none", maskvalue=0., blank=0., scale="none", zero="none", weight="none", statsec="", expname="", lthreshold=-200, hthreshold=INDEF, nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=sigrej, hsigma=sigrej, rdnoise=rnoise_l, gain=epadu_l, snoise="0.", sigscale=0.1, pclip=-0.5, grow=0.)
       print("\t Made a dark image: dark_mirl_long.fits\n")

       ## update darklist & l_long
#       if (access("tmp.dlist")) del("tmp.dlist")
#       print("!grep -v darkMIRLlong "//darklist//" > tmp.dlist") | cl
#       print("darkMIRLlong  dark_mirl_long.fits", >> "tmp.dlist")
#       print("! mv -f tmp.dlist "//darklist) | cl
       l_long = "dark_mirl_long.fits"
       printf("darkMIRLlong %s\n", l_long, >> darklist) 
    }
 }


reduction:
## apply 'wraparound', 'ircnorm', & 'linearity' for dark images
 if (access("tmp.dlist")) del("tmp.dlist")
 if (!sm_dark) {
    print("! grep -v '#' "//darklist//" | awk '{print $2}' | sed s/'.fits'/''/g > tmp.dlist") | cl
 } else {
    print("! grep -v '#' "//darklist//" | grep -v darkNIRlong | awk '{print $2}' | sed s/'.fits'/''/g > tmp.dlist") | cl
 }
 wraparound(irc_const_org,"tmp.dlist","",no,verb)
 ircnorm(irc_const_org,"tmp.dlist","w",no,verb)
 linearity(irc_const_org,"tmp.dlist","nw",no,verb)


subtraction:
## make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 print("!cat "//irclog//" | awk '{print $1}' | grep -v '#' > filename.list") | cl

## subtract dark
 print ("Subtracting dark...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while (fscan(list0,fname_org) != EOF) {
    fname = prefix//fname_org//".fits"
    hselect(fname, fields="EXPID", expr="yes")    | scan(expid)
    hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
    hselect(fname,"AOT","yes") | scan(aot)
    outname = "D"//fname
    if (access(outname)) imdel(outname, yes, verify=no, default_acti=yes)
    ## channel dependence	
    if (detector == "NIR") { # NIR
       if (expid == 1) {
       	  darkimage = "lnw"//n_short
       } else {
          if (sm_dark) goto smdark
	  darkimage = "lnw"//n_long
       }
       area = "[1:412,397:512]"
    } else if (detector == "MIRS") { # MIRS
       if (expid == 1) {
       	  darkimage = "lnw"//s_short
       } else {
       	  darkimage = "lnw"//s_long
       }
       area = "[1:20,1:256]"
    } else if (detector == "MIRL") { # MIRL
       if (expid == 1) {
	  darkimage = "lnw"//l_short
       } else {
	  darkimage = "lnw"//l_long
       }
       area = "[246:256,82:200]"
    }

## 2007/02/05 T.WADA for debug....
## for some frame ($B$H$/$K(BMIR-L$B$GGX7J8w$,Hs>o$K6/$$;~(B)$B$G$O(B mask region$B$H$$$($I$b!"(B $B1L$l9~$K$h$j(B+/-200$B$K<}$^$i$J$$>l9g$,$"$k!#!#!#!#!#(B
## $B$3$N$?$a!"(Blower-upper$B$N4V$N(Bvalue$B$r;}$D(Bpixel$B$,L5$/$J$j!"(Bimstat$B$G(Bflowting over follow$B$,H/@8$9$k!#(B
##  ex 3110004.1/rawdata/waF003166247_L002.fits ....
##
## $B:,K\E*$K$O!"(B	$BI,;&!V;6Mp8w%+%C%?!<!W$NF3F~$,BT$?$l$k$,!"!"!"!"(B
##
## $B$5$F!"$I$&$9$k!)(B
##  (1) $B$^$:!"(Bmax/min value$B$r5a$a!":GDc8B$A$g$C$H$O0z$C$+$1$k$h$&$K$7$F$*$/$N$,$h$$$N$G$O!)(B 
##      >>>$B$=$b$=$b$J$<(Blower,upper$B$r@_Dj$9$kI,MW$,M-$C$?$N$@$m$&$+!)(B
##  (2) $B$$$C$=$N$3$H(BINDEF$B$K$7$F$7$^$*$&$+(B? 
##  (3) $B$H$j$"$($:(Blower/upper$B$O8=<BE*$JCM(B (MIR-L$B$K$D$$$F$O(B 200=>-1000?+10000)$B$K(B
##  (4) max/min$B$KF~$C$F$$$J$+$C$?$i!"(Bwarning$B$r=P$7$D$D!"(B lower/upper$B$r(BINDEF$B$K$7=hM}$OB3$1$k(B
##  (5) median(midpt)$B$h$j(Bmode$B$NJ}$,%m%P%9%H$C$]$$!#!#!#!#(B
##  (6) cliping$B$GCF$1$k$N$G$O!)(B
##	(3)+(4)+(5)+(6)
    lower=lowdef
    upper=updef

    if (verb) {
       imstat(fname//area, fields="npix,mean,midpt,mode,stddev,min,max", lower=INDEF, upper=INDEF,lsigma=sigrej,usigma=sigrej, nclip=0, binwidth=0.1,format=no, cache=no) | scan(npix, mean, median, modee, sigma, min, max)
       printf("debug: %s %s %g %g %g %g %g\n",fname,area,lower,upper,sigrej, min,max)
    }

    imstat(fname//area, fields="npix", lower=lower, upper=upper, format=no, cache=no) | scan(npix)
    if (npix <= 100) {  # avoid floating exception in imstat
       lower = INDEF
       upper = INDEF
       printf("warning: too few number of pixels %d are found in masked region of %s\n",npix,fname//area)
       printf("warning: set lower/upper to INDEF\n")
    }

    ## estimate dark level at the slit region of "target frame"
    imstat(fname//area, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper,lsigma=sigrej,usigma=sigrej, nclip=100, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)			
    if (verb) {
       printf("debug: %s %s %g %g %g %g %g\n",fname,area,npix,mean,median,modee,sigma)
    }
		
# median$B$,7W;;=PMh$J$$$N$O!"$*$=$i$/A4$F$N(Bpixel$B$,(Breject$B$5$l$F!";D$i$J$+$C$?$+$i!#(B
# $B$=$l$O!"$9$Y$F$N(Bpixel$B$NCM$,F1$8$P$"$$$K5/$-$k(B($B$H$/$K(BNIR$B$N(Bshort$B$O!"$b$H$b$H(Bdark$B$,6K>.$J$&$(!"(Bbitshift$B$K$h$j(B1/4, 1/16$B$K$J$C$F$$$k$?$aNL;R2=OD$K$h$j(Ball zero$B$K$J$j$,$A(B)
    if (modee != INDEF) {
       slitdark = modee
    } else { 	
       slitdark = mean
    }

    ## estimate dark level at the slit region of "dark frame"
    ## reset lower/upper
    lower = lower
    upper = upper
    imstat(darkimage//area, fields="npix", lower=lower, upper=upper, format=no, cache=no) | scan(npix)
    if (npix <= 100) {  # avoid floating exception in imstat
       lower = INDEF
       upper = INDEF
       printf("warning: too few number of pixels %d are found in masked region of %s\n",npix,darkimage//area)
printf("warning: set lower/upper to INDEF\n")
    }
    imstat(darkimage//area, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper,lsigma=sigrej,usigma=sigrej, nclip=100, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
    if (verb) {
       printf("debug: %s %s %g %g %g %g %g\n",darkimage,area,npix,mean,median,modee,sigma)
    }
			
    if (modee != INDEF) {
       slitsuperdark = modee
    } else {
       slitsuperdark = mean
    }

    darkshift = slitdark - slitsuperdark
    if (verb) {
       printf("dark.cl: %s tmp:%f sup:%f t-s:%f\n",fname, slitdark, slitsuperdark, darkshift)
    }

    ## dark subtraction
    if (access("tmp1.fits")) imdel("tmp1.fits")
    imarith (fname,"-",darkimage, "tmp1.fits", title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
    ## offset correction using masked area value
    imarith ("tmp1.fits", "-", darkshift, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)

    ## update the header
    if (dtype == "us") {
       hedit(outname,"DRKTYPE","USERDARK",add+,update+,show-,ver-)
    } else {
       if (dtype == "su") goto suupdate
       if (expid == 1) goto suupdate
       if (detector == "NIR") goto suupdate
       if (dtype == 'ne') hedit(outname,'DRKTYPE','NEIGHBORDARK',add+,update+,show-,ver-)
       if (dtype == "se") hedit(outname,"DRKTYPE","SELFDARK",add+,update+,show-,ver-)
       goto endupdate

       suupdate:
       hedit(outname,"DRKTYPE","SUPERDARK",add+,update+,show-,ver-)
       hedit(outname,"DARKVER","v"//dver,add=no,addonly=yes,delete=no,verify=no,show=no,update=yes)
       endupdate:
    }

    ccdhedit (outname, paramete="DRKSHIFT", value=darkshift,type="real")
    ccdhedit (outname, paramete="DRKAREA",  value=area,type="string")
    ccdhedit (outname, paramete="DRKEST",   value=slitdark,type="real")
    ccdhedit (outname, paramete="DRKESTRF", value=slitsuperdark,type="real")

    goto endloop


    smdark:
    ## self-made dark subtraction for NIR-long if requested
    ## use the original image for statistics
    imstat(fname_org//smregion,fields="npix,mean,stddev,midpt",format-) | scan(npix,mean,sigma,median)
    minnpix = npix*0.02
    const = mean
    n = 1
    while (n <= maxitr) {
       ll = median - sigma*3.
       ul = median + sigma*3.
       imstat(fname_org//smregion,fields="npix,mean,stddev,midpt",lower=ll,upper=ul,nclip=0,format-) | scan(npix,mean,sigma,median)
       const = mean
       if (npix <= minnpix) goto stopcalc
       n = n + 1
    }
    stopcalc:
    if (access("tmp1.fits")) imdel("tmp1.fits")
    imexpr("c*a+b","tmp1.fits",afits,bfits,const,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",verb-)
    hedit("tmp1.fits","DETECTOR","NIR",add+,update+,show-,ver-)
    hedit("tmp1.fits","AOT",aot,add+,update+,show-,ver-)
    hedit("tmp1.fits","EXPID",expid,add+,update+,show-,ver-)

    if (access("tmp.dlist")) del("tmp.dlist")
    print("tmp1", >> "tmp.dlist")
    wraparound(irc_const_org,"tmp.dlist","",no,verb)
    ircnorm(irc_const_org,"tmp.dlist","w",no,verb)
    linearity(irc_const_org,"tmp.dlist","nw",no,verb)
    imarith(fname,"-","lnwtmp1.fits",outname,pixtype="real",calctype="double",verbose=verb)
    hedit(outname,"DRKTYPE","SMDARK",add+,update+,show-,ver-)
    ccdhedit(outname,paramete="SMDRKNPX",value=npix,type="integer")
    ccdhedit(outname,paramete="SMDRKC",value=const,type="real")
    ccdhedit(outname,paramete="SMDRKSIG",value=sigma,type="real")

    if (!del_smd) {
       outname="smd_"//fname
       if (access(outname)) imdel(outname)
       imcopy("lnwtmp1.fits",outname,verb-)
       ccdhedit(outname,paramete="SMDRKNPX",value=npix,type="integer")
       ccdhedit(outname,paramete="SMDRKC",value=const,type="real")
       ccdhedit(outname,paramete="SMDRKSIG",value=sigma,type="real")
    }
		
    endloop:
    if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }


# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### SUBTRACT DARK finished!! ###\n")

end

