# distortion.cl -- To correct the IRC distortion
# Created: Yoshifusa Ita, 29-Aug-05

procedure distortion (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile {"irclog", prompt="output of the mkirclog"}
string prefixs {"d", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0
struct *list1

begin

 string libpath
 string filename, filter, outname
 string datafilename
 string prefix
 string irc_const
 string text, distver
 real   cpix1, cpix2
 int    i
 bool verb, deltmp

 print ("\n")
 print ("### DISTORTION ###\n")


# get query parameters
 irc_const = ircconst
 verb = verbose
 deltmp = deltemp
 prefix = prefixs


# read ircconst
 libpath = osfn ("irclib$")
 irc_const = libpath//irc_const
 printf("! grep distver %s\n", irc_const) | cl | scan(text, distver)


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Read the distortion data base and correct distortion
 print ("Correcting distortion...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, filename) !=EOF){ 
	filename = prefix//filename//".fits"
        hedit (filename, "DISTVER", "v"//distver, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
        hselect (filename, fields="FILTER", expr="yes") | scan(filter)

 	outname = "d"//filename
        if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	datafilename = libpath//"distortion/"//filter//"_distortion_database.dat"

 	geotran (filename, outname, datafilename, "record.dat", geometry="geometric", xin=1, yin=1, xshift=INDEF, yshift=INDEF, xout=1, yout=1, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1., yscale=1., ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., interpolant="linear", boundary="constant", constant=-9999., fluxconserve=yes, nxblock=2048, nyblock=2048, verbose=verb)

	# rewrite CPIX1 and CPIX2
        hselect (filename, fields="CPIX1", expr="yes") | scan(cpix1)
        hselect (filename, fields="CPIX2", expr="yes") | scan(cpix2)
        if( access("wcs_center.pix") ){ delete("wcs_center.pix", ver-) }
        printf("%7.2f %7.2f\n", cpix1, cpix2, > "wcs_center.pix")
	if( access("wcs_center.xy") ){ delete("wcs_center.xy", ver-) }
	geoxytran("wcs_center.pix", "wcs_center.xy", datafilename, "record.dat", geometry="geometric", direction="backward", xref=INDEF, yref=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xout=INDEF, yout=INDEF, xshift=INDEF, yshift=INDEF, xcolumn=1, ycolumn=2, calctype="double", xformat="%f", yformat="%f", min_sigdigit=7)
        list1 = "wcs_center.xy"
	i = fscan(list1, cpix1, cpix2)
        ccdhedit (outname, paramete="CPIX1", value=cpix1, type="real")
        ccdhedit (outname, paramete="CPIX2", value=cpix2, type="real")
        if( access("wcs_center.pix") ){ delete("wcs_center.pix", ver-) }
        if( access("wcs_center.xy")  ){ delete("wcs_center.xy", ver-) }

        if (deltmp) imdel(filename, yes, verify=no, default_acti=yes)
 }


# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }


 print ("### DISTORTION finished!! ###\n")

end
