## flat.cl -- To subtract sky & correct for flat field
# Created: Yoshifusa Ita, 29-Aug-05
# Updated: Yoshifusa Ita, 13-Jun-07 select soramame-ari/nashi according to observing dates.
# Updated: Yoshifusa Ita, 13-Jun-07 users can use their own flat images
## modified: 2010/10/13 (F. Egusa), to apply new flat files for L15 & L24
##           2010/10/22 (F. Egusa), to subtract sky for all the images
##   and to add the header value 'AVGSKY' (average of subtracted sky)
##           2010/11/08 (F. Egusa), add 'subsky' option
##           2011/02/09 (F. Egusa), add 'subLscat' option
## modified: 2013/03/28 (H. Fukushi), set intype=real for imexpr
##           2013/10/23 (F. Egusa), skip if filter name is wrong
## 2014/02/28 (F. Egusa) - add 'pllog' option
## 2014/07/28 (F.Egusa) - updated for new MIR-S flats

procedure flat(ircconst, logfile, prefixs, blankval, deltemp, verbose, subsky, subLscat,pllog)
string  mode="al"

string ircconst  {"constants.database", prompt="IRC constants database file name"}
string logfile   {"irclog", prompt="output of the mkirclog"}
string prefixs   {"CcDlnw", prompt="prefix string"}
real   blankval  {-9999.9,max=-1000., prompt="blank value"}
bool   deltemp = yes     {prompt="Delete intermediate files?"}
bool   verbose = no      {prompt="Print verbose progress messages?\n"}
bool   subsky = yes	 {prompt="Subtract constant sky?"}
bool   subLscat = yes	 {prompt="Subtract scattered light pattern in MIR-L?"}
string  pllog {'ircpipeline.log',prompt='log file for pipeline processes'}

struct *list0, *list1

begin

 string libpath
 string irc_const, irclog,flog
 string fname, outname
 string filter, flatfile
 string n2flat, n3flat, n4flat
 string s7flat, s9wflat, s11flat
 string l15flat, l18wflat, l24flat
 string prefix
 string flatver
 bool verb, deltmp, sub_sky, sub_L
 real blank, ratio
 int status, date, expid
 string path
 string newl15flat,newl24flat,newl18wflat, newflat
 string lname,lsky
 real minsky,maxsky,avgsky
 bool nodeltmp
 real p4start,p5start,p6start,aftmobs

 print ("\n")
 print ("### FLAT FIELDING ###\n")

## get query parameters
 irc_const = ircconst
 irclog = logfile
 verb = verbose
 deltmp = deltemp
 prefix = prefixs
 blank = blankval
 sub_sky = subsky
 sub_L = subLscat
 flog=pllog

## set default parameters
 libpath = osfn ("irclib$")
 nodeltmp = no


## Read irc constants
 irc_const = libpath//irc_const
 # Flat version
 printf("! grep flatver  %s\n", irc_const) | cl | scan(text, flatver)
 # Flat field image for each filter
 printf("! grep N2flat   %s\n", irc_const) | cl | scan(text, n2flat)
 printf("! grep N3flat   %s\n", irc_const) | cl | scan(text, n3flat)
 printf("! grep N4flat   %s\n", irc_const) | cl | scan(text, n4flat)
 printf("! grep S7flat   %s\n", irc_const) | cl | scan(text, s7flat)
 printf("! grep S9Wflat  %s\n", irc_const) | cl | scan(text, s9wflat)
 printf("! grep S11flat  %s\n", irc_const) | cl | scan(text, s11flat)
 printf("! grep L15flat  %s\n", irc_const) | cl | scan(text, l15flat)
 printf("! grep L18Wflat %s\n", irc_const) | cl | scan(text, l18wflat)
 printf("! grep L24flat  %s\n", irc_const) | cl | scan(text, l24flat)
 printf("! grep newL15flat  %s\n", irc_const) | cl | scan(text, newl15flat)
 printf("! grep newL18Wflat %s\n", irc_const) | cl | scan(text, newl18wflat)
 printf("! grep newL24flat  %s\n", irc_const) | cl | scan(text, newl24flat)
## start AFTM-OBS for updated periods
 printf("! grep p4start   %s\n", irc_const) | cl | scan(text, p4start)
 printf("! grep p5start   %s\n", irc_const) | cl | scan(text, p5start)
 printf("! grep p6start   %s\n", irc_const) | cl | scan(text, p6start)


## make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 print("!grep -v '#' "//irclog//" | awk '{print $1}' > filename.list") | cl


## Flat fielding
 print ("Flat fielding...\n")
 print ("\t #This may take a while...\n")
 if (!sub_L) {
    print("\t #Scattered light subtraction for MIR-L NOT performed\n")
    if (sub_sky) {
       print("### Warning: subsky=yes & subLscat=no is NOT proper.")
       print("### Warning: option changed to subsky=no\n")
       print("### Warning: subsky=yes & subLscat=no is NOT proper.", >> flog)
       print("### Warning: option changed to subsky=no\n", >> flog)
       sub_sky=no
    }
 }
 if (!sub_sky) print("\t #Constant sky subtraction NOT performed\n")

 list0 = "filename.list"
 while (fscan(list0, fname) != EOF) {
    fname = prefix//fname//".fits"
    hselect(fname, fields="FILTER", expr="yes") | scan(filter)
    hselect(fname, fields="EXPID", expr="yes") | scan(expid)
#    if (access("obsdate.dat")) delete("obsdate.dat", ver-) 
#    hselect(fname,fields="DATE-REF",expr="yes", >> "obsdate.dat")
#    # convert the obsdate to integer
#    if (access("tmp.dat")) delete("tmp.dat", ver-) 
#    ! cat obsdate.dat | tr 'T' ' ' | awk '{print $1}' | tr '-' '0' > tmp.dat
#    date = 0
#    list1 = "tmp.dat"
#    status = fscan(list1, date)
#    if (date > 2007001008) {
#       path = "soramame-nashi/"
#    } else {
#       path = "soramame-ari/"
#    }
    ## new paths according to updated periods for MIR-S (2014/07/07,FE)
    hselect(fname,fields='AFTM-OBS',expr='yes') | scan(aftmobs)
    if (aftmobs > p6start) {
        path='soramame-nashi/'
    } else if (substr(filter,1,1)=='S') {
       if (aftmobs < p4start) {
          path='soramame-ari/p23/'
       } else if (aftmobs < p5start) {
          path='soramame-ari/p4/'
       } else if (aftmobs < p6start) {
          path='soramame-ari/p5/'
       } 
    } else {
       path='soramame-ari/'
    }

    if (filter == "N2") {
       flatfile = libpath//"flat/"//path//n2flat
    } else if (filter == "N3") {
       flatfile = libpath//"flat/"//path//n3flat
    } else if (filter == "N4") {
       flatfile = libpath//"flat/"//path//n4flat
    } else if (filter == "S7") {
       flatfile = libpath//"flat/"//path//s7flat
    } else if (filter == "S9W") {
       flatfile = libpath//"flat/"//path//s9wflat
    } else if (filter == "S11") {
       flatfile = libpath//"flat/"//path//s11flat
    } else if (filter == "L15") {
       flatfile = libpath//"flat/"//path//l15flat
       newflat = libpath//"flat/"//path//newl15flat
    } else if (filter == "L18W") {
       flatfile = libpath//"flat/"//path//l18wflat
       newflat = libpath//"flat/"//path//newl18wflat
    } else if (filter == "L24") {
       flatfile = libpath//"flat/"//path//l24flat
       newflat = libpath//"flat/"//path//newl24flat
    } else {
       print('!! wrong filter name !!')
       goto nextframe
    }

    outname = "f"//fname
    if (access(outname)) imdel(outname, yes, verify=no, default_acti=yes) 
    ## for MIR-L
    if ((filter == "L15" || filter == "L24") || filter == 'L18W') {
       if (sub_L) {
       	  if (access("tmp1.fits")) imdel("tmp1.fits")
       	  if (access("tmp2.fits")) imdel("tmp2.fits")
       	  imarith(fname,"/",flatfile,"tmp1.fits",divzero=blank,pixtype="real",calctype="double",verbose=verb,noact=no)
       	  imstat("tmp1.fits",lower=blank+0.1,fields="mode",format-,nclip=5,lsigma=5.,usigma=5.) | scan(ratio)
### modified: 2013/03/28 (H. Fukushi)
          imexpr("(d>0) ? (a-b*c)/d : e","tmp2.fits",fname,ratio,flatfile,newflat,blank,"","","","","","","","","","","","","","","","","","","","",intype="real",outtype="real",verb=no)
	  imdel("tmp1.fits")
### modified: 2013/03/28 (H. Fukushi)
          imexpr("(d>0) ? b*c/d : e","tmp1.fits","",ratio,flatfile,newflat,blank,"","","","","","","","","","","","","","","","","","","","",intype="real",outtype="real",verb=no)
	  imstat("tmp1.fits",lower=blank+0.1,fields="mean",format-,nclip=5,lsigma=5.,usigma=5.) | scan(avgsky)
	  hedit("tmp2.fits","AVGSKY",avgsky,ver-,show-,update+,add+)

	  ## add avgsky if subsky=no & subLscat=yes
	  if (sub_sky) {
	     imrename("tmp2.fits",outname,verb-)
	  } else {
### modified: 2013/02/25 (H. Fukushi) 
	     imexpr("abs(a-c)>0.1 ? a+b : c",outname,"tmp2.fits",avgsky,blank,"","","","","","","","","","","","","","","","","","","","","","",intype="real",outtype="real",verb-)
	     hedit(outname,"ADDSKY","yes",ver-,show-,update+,add+)
	  }
       } else {
       	  imarith(fname,"/",newflat,outname,divzero=blank,pixtype="real",calctype="double",verbose=verb,noact=no)
       }

    ## for NIR & MIR-S
    } else {
       if (access("tmp1.fits")) imdel("tmp1.fits")
       imarith(fname,"/",flatfile,"tmp1.fits",divzero=blank,pixtype="real",calctype="double",verbose=verb,noact=no)
       imstat("tmp1.fits",lower=blank+0.1,fields="mode",format-,nclip=5,lsigma=5.,usigma=5.) | scan(ratio)
       if (sub_sky) {
### modified: 2013/02/25 (H. Fukushi) 
	  imexpr("abs(a-c)>0.1 ? a-b : c",outname,"tmp1.fits",ratio,blank,"","","","","","","","","","","","","","","","","","","","","","",intype="real",outtype="real",verb-)
	  hedit(outname,"AVGSKY",ratio,ver-,show-,update+,add+)
       } else {
          imrename("tmp1.fits",outname,verb-)
       }
    }

    hedit(outname,"FLATVER","v"//flatver,add=no,addonly=yes,delete=no,verify=no,show=no,update=yes)

    nextframe:
 }


## check variation of sky levels if subLscat = yes
 if (! sub_L) goto cleanfiles
 if (access("tmp.dat")) delete("tmp.dat",ver-)
 if (sub_sky) {
    print('! ls *.list > tmp.dat') | cl
 } else { 
    ## if subsky=no, check AVGSKY only for MIR-L
    print('! ls L*.list > tmp.dat') | cl
 }
 list0 = "tmp.dat"
 print('### Info: name, min & max of AVGSKY, max/min', >> flog)
 while (fscan(list0,lname) != EOF) {
    # initial values for min & max
    minsky = 100000.
    maxsky = 0.
    if (access(lname)) {
       list1 = lname
       lsky = substr(lname,1,strlen(lname)-5)//".vsky"
       if (access(lsky)) del(lsky)
       while (fscan(list1,fname) != EOF) {
       	  if (access("f"//prefix//fname)) { 
	     hselect("f"//prefix//fname,"AVGSKY",yes) | scan(avgsky)
             minsky = min(minsky,avgsky)
	     maxsky = max(maxsky,avgsky)
	     print(prefix//fname//"   "//avgsky, >> lsky)
	  }
       }
       if (minsky < 100000. && maxsky > 0.) printf('%s %.1f %.1f %.1f\n',lsky,minsky,maxsky,maxsky/minsky, >> flog)
       if (abs(minsky) > 0.1) {
          if (maxsky/minsky > 1.1) {
	     if (! nodeltmp) nodeltmp=yes
       	     printf("### Warning: Large sky variation: %.1f!! Check '%s'\n",maxsky/minsky,lsky)
	  }
       }
    }
 }

 if (deltmp && nodeltmp) {
    print("\n### Message: Files before flat fielding are not to be deleted.\n")
    print("### Message: Files before flat fielding are not to be deleted.\n", >> flog)
    deltmp = no
 }


cleanfiles:
## cleaning
 if (deltmp) {
    list0 = "filename.list"
    while (fscan(list0,fname) != EOF) imdel(prefix//fname//".fits",ver-)
 }
 if (access("temp.list")) delete("temp.list", ver-) 
 if (access("obsdate.dat")) delete("obsdate.dat", ver-) 
 if (access("tmp.dat")) delete("tmp.dat", ver-) 

 print("")
 print ("### FLAT FIELDING finished!! ###\n")

end
