# ircnorm.cl -- To renormalize fowler sampling/ bitshift
# Created: Yoshifusa Ita, 02-Jul-06
## modified: F. Egusa, 2010/10/18  to read the parameter 'logfile' properly

procedure ircnorm (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"a", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
struct *list0

begin

 string fname, outname, libpath, irc_const, irclog
 string aot, detector
 string prefix
 int expid
 bool verb, deltmp

 print ("\n")
 print ("### IRCNORM ###\n")

# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 irclog = logfile
 prefix = prefixs
 verb = verbose
 deltmp = deltemp


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 print("!grep -v '#' "//irclog//" | awk '{print $1}' > filename.list") | cl


# Renormalization
 print("Fowler sampling/bit shift renormalization...\n")
 print("\t #This may take a while...\n")
 list0 = "filename.list"
 while (fscan(list0, fname) != EOF) {
    fname = prefix//fname//".fits"
    hselect(fname, fields="AOT", expr="yes")      | scan(aot)
    hselect(fname, fields="EXPID", expr="yes")    | scan(expid)
    hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
    outname = "n"//fname
    if (access(outname)) imdel(outname, yes, verify=no, default_acti=yes)
    if (detector == "NIR") { # NIR
       if (expid == 1) { 
       	  if (aot == "IRC05") { # for IRC05 NIR short frames
       	     imarith(fname, "*", 4.0, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
          } else { # for the other NIR short frames
	     imcopy(fname, outname, verbose=verb)
          }
       } else { # for all the NIR long frames
       	  imarith(fname, "/", 4.0, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
       }
    } else { # MIR-S & -L
       if (expid == 1) { 
	  imarith(fname, "*", 4.0, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
       } else { 
	  imcopy(fname, outname, verbose=verb)
       }
    }
    if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }

# cleaning
 if (access("filename.list")) delete("filename.list", ver-)

 print ("### IRCNORM finished!! ###\n")

end
