# linearity.cl -- To linearize the IRC data.
# Created: Yoshifusa Ita, 07-Jul-0
## modified: F. Egusa, 2010/10/14  to read the parameter 'logfile' properly

procedure linearity (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"l", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string fname
 string outname
 string detector
 string prefix
 bool verb, deltmp
 string libpath
 string irc_const, irclog
 string linver, text

 print ("\n")
 print ("### LINEARITY ###\n")

# get query parameters
 deltmp = deltemp
 verb = verbose
 prefix = prefixs
 irc_const = ircconst
 irclog = logfile


# read ircconst
 libpath = osfn ("irclib$")
 irc_const = libpath//irc_const
 printf("! grep linver  %s\n", irc_const) | cl | scan(text, linver)


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
# ! cat irclog | perl -e 'while(<>){ chomp; @buf1=split(/\s+/,$_); if($buf1[0] !~ /#/){ printf("%s\n",$buf1[0])} }' > filename.list
 print("!grep -v '#' "//irclog//" | awk '{print $1}' > filename.list") | cl


# linearize
 print ("Linearizing images...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
	fname = prefix//fname//".fits"
        hedit (fname, "LINVER",  "v"//linver, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
        hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
 	outname = "l"//fname
        if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	if(detector == "NIR"){ # NIR
		imexpr ("(a > 1000.) ? (a*b + (a**2)*c + (a**3)*d + (a**4)*e + (a**5)*f + (a**6)*g + (a**7)*h + (a**8)*i + (a**9)*j) : a", outname, fname, "1.0288217", "-4.0339674e-05", "1.3556758e-08", "-1.5086542e-12", "5.9679544e-17", "0.0", "0.0", "0.0", "0.0", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="double", outtype="real", refim="auto", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=verb, exprdb="none", lastout=outname)
		#Standard errors:     0.0045105805   6.7591641e-06   3.0458490e-09   4.8210057e-13   2.3684645e-17
	}else if(detector == "MIRS"){ # MIRS
		imexpr ("(a > 1000.) ? (a*b + (a**2)*c + (a**3)*d + (a**4)*e + (a**5)*f + (a**6)*g + (a**7)*h + (a**8)*i + (a**9)*j) : a", outname, fname, "1.0117087", "-1.3870478e-05", "3.4618232e-09", "-2.1041555e-13", "4.5837121e-18", "0.0", "0.0", "0.0", "0.0", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="double", outtype="real", refim="auto", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=verb, exprdb="none", lastout=outname)
		#Standard errors:    0.00033237094   2.8159453e-07   5.9997030e-11   3.9229506e-15   7.4637208e-20
	}else if(detector == "MIRL"){ # MIRL
		imexpr ("(a > 1000.) ? (a*b + (a**2)*c + (a**3)*d + (a**4)*e + (a**5)*f + (a**6)*g + (a**7)*h + (a**8)*i + (a**9)*j) : a", outname, fname, "1.0220690", "-3.1492003e-05", "1.1540795e-08", "-1.6499665e-12", "1.1428071e-16", "-3.6875836e-21", "4.4799597e-26", "0.0", "0.0", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="double", outtype="real", refim="auto", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=verb, exprdb="none", lastout=outname)
		#Standard errors:     0.0029042023   3.2562978e-06   1.1335970e-09   1.6284845e-13   1.0740803e-17   3.2325874e-22   3.5944922e-27

	}
 	if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }


# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### LINEARITY finished!! ###\n")

end
