## makelist.cl -- to make a list of input files for each filter & exposure
## created: F. Egusa, 2010/10/15

procedure makelist(logfile)

string logfile  {"irclog", prompt="output of the mkirclog"}

struct *list0

begin
 string irclog

 string fname,band
 int expid
 string n2slist,n2llist,n3slist,n3llist,n4slist,n4llist
 string s7slist,s7llist,s9slist,s9llist,s11slist,s11llist
 string l15slist,l15llist,l18slist,l18llist,l24slist,l24llist
 string lname

## get query parameter
 irclog = logfile

## set default parameters
 n2slist = "N2s.list"
 n2llist = "N2l.list"
 n3slist = "N3s.list"
 n3llist = "N3l.list"
 n4slist = "N4s.list"
 n4llist = "N4l.list"
 s7slist = "S7s.list"
 s7llist = "S7l.list"
 s9slist = "S9s.list"
 s9llist = "S9l.list"
 s11slist = "S11s.list"
 s11llist = "S11l.list"
 l15slist = "L15s.list"
 l15llist = "L15l.list"
 l18slist = "L18s.list"
 l18llist = "L18l.list"
 l24slist = "L24s.list"
 l24llist = "L24l.list"

## delete all the previous lists
 if (access(n2slist)) del(n2slist)
 if (access(n2llist)) del(n2llist)
 if (access(n3slist)) del(n3slist)
 if (access(n3llist)) del(n3llist)
 if (access(n4slist)) del(n4slist)
 if (access(n4llist)) del(n4llist)
 if (access(s7slist)) del(s7slist)
 if (access(s7llist)) del(s7llist)
 if (access(s9slist)) del(s9slist)
 if (access(s9llist)) del(s9llist)
 if (access(s11slist)) del(s11slist)
 if (access(s11llist)) del(s11llist)
 if (access(l15slist)) del(l15slist)
 if (access(l15llist)) del(l15llist)
 if (access(l18slist)) del(l18slist)
 if (access(l18llist)) del(l18llist)
 if (access(l24slist)) del(l24slist)
 if (access(l24llist)) del(l24llist)

## read the input logfile
 if (access("filename.list")) del("filename.list",ver-)
 print("! grep -v '#' "//irclog//" | awk '{print $1}' > filename.list") | cl

## make lists
 list0 = "filename.list"
 while (fscan(list0,fname) != EOF) {
    fname = fname//".fits"
    hselect(fname,"EXPID","yes") | scan(expid)
    hselect(fname,"FILTER","yes") | scan(band)
    if (expid == 1) {
       if (band == "N2") lname=n2slist
       if (band == "N3") lname=n3slist
       if (band == "N4") lname=n4slist
       if (band == "S7") lname=s7slist
       if (band == "S9W") lname=s9slist
       if (band == "S11") lname=s11slist
       if (band == "L15") lname=l15slist
       if (band == "L18W") lname=l18slist
       if (band == "L24") lname=l24slist
    } else {
       if (band == "N2") lname=n2llist
       if (band == "N3") lname=n3llist
       if (band == "N4") lname=n4llist
       if (band == "S7") lname=s7llist
       if (band == "S9W") lname=s9llist
       if (band == "S11") lname=s11llist
       if (band == "L15") lname=l15llist
       if (band == "L18W") lname=l18llist
       if (band == "L24") lname=l24llist
    }
    print(fname, >> lname)
 }

## end of the script
end
