## maskall.cl -- To mask the dead/hot/bad pixels, slit area, saturated pixels
##  based on anomalous_pix.cl, saturation.cl, slit_mask.cl created by Y. Ita
## created: F. Egusa, 2010/10/13
## modified: 2010/12/28 (F. Egusa), mask the left 4 pix in short frames
## 2014/03/03 (F. Egusa) - add 'ndmask','ndhot','pllog' options
## 2014/04/24 (F. Egusa) - add # of saturated pixels to pllog

procedure maskall (ircconst, logfile, prefixs, blankval, deltemp, verbose,ndmask,ndhot,pllog)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of mkirclog"}
string prefixs  {"fCcDlnw", prompt="prefix string"}
real   blankval {-9999.9,max=-1000., prompt="blank value"}
bool   deltemp = no {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
bool   ndmask = yes {prompt="Mask hot pixels in neighbor dark?"}
real   ndhot    {500.,prompt="Lowest value for hot pixels in neighbor dark"}
string pllog {'ircpipeline.log',prompt='log file for pipeline processes'}

struct *list0

begin

 string irc_const, irclog,flog
 real blank
 string prefix
 bool verb, deltmp, nmask
 real nhot

 string fname, outname
 string libpath
 string maskfile
 string nmaska, smaska, lmaska, nmasks, smasks, lmasks
 string detector, aot
 real n_fullwell, s_fullwell, l_fullwell
 real n_shrt, n_long, n_aot05, n_aot0c, m_shrt, m_long
 real n_thresh, s_thresh, l_thresh, n_aot05_th, n_aot0c_th
 int expid
 string refname, exprname
 real dmax,ghost
 string nds,ndl
 int npix,npixS,npixL,nfits
 string filter,bname[9]
 int i,bindx,npixsat[9],nframe[9],npix1,npix2

 print ("\n")
 print ("### MASK_ALL ###\n")


## get query parameters
 irc_const = ircconst
 irclog = logfile
 blank = blankval
 deltmp = deltemp
 verb = verbose
 prefix = prefixs
 nmask=ndmask
 nhot=ndhot
 flog=pllog

## set default & initial values
 libpath = osfn ("irclib$")
 ghost=10000. # alert level for ghost in MIR-S
 nds='ndarkS.d0n11.fits'
 ndl='ndarkL.d0n11.fits'
 nfits=0
 bname[1]='N2'
 bname[2]='N3'
 bname[3]='N4'
 bname[4]='S7'
 bname[5]='S9W'
 bname[6]='S11'
 bname[7]='L15'
 bname[8]='L18W'
 bname[9]='L24'
 for (i=1;i<=9;i+=1) {
    npixsat[i]=0
    nframe[i]=0
 }

## Read irc constants
 irc_const = libpath//irc_const
## parameters for anomalous pixel masking
## Mask file name
 printf("! grep nir_anomalous  %s\n", irc_const) | cl | scan(text, nmaska)
 printf("! grep mirs_anomalous %s\n", irc_const) | cl | scan(text, smaska)
 printf("! grep mirl_anomalous %s\n", irc_const) | cl | scan(text, lmaska)
## parameters for saturation correction
## full well [ADU]
 printf("! grep fullwell_nir   %s\n", irc_const) | cl | scan(text, n_fullwell)
 printf("! grep fullwell_mirs  %s\n", irc_const) | cl | scan(text, s_fullwell)
 printf("! grep fullwell_mirl  %s\n", irc_const) | cl | scan(text, l_fullwell)
## exposure time [sec]
 printf("! grep nir_short      %s\n", irc_const) | cl | scan(text, n_shrt)
 printf("! grep nir_long       %s\n", irc_const) | cl | scan(text, n_long)
 printf("! grep nir_aot05_long %s\n", irc_const) | cl | scan(text, n_aot05)
 printf("! grep nir_aot0c_long %s\n", irc_const) | cl | scan(text, n_aot0c)
 printf("! grep mir_short      %s\n", irc_const) | cl | scan(text, m_shrt)
 printf("! grep mir_long       %s\n", irc_const) | cl | scan(text, m_long)
## threshold for saturation (after ircnorm, scale by the ratio of exposure time)
 n_thresh   = n_fullwell * n_shrt / n_long
 n_aot05_th = n_fullwell * n_shrt / n_aot05
 n_aot0c_th = n_fullwell * n_shrt / n_aot0c
 s_thresh   = s_fullwell * m_shrt / m_long 
 l_thresh   = l_fullwell * m_shrt / m_long 
 if (access("nir.expr")  ) delete("nir.expr", ver-)   
 if (access("aot05.expr")) delete("aot05.expr", ver-) 
 if (access("aot0c.expr")) delete("aot0c.expr", ver-) 
 if (access("mirs.expr") ) delete("mirs.expr", ver-)  
 if (access("mirl.expr") ) delete("mirl.expr", ver-)  
 printf("(I > 4)&&(a > %f) ? %f : b\n", n_thresh,blank, > "nir.expr" )
 printf("(I > 4)&&(a > %f) ? %f : b\n", n_aot05_th,blank, > "aot05.expr" )
 printf("(I > 4)&&(a > %f) ? %f : b\n", n_aot0c_th,blank, > "aot0c.expr" )
 printf("(I > 4)&&(a > %f) ? %f : b\n", s_thresh,blank,   > "mirs.expr")
 printf("(I > 4)&&(a > %f) ? %f : b\n", l_thresh,blank,   > "mirl.expr")
## parameters for slit mask
## File name
 printf("! grep slit_mask_nir  %s\n", irc_const) | cl | scan(text, nmasks)
 printf("! grep slit_mask_mirs %s\n", irc_const) | cl | scan(text, smasks)
 printf("! grep slit_mask_mirl %s\n", irc_const) | cl | scan(text, lmasks)


## make input file list
 print ("Making the input file list...\n")
 if (access("filename.list")) delete("filename.list", ver-)
 print("!cat "//irclog//" | awk '{print $1}' | grep -v '#' > filename.list") | cl

## Masking
 print("Masking saturated pixels, bad/hot pixels, and slit area...\n")
 list0 = "filename.list"
 while (fscan(list0, fname) != EOF) {
    fname = prefix//fname//".fits"
    hselect(fname, fields="AOT",      expr="yes") | scan(aot)
    hselect(fname, fields="EXPID",    expr="yes") | scan(expid)
    hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
    hselect(fname, fields="FILTER", expr="yes") | scan(filter)
    for (i=1;i<=9;i+=1) {
       if (bname[i]==filter) bindx=i
    }
    outname = "m"//fname
    if (access(outname)) imdel(outname, yes, verify=no, default_acti=yes)

    ## saturation correction 
    ## (mask long frames where short frames exceed the limit)
    if (access("tmp1.fits")) imdel("tmp1.fits")
    if (expid == 1) {
       imcopy(fname,"tmp1.fits",ver-)
    } else {
       refname = "m"//substr(fname,1,strlen(fname)-6)//"1.fits"
       if (aot == "IRC05") {
	  exprname = "aot05.expr"
       } else if (aot == "IRC0C") {
	  exprname = "aot0c.expr"
       } else {
          if (detector == "NIR") exprname = "nir.expr"
	  if (detector == "MIRS") exprname = "mirs.expr"
	  if (detector == "MIRL") exprname = "mirl.expr"
       }
       if (access(refname)) {
          ## mask and count masked pixels
	  imexpr ("@"//exprname, "tmp1.fits", refname, fname, " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="double", outtype="real", refim="b", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=no, exprdb="none", lastout=outname)
	  imstat(fname,fields='npix',format-,low=blank-.1,upp=blank+.1) | scan(npix1)
	  imstat('tmp1.fits',fields='npix',format-,low=blank-.1,upp=blank+.1) | scan(npix2)
	  npixsat[bindx]=npixsat[bindx]+npix2-npix1
	  nframe[bindx]=nframe[bindx]+1
       } else {
	  printf("No reference short image for %s. Just copying it.\n", fname)
	  imcopy(fname,"tmp1.fits",ver-)
       }
    }

    ## alert for ghost in MIR-S
    if (expid > 1 && detector == 'MIRS') {
       imstat(fname,fields='max',format-) | scan(dmax)
       if (dmax > ghost) {
          printf('### Warning: Bright (>%.0f) source(s) found in %s. Be aware of the ghost!\n',ghost,fname)
	  nfits=nfits+1
       }
    }

    if (deltmp) {
       if (access(fname)) imdel(fname)
    }

    ## anomalous pix masking
    if (access("tmp2.fits")) imdel("tmp2.fits")
    if (detector == "NIR") { # NIR
       maskfile = libpath//"anomalous_pix/"//nmaska
    } else if (detector == "MIRS") { # MIRS
       maskfile = libpath//"anomalous_pix/"//smaska
    } else if (detector == "MIRL") { # MIRL
       maskfile = libpath//"anomalous_pix/"//lmaska
    }
    imarith("tmp1.fits", "/", maskfile, "tmp2.fits", title="", divzero=blank, hparams="", pixtype="real", calctype="real", verbose=verb, noact=no)

    ## hot pixel masking from neighbor dark (only for MIR long)
    if (! nmask) goto skip
    if (expid == 1 || detector == 'NIR') goto skip
    if (detector == 'MIRS') maskfile='../dark/'//nds
    if (detector == 'MIRL') maskfile='../dark/'//ndl
    if (access('tmp2.1.fits')) imdel('tmp2.1.fits')
    imexpr('b>=c?d:a','tmp2.1.fits','tmp2.fits',maskfile,nhot,blank,"","","","","","","","","","","","","","","","","","","","","","",intype='real',outtype='real',verb-)
    imstat(maskfile,fields='npix',lower=nhot,format-) | scan(npix)
    if (detector == 'MIRS') npixS=npix
    if (detector == 'MIRL') npixL=npix
    hedit('tmp2.1.fits','NHOTPIX',npix,add+,delete-,ver-,show-,update+)
    ! mv -f tmp2.1.fits tmp2.fits
    skip:

    ## slit area masking
    if (detector == "NIR") { # NIR
       maskfile = libpath//"slit_mask/"//nmasks
    } else if (detector == "MIRS") { # MIRS
       maskfile = libpath//"slit_mask/"//smasks
    } else if (detector == "MIRL") { # MIRL
       maskfile = libpath//"slit_mask/"//lmasks
    }
    if (access("tmp.mask.fits")) imdel("tmp.mask.fits")
    imexpr("-(a-b)/b","tmp.mask.fits",maskfile,blank,"","","","","","","","","","","","","","","","","","","","","","","","",outtype="int",verb=no)
    imarith("tmp2.fits","/","tmp.mask.fits",outname,title="",divzero=blank,hparams="",pixtype="real",calctype="real",verbose=verb,noact=no)

    ## mask the left 4 pix in short frames
    if (expid == 1) {
       if (access("tmp3.fits")) imdel("tmp3.fits")
       imrename(outname,"tmp3.fits",verb-)
       imexpr("I>4 ? a : b",outname,"tmp3.fits",blank,"","","","","","","","","","","","","","","","","","","","","","","","",intype='real',outtype="real",verb-)
    }

    hedit(outname,"BLANK",blank,ver-,update+,add+,show-,del-)

 }

## alert for ghost in pllog
 if (nfits > 0) printf('### Warning: Bright (>%.0f) source(s) found in %d MIR-S frames. Be aware of the ghost!\n',ghost,nfits, >> flog)

 for (i=1;i<=9;i+=1) {
    if (npixsat[i]>0) printf('### Info: total number of saturated pixels for %d %s frames = %d\n',nframe[i],bname[i],npixsat[i], >> flog)
 }

 if (nmask) {
    printf('### Info: %d pixels masked for MIR-S from neighbor dark\n',npixS, >> flog)
    printf('### Info: %d pixels masked for MIR-L from neighbor dark\n',npixL, >> flog)
 }


## cleaning
 if (access("filename.list")) delete("filename.list", ver-)

 print ("\n### MASK_ALL finished!! ###\n")

end
