# scatt_light.cl -- To subtract scattering light pattern
# Created: Yoshifusa Ita, 02-May-07

procedure scatt_light (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"a", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
struct *list0

begin

 string fname, outname, libpath, irc_const, prefix
 bool verb, deltmp
 string text, filter, detector, area
# string n2scatt, n3scatt, n4scatt
 string s7scatt, s9wscatt, s11scatt
# string l15scatt, l18wscatt, l24scatt
 string scattfile
 int npix
 real mean, median, modee, sigma


 print ("\n")
 print ("### SCATT_LIGHT ###\n")


# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 prefix = prefixs
 verb = verbose
 deltmp = deltemp


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Read irc constants
 irc_const = libpath//irc_const
 # Pattern file
# printf("! grep N2scatt   %s\n", irc_const) | cl | scan(text, n2scatt)
# printf("! grep N3scatt   %s\n", irc_const) | cl | scan(text, n3scatt)
# printf("! grep N4scatt   %s\n", irc_const) | cl | scan(text, n4scatt)
 printf("! grep S7scatt   %s\n", irc_const) | cl | scan(text, s7scatt)
 printf("! grep S9Wscatt  %s\n", irc_const) | cl | scan(text, s9wscatt)
 printf("! grep S11scatt  %s\n", irc_const) | cl | scan(text, s11scatt)
# printf("! grep L15scatt  %s\n", irc_const) | cl | scan(text, l15scatt)
# printf("! grep L18Wscatt %s\n", irc_const) | cl | scan(text, l18wscatt)
# printf("! grep L24scatt  %s\n", irc_const) | cl | scan(text, l24scatt)


# Subtracting scattering light pattern
 print ("Subtracting scattering light pattern...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
	fname = prefix//fname//".fits"
	outname = "c"//fname
        if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	# $B%X%C%@$rFI$s$G!"(BFILTER$B$H(BDETECTOR$B$rD4$Y$k(B
        hselect(fname, fields="FILTER", expr="yes") | scan(filter)
        hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
	# $B:#$O(BMIRS$B$7$+:86a%9%Z%7%c%k%U%!%$%k$,L5$$$N$G(BMIRS$B$@$C$?$iH/F0(B
	if(detector == "MIRS"){ 
#		# DETECTOR$BKh$K(Bimaging$BNN0h$rDj5A$9$k(B
#	        if(detector == "NIR"){ # NIR
#		        area = "[1:412,1:390]"
#		}else if(detector == "MIRS"){
#	                area = "[40:256,1:256]"
#		}else if(detector == "MIRL"){
#	                area = "[1:220,82:200]"
#		}else{
#			print("Detector name is wrong!!\n")
#			bye
#	        }
		area = "[40:256,1:256]"
		# imaging$BNN0h$N(Bstat$B$r$9$k(B
		imstat(fname//area, fields="npix,mean,midpt,mode,stddev", lower=0, upper=10000, lsigma=3, usigma=3, nclip=100, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
		if(filter == "S7"){
			scattfile = libpath//"scatt/"//s7scatt
		}else if(filter == "S9W"){
			scattfile = libpath//"scatt/"//s9wscatt
		}else if(filter == "S11"){
			scattfile = libpath//"scatt/"//s11scatt
		}else{
			print("Filter name is wrong!!\n")
			bye
		}
		# $B%Q%?!<%s%U%!%$%k$K(Bsky$B$N(Bmedian$BCM$r$+$1$?$b$N$r$5$C$T$/!#(B
		imexpr ("(a - b*c)", outname, fname, scattfile, median, " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="real", outtype="real", refim="auto", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=verb, exprdb="none", lastout=outname)
	}else{ # $B$=$l0J30$O$=$N$^$^%3%T!<(B
		imcopy (fname, outname, verbose=verb)
	}
        if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }

# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### SCATT_LIGHT finished!! ###\n")

end
