# wraparound.cl -- To correct wraparouund pixels in long exposure frames.
# Created: Yoshifusa Ita, 05-Jun-04
## modified: F. Egusa, 2010/10/13  to read the parameter 'logfile' properly

procedure wraparound (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="Output of the mkirclog"}
string prefixs  {"s", prompt="prefix string"}
bool   deltemp = no {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string fname, outname
 string irc_const, libpath, irclog
 real n_wrap, s_wrap, l_wrap
 string detector
 string prefix
 bool verb, deltmp

 print ("\n")
 print ("### WRAPAROUND ###\n")

# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 irclog = logfile
 prefix = prefixs
 deltmp = deltemp
 verb = verbose


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
# ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list
 print("!cat "//irclog//" | awk '{print $1}' | grep -v '#' > filename.list") | cl


# Read irc constants
 irc_const = libpath//irc_const
 # Wraparound threshold [ADU]
 printf("! grep wraparound_nir  %s\n", irc_const) | cl | scan(text, n_wrap)
 printf("! grep wraparound_mirs %s\n", irc_const) | cl | scan(text, s_wrap)
 printf("! grep wraparound_mirl %s\n", irc_const) | cl | scan(text, l_wrap)

 if( access("nir.expr")  ) { delete("nir.expr", ver-)  }
 if( access("mirs.expr") ) { delete("mirs.expr", ver-) }
 if( access("mirl.expr") ) { delete("mirl.expr", ver-) }
 printf("(a < %f) ? (a+2**16) : a\n", n_wrap, > "nir.expr" )
 printf("(a < %f) ? (a+2**16) : a\n", s_wrap, > "mirs.expr")
 printf("(a < %f) ? (a+2**16) : a\n", l_wrap, > "mirl.expr")

# Correction
 print ("Correcting wraparound...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname, detector) !=EOF){
	fname = prefix//fname//".fits"
        hselect (fname, fields="DETECTOR", expr="yes") | scan(detector)
 	outname = "w"//fname
        if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	if(detector == "NIR"){ # NIR
		imexpr("@nir.expr", outname, fname, " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="int", outtype="auto", refim="auto", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=no, exprdb="none", lastout=outname)
	}else if(detector == "MIRS"){ # MIRS
		imexpr("@mirs.expr", outname, fname, " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="int", outtype="auto", refim="auto", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=no, exprdb="none", lastout=outname)
	}else if(detector == "MIRL"){ # MIRL
		imexpr("@mirl.expr", outname, fname, " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="int", outtype="auto", refim="auto", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=no, exprdb="none", lastout=outname)
	}
 	if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }

# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }
 if( access("nir.expr")      ){ delete("nir.expr", ver-)      }
 if( access("mirs.expr")     ){ delete("mirs.expr", ver-)     }
 if( access("mirl.expr")     ){ delete("mirl.expr", ver-)     }

 print ("### WRAPAROUND finished!! ###\n")

end
