## CL script to add mask created by 'copy_MIRmask.cl' to MIR long exposures
## This may be useful for masking pixels suffering the memory effect.
## Since this is designed to add the mask to m*F*.fits, 
## run pipeline2 with deltemp=no option or maskall beforehand.
## Also, 'MIR[S/L]mask.fits' should be in the current working directory.
## Files before adding the mask are renamed to mm*F*.fits 
## and new m*F*.fits are created after adding the mask.

## Created: 2014/10/30 (F. Egusa)

procedure add_MIRmask(channel)

string channel {prompt='channel to add a copy of mask: S or L'}
struct *list1

begin

 string chname
 string logfile,fname,obj,filter,aot
 real ra,dec
 int npix,expid,nfile
 real blank
 string mfname,fmask


## get query parameter
 chname=channel
 if ((chname != 'S')&&(chname != 'L')) {
    print('## ERROR: channel should be S or L!')
    bye
 }


## set default parameters
 logfile='irclog'
 fmask='MIR'//chname//'mask.fits'
 if (!access(fmask)) {
    print('## ERROR: '//fmask//' not found!')
    bye
 }
 nfile=0


## read logfile
 if (!access(logfile)) {
    print('## ERROR: '//logfile//' not found!')
    bye
 }
 if (access('tmp.list')) del('tmp.list')
 print('! grep -v # '//logfile//' > tmp.list') | cl
 list1='tmp.list'
 while (fscan(list1,fname,obj,npix,filter,ra,dec,aot,expid) != EOF) {
    if (substr(filter,1,1)!=chname) goto nextfile
    if (expid==1) goto nextfile
    print('! ls m*'//fname//'.fits') | cl | scan(mfname)
    if (!access(mfname)) goto nextfile
    hselect(mfname,fields='blank',exp=yes) | scan(blank)

    ## copy masked area
    if (access('m'//mfname)) imdel('m'//mfname)
    imrename(mfname,'m'//mfname,ver-)
    imexpr('(abs(a-b)<0.01)||(abs(c-b)<0.01)?b:a',mfname,'m'//mfname,blank,fmask,"","","","","","","","","","","","","","","","","","","","","","","",intype='real',outtype='real',ver-)

    nfile=nfile+1
    nextfile:
 }

 print('## mask added to '//nfile//' file(s)')

end
