## coadd2.cl -- to coadd images in the input list using xregister
## Files in the input list need to be consistent in
##  1. observing band, 2. exposure time, 3. blank value in the header
## This does NOT support a rotation of images!

## Example: irc,> coadd2 pair0001_L15.list_long emfCcDlnw yes

## created:  2010/11/15  Fumi Egusa
## modified: 2010/11/18 (F. Egusa), add to correct WCS headers
##           2010/12/28 (F. Egusa), mask handling updated
##           2011/01/25 (F. Egusa), 'SHIFTTYP'='XREGISTER' for shifted images
##	     2011/03/02 (F. Egusa), parameter updated for double-sized images

procedure coadd2(inputlist,prefixs,adj_sky)

string inputlist {prompt="a list of files to be coadded"}
string prefixs {"emfCcDlnw",prompt="prefix for the input images"}
bool adj_sky = yes {prompt="Adjust sky levels?"}
bool double = no {prompt="Double sized images?"}

struct *list0

begin

 string flist, prefix
 bool adjsky, dbl
 string lname, fname, band1, band, detec, file1, xregion
 int n, expid1, expid, box, ncombine
 real blank1, blank
 string outname, obj, outfits
 int maxitr
 string outlist
 real mean,median,modee,sigma,sigrej,all_median
 real dx,dy,dr
 real cpix1,cpix2,ltm11,ltm12,ltm21,ltm22,ltv1,ltv2,pfov
 real crval1,crval2,angle,crpix1,crpix2,cd11,cd12,cd21,cd22
 int na1,na2,pad,col,line
 real xofs,yofs,xout,yout
 real thblank

## get query parameters
 flist=inputlist
 prefix=prefixs
 adjsky=adj_sky
 dbl=double

## default parameters
 box=31 #box size for xregister
 maxitr=10 #max number of iteration for adjust sky
 sigrej=3.0 #rejection criterion for sigma clipping
 thblank=-0.1

## initialize parameters
 unlearn xregister
 unlearn imlintran
 unlearn combine

## check the input list
 n=0
 list0=flist
 while (fscan(list0,fname) != EOF) {
    n=n+1
    fname=prefix//fname//".fits"
    hselect(fname,"FILTER",yes) | scan(band)
    hselect(fname,"EXPID",yes) | scan(expid)
    hselect(fname,"BLANK",yes) | scan(blank)
    if (expid > 1) expid=2
    if (n == 1) {
       band1=band
       expid1=expid
       blank1=blank
       hselect(fname,"DETECTOR",yes) | scan(detec)
       file1=fname
       hselect(fname,"OBJECT",yes) | scan(obj)
       hselect(fname,"naxis1,naxis2",yes) | scan(na1,na2)
    } else {
       if (band != band1) {
      	  print("### ERROR: input files are not consistent in observing band!")
      	  bye
       }
       if (expid != expid1) {
       	  print("### ERROR: input files are not consistent in exposure time!")
      	  bye
       }
       if (blank != blank1) {
       	  print("### ERROR: input files are not consistent in blank value!")
      	  bye
       }
    }
 }
 print("### Input data summary ###")
 if (expid == 1) {
    print("###  Band: "//band//" short, "//n//" file(s)")
 } else {
    print("###  Band: "//band//" long, "//n//" file(s)")
 }
 print("")

## set region for xregister
 if (detec == "NIR") xregion="[173:300,135:262]"
 if (detec == "MIRS") xregion="[65:192,65:192]"
 if (detec == "MIRL") xregion="[99:158,99:158]"

## for doubled images
 if (dbl) {
    if (detec == "MIRS") xregion="[129:384,129:384]"
    if (detec == "MIRL") xregion="[197:316,197:316]"
    box=61
 }

## read files & calculate each shift
 if (access("xreg.shift")) del("xreg.shift")
 if (access("combine.list")) del("combine.list")
 list0=flist
 while (fscan(list0,fname) != EOF) {
    fname=prefix//fname//".fits"
    outname="R"//fname
    if (access(outname)) imdel(outname)
    if (access("tmp.dat")) del("tmp.dat")
    xregister(fname,file1,xregion,"tmp.dat",output=outname,databasefmt-,xwin=box,ywin=box,boundary="constant",constant=blank,interp="drizzle[0.5]",ver-)
    ccdhedit(outname,param="SHIFTTYP",value="XREGISTER",type="string")
    print("! cat tmp.dat | awk '{print $2, $3}' >> xreg.shift") | cl
    print(fname, >> "combine.list")
 }

## adjust sky if requested 
## following adjust_sky.cl but without skyarea, rejsky, sub_medsky options
 if (adjsky) {
    outlist="sky"//flist
    if (access(outlist)) del(outlist)
    if (access("tmp.list")) del("tmp.list")
    ! cat combine.list | awk '{print "R"$1}' > tmp.list
    imstat("@tmp.list",fields="im,mean,midpt,mode,stddev",lower=blank+0.1,format-,nclip=maxitr,lsigma=sigrej,usigma=sigrej, >> outlist)
    print("! sort -n -k 3 "//outlist//" | awk '{y[NR]=$2;x[NR]=$3;z[NR]=$4;u[NR]=$5}END{n=int((NR+1)/2);if(NR%2==1){print x[n],u[n]}else{print (x[n]+x[n+1])/2, (u[n]+u[n+1])/2}}'") | cl | scan(all_median)
#    print("! sort -n -k 3 "//outlist//" | awk '{y[NR]=$2;x[NR]=$3;z[NR]=$4;u[NR]=$5}END{n=int((NR+1)/2);if(NR%2==1){print x[n],u[n]}else{print (x[n]+x[n+1])/2, (u[n]+u[n+1])/2}}'") | cl # for check

    if (access("tmp.list")) del("tmp.list")
    list0=outlist
    while (fscan(list0,fname,mean,median,modee,sigma) != EOF) {
       fname=substr(fname,2,strlen(fname))
       outname="A"//fname
       if (access(outname)) imdel(outname)
       imexpr("abs(a-d)>0.1 ? a-b+c : d",outname,fname,median,all_median,blank,"","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-) 
       print(outname, >> "tmp.list")
    }
    ! mv -f tmp.list combine.list
 }


## pad blank borders according to calculated shifts
 pad=0
 list0="xreg.shift"
 while (fscan(list0,xofs,yofs) != EOF) {
    pad=max(pad,int(abs(xofs)),int(abs(yofs)))
 }
 pad=pad+1
 col=na1+pad*2
 line=na2+pad*2
# printf("debug: %d %d %d\n",pad,col,line)

 if (access("tmp.list")) del("tmp.list")
 list0="combine.list"
 while (fscan(list0,fname) != EOF) {
    outname="S"//fname
    print("! paste combine.list xreg.shift | grep "//fname//" | awk '{print $2, $3}'") | cl | scan(xofs,yofs)
    xout=1+pad+xofs
    yout=1+pad+yofs
    if (access("drizzle.fits")) imdel("drizzle.fits")
#    if (access("nearest.fits")) imdel("nearest.fits")
    imlintran(fname,"drizzle.fits",0.,0.,1.,1.,interp="drizzle[0.5]",boundary="constant",const=blank,fluxcon-,xin=1,yin=1,xout=xout,yout=yout,ncol=col,nlin=line,verb-)
#    imlintran(fname,"nearest.fits",0.,0.,1.,1.,interp="nearest",boundary="constant",const=blank,fluxcon-,xin=1,yin=1,xout=xout,yout=yout,ncol=col,nlin=line,verb-)

    if (access("blank.fits")) imdel("blank.fits")
    if (access("blank.dri.fits")) imdel("blank.dri.fits")
    imexpr("abs(a-b)<0.1 ? b : 0.","blank.fits",fname,blank,"","","","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real")
    imlintran("blank.fits","blank.dri.fits",0.,0.,1.,1.,interp="drizzle[0.5]",boundary="constant",const=blank,fluxcon-,xin=1,yin=1,xout=xout,yout=yout,ncol=col,nlin=line,verb-)

    if (access(outname)) imdel(outname)
#    imexpr("abs(b-d)<0.1 || abs(a-d)<0.1 || abs(a-b)>=c ? d : a",outname,"drizzle.fits","nearest.fits",1000.,blank,"","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real")
    imexpr("b>d ? a : c",outname,"drizzle.fits","blank.dri.fits",blank,thblank,"","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real")
    print(outname, >> "tmp.list")
 }
 ! mv -f tmp.list combine.list


## combine shifted images 
 if (expid == 1) {
    outfits=obj//"_"//band//"_short.fits"
 } else {
    outfits=obj//"_"//band//"_long.fits"
 }
 if (access(outfits)) imdel(outfits)
# combine("@combine.list",outfits,combine="median",reject="sigclip",lthreshold=blank+0.1,blank=blank,offsets="xreg.shift") 
 combine("@combine.list",outfits,combine="median",reject="sigclip",lthreshold=blank+0.1,blank=blank) 

## add header information
## name & number of combined images
 print("! wc combine.list") | cl | scan(ncombine)
 ccdhedit(outfits,param="NCOMBINE",value=ncombine,type="integer")
 ccdhedit(outfits,param="SHIFTTYP",value="xregister",type="string")
 print(ncombine//" file(s) combined to make "//outfits)
 n=0
 list0="combine.list"
 while (fscan(list0,fname) != EOF) {
    n=n+1
    printf("IMCMB%03d\n",n) | scan(outname)
    ccdhedit(outfits,param=outname,value=fname,type="string")
 }

## WCS information (added 2010/11/18 following irc_stack.cl)
 # initialize parameters
 ltm11=0.
 ltm12=0.
 ltm21=0.
 ltm22=0.
 ltv1=0.
 ltv2=0.

 # read parameters
 hselect (outfits, fields="CPIX1",  expr="yes") | scan(cpix1)
 hselect (outfits, fields="CPIX2",  expr="yes") | scan(cpix2)
 hselect (outfits, fields="LTM1_1", expr="yes") | scan(ltm11)
 hselect (outfits, fields="LTM1_2", expr="yes") | scan(ltm12)
 hselect (outfits, fields="LTM2_1", expr="yes") | scan(ltm21)
 hselect (outfits, fields="LTM2_2", expr="yes") | scan(ltm22)
 hselect (outfits, fields="LTV1",   expr="yes") | scan(ltv1)
 hselect (outfits, fields="LTV2",   expr="yes") | scan(ltv2)
 if (detec == "NIR") {
    hselect (outfits, fields="RA-N",  expr="yes") | scan(crval1)
    hselect (outfits, fields="DEC-N", expr="yes") | scan(crval2)
    hselect (outfits, fields="PA-N",  expr="yes") | scan(angle)
    pfov = 1.446/3600.
 } else if (detec == "MIRS") {
    hselect (outfits, fields="RA-S",  expr="yes") | scan(crval1)
    hselect (outfits, fields="DEC-S", expr="yes") | scan(crval2)
    hselect (outfits, fields="PA-S",  expr="yes") | scan(angle)
    pfov = 2.340/3600.
    if (double) pfov=pfov/2.
 } else if (detec == "MIRL") {
    hselect (outfits, fields="RA-L",  expr="yes") | scan(crval1)
    hselect (outfits, fields="DEC-L", expr="yes") | scan(crval2)
    hselect (outfits, fields="PA-L",  expr="yes") | scan(angle)
    pfov = 2.384/3600.
    if (double) pfov=pfov/2.
 }

 # derive correct WCS information
 crpix1 = ltm11*cpix1 + ltm12*cpix2 + ltv1
 crpix2 = ltm21*cpix1 + ltm22*cpix2 + ltv2
 if (detec == "MIRL") crpix1 = crpix1 - 14
 cd11 = -pfov *  cos(angle*PI/180.)
 cd12 = -pfov * -sin(angle*PI/180.)
 cd21 =  pfov *  sin(angle*PI/180.)
 cd22 =  pfov *  cos(angle*PI/180.)

 # delete unnecessary header values
 hedit (outfits, "CPIX1",    "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "CPIX2",    "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "WCSDIM"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "LTM3_3"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "WAXMAP01", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "WAT0_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "WAT1_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "WAT2_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
 hedit (outfits, "WAT3_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)

 # update header
 ccdhedit (outfits, paramete="WCSROOT",  value="AOCS",         type="string")
 ccdhedit (outfits, paramete="RADECSYS", value="FK5",          type="string")
 ccdhedit (outfits, paramete="EQUINOX",  value=2000.,          type="real")
 ccdhedit (outfits, paramete="WCSDIM",   value=2,              type="integer")
 ccdhedit (outfits, paramete="CTYPE1",   value="RA---TAN",     type="string")
 ccdhedit (outfits, paramete="CTYPE2",   value="DEC--TAN",     type="string")
 ccdhedit (outfits, paramete="CRVAL1",   value=crval1,         type="real")
 ccdhedit (outfits, paramete="CRVAL2",   value=crval2,         type="real")
 ccdhedit (outfits, paramete="CRPIX1",   value=crpix1,         type="real")
 ccdhedit (outfits, paramete="CRPIX2",   value=crpix2,         type="real")
 ccdhedit (outfits, paramete="CD1_1",    value=cd11,           type="real")
 ccdhedit (outfits, paramete="CD1_2",    value=cd12,           type="real")
 ccdhedit (outfits, paramete="CD2_1",    value=cd21,           type="real")
 ccdhedit (outfits, paramete="CD2_2",    value=cd22,           type="real")
 ccdhedit (outfits, paramete="WAT0_001", value="system=image", type="string")
 ccdhedit (outfits, paramete="WAT1_001", value="wtype=tan axtype=ra", type="string")
 ccdhedit (outfits, paramete="WAT2_001", value="wtype=tan axtype=dec",type="string")


## print terminal if shifts are too small
 n=0
 list0="xreg.shift"
 while (fscan(list0,dx,dy) != EOF) {
    dr=sqrt(dx**2.+dy**2.)
    if (dr < 1.) n=n+1
 }
 print(" ! "//n//" files with shift < 1 pixel !\n")


## move the output file to stacked_IM/ and save offset info
 if (!access("stacked_IM")) print("! mkdir stacked_IM") | cl
 print("! mv -f "//outfits//" stacked_IM/") | cl

 if (access(flist//".shift_xreg")) del(flist//".shift_xreg")
 print("! paste combine.list xreg.shift > "//flist//".shift_xreg") | cl
 print("### List of file names and shifts: "//flist//".shift_xreg")

end

