# coaddLusingS.cl -- To coadd L images with few stars by using S shift value
# Created: Yoshifusa Ita, 20-Jun-06
## modified: 2010/11/16 (F. Egusa)
##           2011/01/25 (F. Egusa), mask handling updated & 'SHIFTTYP'='LusingS' for shifted images
## 2014/06/19 (F. Egusa) - add 'nb','double','tolerance','wipestar' options
## 2014/11/05 (F. Egusa) - handle different sizes of MIR-S and -L
## 2014/12/16 (F. Egusa) - copy shift values to _forL.shift


procedure coaddLusingS (s_list, com_mode, com_area, sky_area, prefixs, verbose)
string  mode="al"

string s_list       {"pair0004_S11.list_long", prompt="Name of shift reference list"}
string com_mode     {"median", prompt="combine mode: average/median"}
int    com_area     {2,min=1,max=2, prompt="stack area: 1:common area 2:whole area"}
int    sky_area     {1,min=1,max=2, prompt="sky matching area: 1:common area 2:whole area"}
string prefixs      {"SemfCcDlnw", prompt="prefix string"}
bool   verbose = no {prompt="Print verbose progress messages?"}

string rejection    {"sigclip", prompt="rej in coadd:minmax|ccdclip|crreject|sigclip|avsigclip|pclip|none"}
real   sig_rej      {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
int    max_itr      {10,min=1,max=10, prompt="Maximum number of iterations"}
bool   wcs = no     {prompt="Try to compute wcs and write it in the header?"}
bool   rej_sky = yes {prompt="Remove image(s) with outlier sky level?"}
bool   submedsky = no {prompt="Subtract median filtered sky in adjust_sky?"}
real   blankval  {-9999.9,max=-1000., prompt="blank value"}
int    nb         {128,prompt='number of pixels of the border'}
bool   double = yes {prompt="Double-sized image?"}
real   tolerance {1.5, min=0.1, max=10.0, prompt="The WCS matching tolerance in arcsec"}
real   wipestar = 0.0 {prompt="The searching radius in pixels for pre-selection of xyxymatch in putwcs (0.0: disable)"}


struct *list0

begin

 string slist, llist, rejtype, text, filter, objectname
 string commode, prefix, pcommand
 int    i, maxitr, comarea, skyarea, expid, long_short
 bool   verb, rejsky, setwcs, sub_medsky
 string sname, ssub, shiftdata, slink, input, output
 int smatched
 real   sigrej, bad_const
 real   crpix2, ltv2
 real thblank
 int nborder, nx, ny
 bool dpix
 real tole,wipe_stars
 string fname
 real xx,yy,angle
 int nstar

 print ("### COADD L using S ###\n")

## Get query parameters
 slist = s_list
 commode = com_mode
 comarea = com_area
 skyarea = sky_area
 prefix = prefixs
 verb = verbose
 rejtype = rejection
 sigrej = sig_rej
 maxitr = max_itr
 setwcs = wcs
 rejsky = rej_sky
 sub_medsky = submedsky
 bad_const = blankval
 nborder=nb
 dpix=double
 tole=tolerance
 wipe_stars = wipestar


## set default parameters
 expid = 2
 llist = slist//"_forL"
 thblank = -0.1


## make a list by reading S's list
 if( access("reference_S.list") ){ delete("reference_S.list", ver-) }
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"coaddLusingS.pl"
 printf("! %s %s.shift > reference_S.list \n", pcommand, slist) | cl


## read the list and start
 print ("\n### Shift and Rotate L images ###\n")
 if( access(llist) ){ delete(llist, ver-) }
 if( access(llist//".shift") ){ delete(llist//".shift", ver-) }
 i = 0
 list0 = "reference_S.list"
 while (fscan (list0, sname, ssub, smatched) != EOF) {
    if (smatched > 1) { # if matched
       input  = sname//"_L"//ssub
       output = "R"//input//".fits"
       if (access(output)) imdel(output, ver-) 
       shiftdata = sname//"_S"//ssub//".fits.shift"
       slink     = sname//"_L"//ssub//".fits.shift"
       if (access(slink)) delete(slink, ver-) 
       if (i==0) { #just copy for the first frame
	  ## added 2014/11/05 (FE) to match the S size
	  hselect(sname//'_S'//ssub//'.fits',fields="NAXIS1,NAXIS2",exp+) | scan(nx,ny)
          imcopy(input//'.fits[1:'//nx//',1:'//ny//']',output,verb-)
	  hselect(output, fields="FILTER", expr="yes") | scan(filter)
	  hselect(output, fields="EXPID", expr="yes") | scan(expid)
	  hselect(output, fields="OBJECT", expr="yes") | scan(objectname)
	  # commented out on 090824 from here --->
	  ## add 090420
          #hselect(output, fields="CRPIX2", expr="yes") | scan(crpix2)
	  #crpix2 = crpix2 - 128
          #hedit (output, "CRPIX2", crpix2, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
          #hselect(output, fields="CRPIX2L", expr="yes") | scan(ltv2)
	  #ltv2 = -1.0*ltv2 + 128
          #hedit (output, "LTV2", ltv2, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
	  # <----- to here 090824
       } else { #shift L images according to S images
          ## update 2010/11/16 (FE) use drizzle instead of linear
	  if (access("tmp1.fits")) imdel("tmp1.fits")
          geotran(input//".fits", "tmp1.fits", shiftdata, "record.dat", geometry="linear", xin=INDEF, yin=INDEF, xshift=INDEF, yshift=INDEF, xout=INDEF, yout=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1.0, yscale=1.0, ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., interpolant="drizzle[0.5]", boundary="constant", constant=bad_const, fluxconserve=yes, nxblock=2048, nyblock=2048, verbose=verb)

	  ## make blank fits (2011/01/25, FE)
	  if (access("blank.fits")) imdel("blank.fits")
	  if (access("blank.dri.fits")) imdel("blank.dri.fits")
    	  imexpr("abs(a-b)<0.1 ? b : 0.","blank.fits",input//".fits",bad_const,"","","","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real",intype='real')
          ## update 2014/11/04 (FE) to fluxcon+
	  geotran("blank.fits", "blank.dri.fits", shiftdata, "record.dat", geometry="linear", xin=INDEF, yin=INDEF, xshift=INDEF, yshift=INDEF, xout=INDEF, yout=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1.0, yscale=1.0, ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., interpolant="drizzle[0.5]", boundary="constant", constant=bad_const, fluxcon+, nxblock=2048, nyblock=2048, verbose=verb)

	  ## mask pixels according to transformed blank fits (2011/01/25, FE)
    	  imexpr("b>d ? a : c",output,"tmp1.fits","blank.dri.fits",bad_const,thblank,"","","","","","","","","","","","","","","","","","","","","","",ver-,outtype="real",intype='real')
	  ccdhedit(output,param="SHIFTTYP",value="LusingS",type="string")

	  printf("! ln -s %s %s\n", shiftdata, slink) | cl
	  # commented out on 090824 from here --->
	  # add 090420
          #hselect(output, fields="CRPIX2", expr="yes") | scan(crpix2)
	  #crpix2 = crpix2 - 128
          #hedit (output, "CRPIX2", crpix2, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
          #hselect(output, fields="CRPIX2L", expr="yes") | scan(ltv2)
	  #ltv2 = -1.0*ltv2 + 128
          #hedit (output, "LTV2", ltv2, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
	  # <----- to here 090824
       }
       printf("%s_L%s %s\n", sname, ssub, filter, >> llist)
       ## updated to copy shift values from MIR-S (2014/12/16, FE)
#       printf("%s.fits.coo.1 0 0 0 999\n", input, >> llist//".shift")
       print('! grep '//sname//'_S'//ssub//' '//slist//'.shift') | cl | scan(fname,xx,yy,angle,nstar)
       printf("%s.fits.coo.1 %.3f %.3f %.5f %d\n",input,xx,yy,angle,nstar, >> llist//'.shift')
    }
    i += 1
 }


## adjust sky levels
 print ("### Adjusting Sky ###\n")
 adjust_sky(prefixs=prefix, badconst=bad_const, list_name=llist, sky_area=skyarea, data_max=50000, sig_rej=sigrej, max_itr=maxitr, rej_sky=rejsky, submedsky=sub_medsky, verbose=verb,nb=nborder)


## preparation for coadd
 if (expid==1) {
    long_short = 1
 } else {
    long_short = 0
 }
 if (access("l.input")) delete("l.input", ver-) 
 printf("%s\n", llist, > "l.input" )
 if(!access("stacked_IM")) { print("! mkdir stacked_IM\n") | cl }


## coadding images
 printf ("### Coadding %s images ###\n", filter)
 ## no need to delete coadd.failure?
# if (access("coadd.failure")) delete("coadd.failure", ver-) 
 ## prefix should be blank since 'A' will be added in irc_stack
 irc_stack(list_name="l.input",prefixs="",lng_shrt=long_short,badconst=bad_const,sig_rej=sigrej,com_mode=commode,com_area=comarea,rejection=rejtype,rej_sky=rejsky,wcs=setwcs,verbose=verb,nb=nborder,double=dpix,tolerance=tole,wipestar=wipe_stars)
 if (long_short == 1) {
    output = "stacked_IM/"//objectname//"_"//filter//"_short.fits"
 } else {
    output = "stacked_IM/"//objectname//"_"//filter//"_long.fits"
 }
 ccdhedit(output,param="SHIFTTYP",value="LusingS",type="string")


## cleaning
 if (access("reference_S.list")) delete("reference_S.list", ver-) 
 if (access("l.input")) delete("l.input", ver-) 


## move files
 ! \mv sigma*.fits stacked_IM
 ! \mv pl*.pl stacked_IM
 if (! access("logs")){ print("! mkdir logs\n") | cl }
 ! \mv skypair* logs

end
