## CL script to copy mask area of MIR long exposures, which 
## should be useful for masking pixels suffering the memory effect.
## Since the mask is copied from m*F*.fits created by maskall in pipeline2, 
## run pipeline2 with deltemp=no option or maskall beforehand.
## Use 'add_MIRmask.cl' to add the mask created by this script.

## Created: 2014/10/30 (F. Egusa)

procedure copy_MIRmask(channel)

string channel {prompt='channel to make a copy of mask: S or L'}
struct *list1

begin

 string chname
 string logfile,fname,obj,filter,aot
 real ra,dec
 int npix,expid,nfile
 real blank
 string outf,mfname


## get query parameter
 chname=channel
 if ((chname != 'S')&&(chname != 'L')) {
    print('## ERROR: channel should be S or L!')
    bye
 }


## set default parameters
 logfile='irclog'
 outf='MIR'//chname//'mask.fits'
 if (access(outf)) imdel(outf)
 nfile=0


## read logfile
 if (!access(logfile)) {
    print('## ERROR: '//logfile//' not found!')
    bye
 }
 if (access('tmp.list')) del('tmp.list')
 print('! grep -v # '//logfile//' > tmp.list') | cl
 list1='tmp.list'
 while (fscan(list1,fname,obj,npix,filter,ra,dec,aot,expid) != EOF) {
    if (substr(filter,1,1)!=chname) goto nextfile
    if (expid==1) goto nextfile
    print('! ls m*'//fname//'.fits') | cl | scan(mfname)
    if (!access(mfname)) goto nextfile

    ## copy masked area
    if (!access(outf)) {
       hselect(mfname,fields='blank',exp=yes) | scan(blank)
       imexpr('abs(a-b)<0.01?b:0.',outf,mfname,blank,"","","","","","","","","","","","","","","","","","","","","","","","",intype='real',outtype='real',ver-)
    } else {
       if (access('tmp.fits')) imdel('tmp.fits')
       imexpr('(abs(a-b)<0.01)||(abs(c-b)<0.01)?b:0.','tmp.fits',mfname,blank,outf,"","","","","","","","","","","","","","","","","","","","","","","",intype='real',outtype='real',ver-)
       print('! mv -f tmp.fits '//outf) | cl
    }

    nfile=nfile+1
    nextfile:
 }

 print('## mask of '//nfile//' file(s) copied to '//outf)

end
