## sub_el.cl -- to fit and subtract a time dependent background pattern, 
## which has been created by 'mk_el.cl'
## The images listed in the input list need to be 
##  1) consistent in observing date, band, and exposure
##  2) reduced through the 'prepipeline' & 'pipeline1' but before flat fielding
## A mask file created by 'mk_el' needs to be in the CWD

## needs update for new MIR-S flat

## created:  2010/09/01  Fumi Egusa
## modified: 2010/10/20 (F. Egusa), assuming the use after 'pipeline1' & 'mk_el'
##           2010/10/22 (F. Egusa), add flat fielding
## 2014/06/12 (F.Egusa), updated for new L18W flat

## products of this script
##    'k'fname: sky subtracted images (deleted if deltmp=yes)
##   'Ek'fname: sky & EL subtracted images 
##    'f'fname: flat fielded image of the above (to be used next calibrations)
##  'xEk'fname: shifted images of above fits (for check)
##    'r'fname: ratio of original/sky (created if niter=0)
##   'ro'fname: ratio of object-subtracted/sky (created if niter>0)
##   'rk'fname: ratio of object-&-sky-subtracted/EL

procedure sub_el(filelist,ELfits,maskfits)

string filelist {prompt="a list of files to be analyzed"}
string ELfits {prompt="a template for the Earth shine light pattern"}
string maskfits {prompt="mask file created by 'mk_el'"}
bool deltmp=no {prompt="delete temporary files?"}
int niter {0, prompt="number of iteration: 0=no iteration"}
real blankval {-9999.9,max=-1000., prompt="blank value"}
real ratiolimit {0.05, prompt="lower limit to scaling factor for EL pattern"}
int boxsize {31, prompt="box size for xregister"}

struct *list0

begin

 string flist,fEL
 int nitr
 real blank
 string fname,lname,band,band1,detec
 string libpath,flat,flatpath
 string fmin,fsky,fmask
 int n,date,date1,expid,expid1
 real ratio,thratio,vsky
 string fobj,outlist,outfits,xregion
 int box
 string nflat,nflatpath,outlist2,outname

## get query parameters
 flist=filelist
 fEL=ELfits
 fmask=maskfits
 nitr=niter
 blank=blankval
 thratio=ratiolimit
 box=boxsize

## default parameters
 if ((strlstr(".list",flist) == strlen(flist)-4) || (strlstr(".vsky",flist) == strlen(flist)-4)) {
    lname=substr(flist,1,strlen(flist)-5)
 } else {
    lname=flist
 }
 fsky=lname//".sky.fits"
 outlist=lname//".subel.list"
 outlist2=lname//".subel_f.list"
 outfits=lname//".subel.comb.fits"
 nflatpath="arimatsuFLAT20101013/"

## check the input files
 if (! access(fEL)) {
    print("### ERROR: "//fEL//" not found!")
    bye
 }
 if (! access(fmask)) {
    print("### ERROR: "//fmask//" not found!")
    bye
 }

## check the input list
 n=0
 list0=flist
 while (fscan(list0,fname) != EOF) {
    n=n+1
    if (access("tmp.dat")) del("tmp.dat")
    hselect(fname,"DATE-REF",yes, > "tmp.dat")
    print("! cut -b 1-10 tmp.dat | sed s/-/''/g") | cl | scan(date)
    hselect(fname,"FILTER",yes) | scan(band)
    hselect(fname,"EXPID",yes) | scan(expid)
    if (expid > 1) expid=2
    if (n == 1) {
       date1=date
       band1=band
       expid1=expid
       hselect(fname,"DETECTOR",yes) | scan(detec)
    } else {
       if (date != date1) {
      	  print("### ERROR: input files are not consistent in observing date!")
      	  bye
       }
       if (band != band1) {
      	  print("### ERROR: input files are not consistent in observing band!")
      	  bye
       }
       if (expid != expid1) {
       	  print("### ERROR: input files are not consistent in exposure time!")
      	  bye
       }
    }
 }
 print("### Input data summary ###")
 print("###  Date (yyyymmdd): "//date//", Band: "//band//", "//n//" file(s)")
 print("")

## define flat & region for xregister
 libpath=osfn("irclib$")
 if (date > 20070108) {
    flatpath="soramame-nashi/"
 } else {
    flatpath="soramame-ari/"
 }
 if (detec == "NIR") {
    if (band == "N2") flat=libpath//"flat/"//flatpath//"N2.fits"
    if (band == "N3") flat=libpath//"flat/"//flatpath//"N3.fits"
    if (band == "N4") flat=libpath//"flat/"//flatpath//"N4.fits"
#  xregion="[1:412,1:385]"
    xregion="[65:192,65:192]"
 } else if (detec == "MIRS") {
    if (band == "S7") flat=libpath//"flat/"//flatpath//"S7.fits"
    if (band == "S9W") flat=libpath//"flat/"//flatpath//"S9W.fits"
    if (band == "S11") flat=libpath//"flat/"//flatpath//"S11.fits"
#  xregion="[27:256,1:256]"
    xregion="[65:192,65:192]"
 } else if (detec == "MIRL") {
    if (band == "L15") flat=libpath//"flat/"//flatpath//"L15.fits"
    if (band == "L18W") flat=libpath//"flat/"//flatpath//"L18W.fits"
    if (band == "L24") flat=libpath//"flat/"//flatpath//"L24.fits"
#  xregion="[1:235,1:256]" #(maybe) too large! resulting in failure of xregister
#  xregion="[37:164,65:192]" #avoid the bad pix region
    xregion="[99:158,99:158]"
 }


## read the input list
 if (access("filename.list")) del("filename.list")
 print("! grep -v '#' "//flist//" | awk '{print $1}' > filename.list") | cl
 hedit("@filename.list","BLANK",blank,add+,ver-,show-,update+)

 n = 0


## sky fitting
skyfit:
 if (n == 0) {
    if (access("tmp.dat")) del("tmp.dat")
    if (access("fsky.list")) del("fsky.list")
    imstat("@filename.list",lower=blank+0.1,nclip=5,format-,fields="im,mean,mode,npix", > "tmp.dat")
    print("! sort -k 3 -n tmp.dat | awk '{print $1, $3}' | head -1") | cl | scan(fmin,minmode)
    print(fmin, >> "fsky.list")
 }
 print("### template for sky: "//fmin)

## sky fit with mode of ratio
 if (access(fsky)) imdel(fsky)
 if (access("tmp1.fits")) imdel("tmp1.fits")
 imexpr("(c>0) ? a/b/c : d","tmp1.fits",fmin,flat,fmask,blank,"","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
 imstat("tmp1.fits",lower=blank+0.1,fields='mode',nclip=5,format-) | scan(ratio)
 print("###  mode of ratio (sky template/flat): "//ratio)
 imexpr("(c>0) ? a*b/c : d",fsky,flat,ratio,fmask,blank,"","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
 imstat(fsky,fields="mean",lower=blank+0.1,nclip=5,format-) | scan(vsky)
 print("###  constant sky value: "//vsky)

 if (access("skyratio.list")) del("skyratio.list")
 if (access("skyratio.imst")) del("skyratio.imst")
 list0="fsky.list"
 while (fscan(list0,fname) != EOF) {
    if (access("r"//fname)) imdel("r"//fname)
    imexpr("(c>0) ? a/b/c : d","r"//fname,fname,fsky,fmask,blank,"","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
    print("r"//fname, >> "skyratio.list")
 }
 imstat("@skyratio.list",fields='im,npix,mode,mean,stddev,min,max',nclip=5,lower=blank+0.1, > "skyratio.imst")


## sky subtraction
 if (access("subsky.list")) del("subsky.list")
 print("! cat filename.list | awk '{print \"k\"$1}' > subsky.list") | cl
 list0="filename.list"
 while (fscan(list0,fname) != EOF) {
    if (access("k"//fname)) imdel("k"//fname)
    imexpr("(c>0) ? (a-b)/c : d","k"//fname,fname,fsky,fmask,blank,"","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
#    hedit("k"//fname,"AVGSKY",vsky,add+,ver-,show-,update+)
 }


## EL fitting & subtraction
 if (access("ELratio.list")) del("ELratio.list")
 print("! cat subsky.list | awk '{print \"r\"$1}' > ELratio.list") | cl
 if (access(outlist)) del(outlist)
 print("! cat subsky.list | awk '{print \"E\"$1}' > "//outlist) | cl
 if (access("xreg.shift.0")) del("xreg.shift.0")

 if (n == 0) fobj="k"//fmin
 print("### template for obj: "//fobj)

 list0="subsky.list"
 while (fscan(list0,fname) != EOF) {
    if (access("tmp1.fits")) imdel("tmp1.fits")
    if (access("xreg.shift")) del("xreg.shift")
    xregister(fobj,fname,xregion,"xreg.shift",output="tmp1.fits",databasefmt-,xwin=box,ywin=box,boundary="constant",constant=0.,ver-,interp="drizzle[0.5]")
    print("! cat xreg.shift >> xreg.shift.0") | cl

    if (access("r"//fname)) imdel("r"//fname)
    imexpr("(d>0) ? (a-b)/c/d : e","r"//fname,fname,"tmp1.fits",fEL,fmask,blank,"","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
    imstat("r"//fname,fields="mode",lower=blank+0.1,nclip=5,format-) | scan(ratio)
    if (ratio < thratio) ratio=0.
    if (ratio == INDEF) ratio=0.
    print("###  EL scaling factor for "//fname//": "//ratio)
    if (access("E"//fname)) imdel("E"//fname)
    imexpr("(d>0) ? (a-c*b)/d : e","E"//fname,fname,ratio,fEL,fmask,blank,"","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
    if (ratio > 0.) hedit("E"//fname,"ELRATIO",ratio,add+,delete-,show-,ver-,update+)
 }

 if (access("ELratio.imst")) del("ELratio.imst")
 imstat("@ELratio.list",fields='im,npix,mode,mean,stddev,min,max',nclip=5,lower=blank+0.1, > "ELratio.imst")


## making shifted & combined images
 print("### shifting and combining EL-subtracted images...")
 if (access("xreg.shift")) del("xreg.shift")
 if (access("xEL.list")) del("xEL.list")
 print("! cat "//outlist//" | awk '{print \"x\"$1}' > xEL.list") | cl
 list0="xEL.list"
 while (fscan(list0,fname) != EOF) {
    if (access(fname)) imdel(fname)
 }
#xregister("@"//outlist,fobj,xregion,"xreg.shift",output="@xEL.list",databasefmt-,loreject=blank+0.1,xwin=box,ywin=box,interp="nearest",boundary="constant",constant=blank,ver-) #good for keeping blank/masked pixels
 xregister("@"//outlist,fobj,xregion,"xreg.shift",output="@xEL.list",databasefmt-,loreject=blank+0.1,xwin=box,ywin=box,interp="drizzle[0.5]",boundary="constant",constant=blank,ver-) #good for alignment of frames

 if (access(outfits)) del(outfits)
 if (access("tmp.dat")) del("tmp.dat")
 ! cat xreg.shift | awk '{print $2, $3}' > tmp.dat
#combine("@xEL.list",outfits,combine="median",reject="sigclip",lthreshold=blank+0.1,blank=blank) #covers only the common region
 combine("@"//outlist,outfits,combine="median",reject="sigclip",lthreshold=blank+0.1,blank=blank,offsets="tmp.dat") #covers the whole region but offsets rounded to integers


## for iteration
 n=n+1
 if (nitr == 0) goto flat
 if (n > nitr) goto flat

 print("")
 print("### "//n//"th iteration ###")
 print("")

 if (access("fobj.comb.fits")) imdel("fobj.comb.fits")
 combine("@xEL.list","fobj.comb.fits",combine="median",reject="sigclip",lthreshold=blank+0.1,blank=blank)
 fobj="fobj.comb.fits"

 if (access("tmp.dat")) del("tmp.dat")
 if (access("fsky.list")) del("fsky.list")
 if (access("xreg.shift.fsky")) del("xreg.shift.fsky")
 ! grep -v '#' ELratio.imst | awk '{print $1, $3}' > tmp.dat
 list0="tmp.dat"
 while (fscan(list0,fname,ratio) != EOF) {
    if (ratio < thratio) {
       fname=substr(fname,3,strlen(fname))
       if (access("xreg.shift")) del("xreg.shift")
       if (access("tmp1.fits")) imdel("tmp1.fits")
       if (access("o"//fname)) imdel("o"//fname)
       xregister(fobj,fname,xregion,"xreg.shift",output="tmp1.fits",databasefmt-,xwin=box,ywin=box,boundary="constant",constant=0.,ver-,interp="drizzle[0.5]")
       imexpr("(c>0) ? (a-b)/c : d","o"//fname,fname,"tmp1.fits",fmask,blank,"","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
       print("o"//fname, >> "fsky.list")
       print("! cat xreg.shift >> xreg.shift.fsky") | cl
    }
 }
 if (access("fsky.comb.fits")) imdel("fsky.comb.fits")
 combine("@fsky.list","fsky.comb.fits",combine="median",reject="sigclip",lthreshold=blank+0.1,blank=blank)
 fmin="fsky.comb.fits"

 goto skyfit


## flat fielding
flat:
 # define new flat files for MIR-L
 if (band == "L15") nflat = libpath//"flat/"//nflatpath//"L15_flat01.fits"
 if (band == "L18W") nflat = libpath//"flat/"//nflatpath//"L18_flat01.fits"
 if (band == "L24") nflat = libpath//"flat/"//nflatpath//"L24_flat01.fits"

 list0="filename.list"
 if (access(outlist2)) del(outlist2)
 while (fscan(list0,fname) != EOF) {
    outname="f"//fname
    fname="Ek"//fname
    if (access(outname)) imdel(outname)
    if (access("tmp1.fits")) imdel("tmp1.fits")
    if (((band == "L15") || (band == "L24")) || (band == "L18W")) {
       imexpr("(b>0) ? (a/b) : c",outname,fname,nflat,blank,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
       imexpr("(b>0) ? (a/b) : c","tmp1.fits",fsky,nflat,blank,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
    } else {
       imexpr("(b>0) ? (a/b) : c",outname,fname,flat,blank,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
       imexpr("(b>0) ? (a/b) : c","tmp1.fits",fsky,flat,blank,"","","","","","","","","","","","","","","","","","","","","","","",outtype="real",ver-)
    }
    imstat("tmp1.fits",lower=blank+0.1,fields="mean",format-,nclip=5,lsigma=5.,usigma=5.) | scan(vsky)
    hedit(outname,"AVGSKY",vsky,ver-,show-,update+,add+)
    print(outname, >> outlist2)
 }


## deleting temporary files
cleanfiles:
 if (deltmp) {
    imdel("@subsky.list")
    del("subsky.list")
 }

## print summary
 print("")
 print("### For checking results")
 print("###  list of EL-subtracted images: "//outlist)
 print("###  list of calculated shifts: xreg.shift.0, xreg.shift")
 print("###  combined image of the object: "//outfits)
 print("###  list of FITS for the ratio of sky template/flat: skyratio.list")
 print("###  statistics for the above FITS: skyratio.imst")
 print("###  list of FITS for the ratio of observed/template EL: ELratio.list")
 print("###  statistics for the above FITS: ELratio.imst")
 print("")

## end of the script
end
