# ircslice.cl -- To slice the IRC 3D images into the 2D ones.
# Created: Yoshifusa Ita, 02-Jul-05
# 05-Jul-05 - Add cleaning (Y. Ita)
# Updated: Yoshifusa Ita, 25-Aug-06, Add header keyword - GAIN and SUBID
# Updated: Yoshifusa Ita, 05-Nov-06, Add header keyword - C(R)PIX1 and C(R)PIX2
# Updated: Takehiko Wada  07-Jan-03, enable to update DETECTOR
#                                    KEYWORD (for MIR)
# Updated: Takehiko Wada  2007/01/03 
#          update HEADER (replace non-alphabet, decimal to "_")
# Updated: Yoshifusa Ita 2008/01/17
#          not to use imslice
#          update MIRL WCS headers correctly
#          delete unnecesary WCS headers
## updated: 2013/10/01 (F. Egusa)
##          to be compatible with perl 5.12 & later
##          script reduced


procedure ircslice (ircconst, verbose)
string  mode="al"

string  ircconst     {"constants.database", prompt="IRC constants database file name"}
bool    verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string irc_const, libpath
 string fname, finput, foutput
 string text, pipever
 int 	naxis, naxis1, naxis2, naxis3
 bool   verb
 real   epadu_nir, epadu_mirs, epadu_mirl
 string object_name	
 real crval1l, crval2l, cd11l, cd12l, cd21l, cd22l
 int crpix1l, crpix2l, i


 print ("### IRCSLICE ###\n")

## get query parameters
 verb = verbose
 irc_const = ircconst


## get default parameters 
 libpath = osfn ("irclib$")
 irc_const = libpath//irc_const
 # pipeline version
 printf("! grep pipever        %s\n", irc_const) | cl | scan(text, pipever)
 # A2D unit (Gain) [electrons/ADU]
 printf("! grep epadu_nir      %s\n", irc_const) | cl | scan(text, epadu_nir)
 printf("! grep epadu_mirs     %s\n", irc_const) | cl | scan(text, epadu_mirs)
 printf("! grep epadu_mirl     %s\n", irc_const) | cl | scan(text, epadu_mirl)


## make input file list
 if( access("filename.list") ){ delete("filename.list", ver-) }
 print ("Making the input file list...\n")
 ! ls -1 ../rawdata | egrep -e F\*.fits > filename.list


## check the dimension of the fits file
 print ("Checking the dimension of the input files...\n")
 if (access("slice_tmp0")) delete("slice_tmp0", ver-) 
 list0 = "filename.list"
 while (fscan(list0, fname) !=EOF) {
    fname="../rawdata/"//fname
    hselect(fname, fields="$I,NAXIS,NAXIS1,NAXIS2,NAXIS3,OBJECT", expr="yes", >> "slice_tmp0")
 }

## output.list format: "FXXXXXXXXX" naxis naxis1 naxis2 naxis3 object_name
## for object_name, '"' excluded and non-alphanumeric characters 
##  (including spaces) replaced by '_'
## compatible with perl 5.12 & later (2013/10/01, FE)
 if (access('output.list')) delete('output.list')
 ! cat slice_tmp0 | perl -e 'while(<>){ chomp; @a=split(/\t/);$a[0]=~s/.*F([0-9]+)_.*/F$1/;$a[5]=~s/\"//g;$a[5]=~s/\W/_/g;printf("%s %d %d %d %d %s\n",$a[0],$a[1],$a[2],$a[3],$a[4],$a[5]) }' > output.list

## slice and imcopy
 print ("Slicing images...\n")
 print ("\t #This may take a while...\n")
 list0 = "output.list"
 while (fscan(list0,fname,naxis,naxis1,naxis2,naxis3,object_name) !=EOF) {
    if (naxis1==0) {
       print('### ERROR: check slice_tmp and output.list!')
       bye
    }

    if (naxis1==412) { # NIR
       finput  = "../rawdata/"//fname//"_N.fits"
       foutput = fname//"_N"
       imcopy(finput,foutput,verbose=verb)

       ## update NIR specific headers
       hedit (foutput, "DETECTOR", "NIR",  add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
       ccdhedit (foutput, paramete="GAIN", value=epadu_nir, type="real")
       ccdhedit (foutput, paramete="CPIX1", value=197.0, type="real")
       ccdhedit (foutput, paramete="CPIX2", value=191.0, type="real")

       ## do slicing (wcsdim needs to be deleted beforehand)
       hedit (foutput, "WCSDIM", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
       imcopy (foutput//"[*,*,1]", foutput//"001.fits", verbose=verb)
       imcopy (foutput//"[*,*,2]", foutput//"002.fits", verbose=verb)
       # EXPID [1:short 2:long]
       ccdhedit (foutput//"001.fits", paramete="EXPID", value=1, type="integer")
       ccdhedit (foutput//"002.fits", paramete="EXPID", value=2, type="integer")

       ## delete temporal image
       imdel(foutput, ver-)

    } else if (naxis1==256) { # MIRS & MIRL
       finput  = "../rawdata/"//fname//"_M.fits"

       for (i=1; i <= 2; i+=1) {
       	  if (i==1) { # MIRS
	     foutput=fname//"_S"
       	     imcopy(finput//"[1:256,1:256,*]",foutput,verb=verb)
       		
             ## update MIRS specific headers
       	     hedit(foutput, "DETECTOR", "MIRS", add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
       	     ccdhedit (foutput, paramete="GAIN", value=epadu_mirs, type="real")
       	     ccdhedit (foutput, paramete="CPIX1", value=150.0, type="real")
       	     ccdhedit (foutput, paramete="CPIX2", value=118.0, type="real")
       	     # 090808 added
       	     hselect(foutput, fields="CRPIX2L", expr="yes") | scan(crpix2l)
       	     crpix2l = crpix2l - 256
       	     hedit(foutput,"CRPIX2L", crpix2l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)

          } else if (i==2) { # MIRL
	     foutput=fname//"_L"
       	     imcopy(finput//"[1:256,257:512,*]",foutput,verb=verb)

	     ## update MIRL specific headers
	     hedit (foutput, "DETECTOR", "MIRL", add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
       	     ccdhedit (foutput, paramete="GAIN", value=epadu_mirl, type="real")
       	     ccdhedit (foutput, paramete="CPIX1", value=121.0, type="real")
       	     ccdhedit (foutput, paramete="CPIX2", value=121.0, type="real")

       	     ## read WCS headers for MIRL
       	     hselect(foutput, fields="CRVAL1L", expr="yes") | scan(crval1l)
       	     hselect(foutput, fields="CRVAL2L", expr="yes") | scan(crval2l)
       	     hselect(foutput, fields="CRPIX1L", expr="yes") | scan(crpix1l)
       	     hselect(foutput, fields="CRPIX2L", expr="yes") | scan(crpix2l)
       	     crpix2l = crpix2l - 256
       	     hselect(foutput, fields="CD1_1L",  expr="yes") | scan(cd11l)
       	     hselect(foutput, fields="CD1_2L",  expr="yes") | scan(cd12l)
       	     hselect(foutput, fields="CD2_1L",  expr="yes") | scan(cd21l)
       	     hselect(foutput, fields="CD2_2L",  expr="yes") | scan(cd22l)

       	     ## update WCS headers for MIRL (original are for MIRS)
       	     hedit (foutput, "CRVAL1", crval1l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit (foutput, "CRVAL2", crval2l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit (foutput, "CRPIX1", crpix1l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit (foutput, "CRPIX2", crpix2l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit (foutput, "CD1_1", cd11l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit (foutput, "CD1_2", cd12l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit (foutput, "CD2_1", cd21l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit (foutput, "CD2_2", cd22l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
       	     hedit(foutput,"CRPIX2L", crpix2l, add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
          }

       	  ## do slicing (wcsdim needs to be deleted beforehand)
	  hedit (foutput, "WCSDIM", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
       	  imcopy (foutput//"[*,*,1]", foutput//"001.fits", verbose=verb)
       	  imcopy (foutput//"[*,*,2]", foutput//"002.fits", verbose=verb)
       	  imcopy (foutput//"[*,*,3]", foutput//"003.fits", verbose=verb)
       	  imcopy (foutput//"[*,*,4]", foutput//"004.fits", verbose=verb)
       	  ccdhedit (foutput//"001.fits", paramete="EXPID", value=1, type="integer")
       	  ccdhedit (foutput//"002.fits", paramete="EXPID", value=2, type="integer")
       	  ccdhedit (foutput//"003.fits", paramete="EXPID", value=3, type="integer")
       	  ccdhedit (foutput//"004.fits", paramete="EXPID", value=4, type="integer")

       	  ## delete temporal image
       	  imdel(foutput, ver-)
       }

       ## 080117
       ## delete unnecessary headers
       if( access("sliced.list") ){ delete("sliced.list", ver-) }
       printf("! ls -1 %s\_?00?.fits > sliced.list\n", fname) | cl
       hedit ("@sliced.list", "CD3_3S",   ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
       hedit ("@sliced.list", "CD3_3L",   ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    }

    ## update headers
    if (access('sliced.list')) del('sliced.list')
    printf("! ls -1 %s\_?00?.fits > sliced.list\n", fname) | cl
    hedit ("@sliced.list", "OBJECT", object_name, add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "PIPEVER", "v"//pipever, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "CD3_3",    ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "CTYPE3",   ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "CRPIX3",   ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "LTV2",     ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "LTV3",     ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "LTM3_3",   ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "WAXMAP01", ".", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
    hedit ("@sliced.list", "WCSDIM", "2",  add=yes, addonly=yes, delete=no, verify=no, show=no, update=yes)
 }


## cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }
 if( access("slice_tmp0")    ){ delete("slice_tmp0", ver-)    }
 if( access("output.list")   ){ delete("output.list", ver-)   }


end
