# mkirclog.cl -- To make observing log file that is necessary for the pipeline
# Created: Yoshifusa Ita, 14-Jul-05
# 27-Sep-05 - Add check function if there are any space(s) in OBJECT (Y. Ita)
# 2007/01/09 T.WADA a bug fix. incorrect irclog are produced when no S/L frame exist.
#                   compatible to ura-format... 

procedure mkirclog (ircconst, verbose)
string  mode="al"

string  ircconst     {"constants.database", prompt="IRC constants database file name"}
bool    verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin
 string fname, pcommand, irc_const, libpath
 bool verb
 real rnoise, rnoise_nir, rnoise_mirs, rnoise_mirl, rnoise_nir_s, rnoise_mirs_s, rnoise_mirl_s
 real exptime, exp_unit, nir_exp_short, nir_exp_long, nir_exp_aot05, nir_exp_aot0c, mir_exp_short, mir_exp_long
 string aot, detector, filter
 int expid


 print ("\n")
 print ("### MKIRCLOG ###\n")


# get query parameters
 verb = verbose
 irc_const = ircconst


# Read irc constants
 libpath = osfn("irclib$")
 irc_const = libpath//irc_const
 # Read out noise [electrons/readout] AOT05$B$N9MN8$O$"$H$G$9$k$N$G5$$K$7$J$/$F$h$$!#(B
 printf("! grep rnoise_nir     %s\n", irc_const) | cl | scan(text, rnoise_nir)
 printf("! grep rnoise_n_short %s\n", irc_const) | cl | scan(text, rnoise_nir_s)
 printf("! grep rnoise_mirs    %s\n", irc_const) | cl | scan(text, rnoise_mirs)
 printf("! grep rnoise_s_short %s\n", irc_const) | cl | scan(text, rnoise_mirs_s)
 printf("! grep rnoise_mirl    %s\n", irc_const) | cl | scan(text, rnoise_mirl)
 printf("! grep rnoise_l_short %s\n", irc_const) | cl | scan(text, rnoise_mirl_s)
 # Exposure time [sec]
 printf("! grep expunit        %s\n", irc_const) | cl | scan(text, exp_unit)
 printf("! grep nir_short      %s\n", irc_const) | cl | scan(text, nir_exp_short)
 printf("! grep nir_long       %s\n", irc_const) | cl | scan(text, nir_exp_long)
 printf("! grep nir_aot05_long %s\n", irc_const) | cl | scan(text, nir_exp_aot05)
 printf("! grep nir_aot0c_long %s\n", irc_const) | cl | scan(text, nir_exp_aot0c)
 printf("! grep mir_short      %s\n", irc_const) | cl | scan(text, mir_exp_short)
 printf("! grep mir_long       %s\n", irc_const) | cl | scan(text, mir_exp_long)


# make file list
 print ("Making the file list...\n")
 if( access("log_input.list") ){ delete("log_input.list", ver-) }
## ! ls -1 F*_N???.fits  > log_input.list
## ! ls -1 F*_S???.fits >> log_input.list
## ! ls -1 F*_L???.fits >> log_input.list
# following is not good when no L (or N, or S) file exist... 
# ! echo F*_N???.fits | xargs ls -1  > log_input.list
# ! echo F*_S???.fits | xargs ls -1 >> log_input.list
# ! echo F*_L???.fits | xargs ls -1 >> log_input.list
# 2007/01/09 T.WADA
#!echo F*_N???.fits | perl -e 'while(<>){split;for($i=0;$i<=$#_;$i++){printf("%s\n",$_[$i])}}' >  log_input.list
#!echo F*_S???.fits | perl -e 'while(<>){split;for($i=0;$i<=$#_;$i++){printf("%s\n",$_[$i])}}' >> log_input.list
#!echo F*_L???.fits | perl -e 'while(<>){split;for($i=0;$i<=$#_;$i++){printf("%s\n",$_[$i])}}' >> log_input.list
# more simply...   
#! ls | egrep 'F[0-9]{9}_[NSL][0-9]{3}.fits' > log_input.list
# ura compatible...
! ls | egrep 'F[0-9]*_[NSL][0-9]*.fits' > log_input.list

! sort -o log_input.list log_input.list


# extract header value
 print ("Reading header...\n")
 print ("\t #This may take a while...\n")
 if( access("header_temp") ){ delete("header_temp", ver-) }
 list0 = "log_input.list"
 while( fscan(list0, fname) !=EOF ){
 	hselect(fname, fields="AOT", expr="yes")      | scan(aot)
 	hselect(fname, fields="EXPID", expr="yes")    | scan(expid)
 	hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
	hedit(fname, "WCSDIM", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
	if(expid == 1){ # short exposure frame
		if(detector=="NIR"){
                        rnoise  = rnoise_nir_s
                        exptime = nir_exp_short*exp_unit
		}else if(detector=="MIRS"){
                        rnoise  = rnoise_mirs_s
                        exptime = mir_exp_short*exp_unit
		}else if(detector=="MIRL"){
                        rnoise  = rnoise_mirl_s
                        exptime = mir_exp_short*exp_unit
		}
	}else{
		if(detector=="NIR"){
                        rnoise  = rnoise_nir
                        if(aot=="IRC05"){
                                exptime = nir_exp_aot05*exp_unit
                                # AOT05$B$N>l9g$O$5$i$K(Brnoise$B$,>.$5$/$J$k(B
                                rnoise = rnoise/2.0
                        }else if(aot=="IRC0C"){
                                exptime = nir_exp_aot0c*exp_unit
                        }else{
                                exptime = nir_exp_long*exp_unit
                        }
		}else if(detector=="MIRS"){
                        rnoise  = rnoise_mirs
                        exptime = mir_exp_long*exp_unit
		}else if(detector=="MIRL"){
                        rnoise  = rnoise_mirl
                        exptime = mir_exp_long*exp_unit
		}
	}
        ccdhedit(fname, paramete="EXPTIME", value=exptime, type="real")
        ccdhedit(fname, paramete="RNOISE",  value=rnoise,  type="real")
 	hselect(fname, fields="$I,OBJECT,NAXIS1,FILTER,RA-SET,DEC-SET,AOT,DETECTOR,EXPID,IDNUM,SUBID", expr="yes", >> "header_temp")
 }


# format observing log
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"formatlog.pl"
 printf("! %s\n",pcommand) | cl


# update header keyword "FILTER" (for MIRS&L)
 list0 = "filter.tmp"
 while( fscan(list0, fname, filter) !=EOF ){
	hedit (fname, "FILTER", filter, add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
 }


# check if the OBJECT in irclog has space(s).
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"checkname.pl"
 printf("! %s\n",pcommand) | cl


# cleaning
 if( access("log_input.list") ){ delete("log_input.list", ver-) }
 if( access("header_temp")    ){ delete("header_temp", ver-)    }
 if( access("irclog.tmp")     ){ delete("irclog.tmp", ver-)     }
 if( access("filter.tmp")     ){ delete("filter.tmp", ver-)     }


 print ("### MKIRCLOG finished!! ###\n")

end

