# prepipeline.cl -- IRC imaging data reduction pre-pipeline task
# Created: Yoshifusa Ita, 01-Jul-05
# 02-Jul-05 - Add redbox.ircslice (Y. Ita)
# 14-Jul-05 - Add redbox.mkirclog (Y. Ita)
# 11-May-06 - Add lines to comment out dark and spectroscopic data (Y. Ita)
## 2013/10/01 (F. Egusa) - stop if no FITS data in ../rawdata
## 2013/11/16 (F. Egusa) - comment out the line with 'NULL'
## 2014/02/28 (F. Egusa) - add 'pllog' option
## 2015/01/23 (F. Egusa) - add IRAF ver info to environments

procedure prepipeline

string  ircconst     {"constants.database", prompt="IRC constants database file name"}
bool 	verbose = no {prompt="Print verbose progress messages?\n"}
string  pllog {'ircpipeline.log',prompt='log file for pipeline processes'}
string  mode="al"

begin
 string flog, irc_const, pcommand
 bool verb
 int nfits
 string date,time,os,ircdir,ircver


## get query parameter
 irc_const = ircconst
 verb = verbose
 flog=pllog


## stop if no FITS data in ../rawdata (2013/10/01, FE)
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! ls -1 ../rawdata | egrep -e F\*.fits > filename.list
 print('! wc filename.list') | cl | scan(nfits)
 if (nfits==0) {
    print('### ERROR: no FITS files in ../rawdata!')
    bye
 }

## stop if 'irclog' exists
 if (access('irclog')) {
    print("### ERROR: 'irclog' already exists.")
    print("###        prepipeline must have already been done!!")
    bye
 }


## print environments to pllog 
## will OVERWRITE old pllog if exists (2014/03/06, FE)
 if (access(flog)) del(flog)
 print('## ENVIRONMENTS ##', > flog)
 print('! uname -s') | cl | scan(os)
 if (os=='SunOS') print("! echo 'OS: Solaris' `uname -v` >> flog") | cl
 if (os=='Darwin') print("! echo 'OS: Mac OS X' `sw_vers -productVersion` >> "//flog) | cl
 if (os=='Linux') {
    if (access('/etc/redhat-release')) {
       print("! echo 'OS:' `head -1 /etc/redhat-release` >> "//flog) | cl
    } else {
       print("! echo 'OS:' `head -1 /etc/issue` >> "//flog) | cl
    }
 }
 print('Perl:', >> flog)
 print("! perl -v | grep 'This is perl' >> "//flog) | cl

 print('', >> flog)
 print(cl.version, >> flog)
 ircdir=osfn('irc$')
 print('! grep pipever '//ircdir//"lib/constants.database | grep -v '#' | awk '{print $2}'") | cl | scan(ircver)
 print('IRC toolkit: ver.'//ircver//' in '//ircdir, >> flog)


## print date, time, and pipeline command with options to pllog
 printf('\n\n## PROCESS LOGS ##\n\n', >> flog)
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 print('- '//date//' '//time, >> flog)
 print('prepipeline(ircconst='//irc_const//',verbose='//verb//',pllog='//flog//')', >> flog)

 print ("\n")
 print ("### PRE-PIPELINE ###\n")


## ircslice
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' ircslice(ircconst='//irc_const//',verbose='//verb//')', >> flog)
 ircslice(irc_const, verb)

## make irclog
 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(' mkirclog(ircconst='//irc_const//',verbose='//verb//')', >> flog)
 mkirclog(irc_const, verb)


# comment out dark and spectroscopy data
# for gnu sed only
# ! cat irclog | sed -e '/ DARK \| NP \| NG \| SG1 \| SG2 \| LG1 \| LG2 \| UNDEF /s/^/#/' > tmp
# for all sed
 ! cat irclog | sed -e '/ DARK /s/^/#/' -e '/ NP /s/^/#/' -e '/ NG /s/^/#/' -e '/ SG1 /s/^/#/' -e '/ SG2 /s/^/#/' -e '/ LG1 /s/^/#/' -e '/ LG2 /s/^/#/' -e '/ UNDEF /s/^/#/' -e '/ NULL /s/^/#/' > tmp

 ! \mv tmp irclog


## make dark list
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"darklist.pl"
 printf("! %s irclog\n",pcommand) | cl

## check if the irclog is correct
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"checkirclog.pl"
 printf("! %s\n",pcommand) | cl

 print("! date +'%Y/%m/%d %H:%M:%S'") | cl | scan(date,time)
 printf('- %s %s\n',date,time, >> flog)
 print(" 'irclog' and 'darklist.before' created", >> flog)

 print ("\n")
 print ("### PRE-PIPELINE finished!! ###\n")
 print ("\n\n")
 print ("######\n Please edit \"irclog\" before running pipeline1! \n######")
 print ("\n\n")



end
