// header.c
// To add header keywords to the image
// Created: Yoshifusa Ita, 31-Jun-06
// gcc -Wall -O2 -o addheader addheader.c -lm -lcfitsio (Linux)
// gcc -O2 -o addheader addheader.c -lm -lcfitsio -lnsl -lsocket (Solaris)

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <fitsio.h>

void printerror(int status);

int main(int argc, char **argv){
  fitsfile *fptr_input;
  int status = 0;

  // Usage
  if(argc<6){
    puts("addheader [filename] [Keyword] [value] [datatype] [\"Comment\"]");
    puts("Example: header input.fits FILTER N2 0");
    puts("datatype:");
    puts("0: string");
    puts("1: int");
    puts("2: long int");
    puts("3: float");
    puts("4: double");
    exit(1);
  }

  // Input file open
  if(fits_open_file(&fptr_input, argv[1], READWRITE, &status)){
    printerror( status );
  }

  if(atoi(argv[4])==0){ 
    if(fits_update_key(fptr_input, TSTRING, argv[2], argv[3], argv[5], &status)){
      printerror( status );
    }
  }else if(atoi(argv[4])==1){
    int value;
    value = atoi(argv[3]);
    if(fits_update_key(fptr_input, TINT, argv[2], &value, argv[5], &status)){
      printerror( status );
    }
  }else if(atoi(argv[4])==2){
    long value;
    value = atol(argv[3]);
    if(fits_update_key(fptr_input, TLONG, argv[2], &value, argv[5], &status)){
      printerror( status );
    }
  }else if(atoi(argv[4])==3){
    float value;
    value = (float) atof(argv[3]);
    if(fits_update_key(fptr_input, TFLOAT, argv[2], &value, argv[5], &status)){
      printerror( status );
    }
  }else if(atoi(argv[4])==4){
    double value;
    value = atof(argv[3]);
    if(fits_update_key(fptr_input, TDOUBLE, argv[2], &value, argv[5], &status)){
      printerror( status );
    }
  }else{
    puts("you idiot!!");
    if(fits_close_file(fptr_input, &status)){
      printerror( status );
    }
    exit(1);
  }

  // Fits file close
  if(fits_close_file(fptr_input, &status)){
    printerror( status );
  }

  return 0;
}

void printerror(int status){
  // Print out cfitsio error messages and exit program
  char status_str[FLEN_STATUS], errmsg[FLEN_ERRMSG];

  if (status)
    fprintf(stderr, "\n*** Error occurred during program execution ***\n");

  fits_get_errstatus(status, status_str); // get the error description
  fprintf(stderr, "\nstatus = %d: %s\n", status, status_str);

  // get first message; null if stack is empty
  if ( fits_read_errmsg(errmsg) ) {
    fprintf(stderr, "\nError message stack:\n");
    fprintf(stderr, " %s\n", errmsg);
    while ( fits_read_errmsg(errmsg) )  // get remaining messages
      fprintf(stderr, " %s\n", errmsg);
  }
  exit( status ); // terminate the program, returning error status
}
