// lonesome.c
// To delete phantom stars present in the source list file before coadd process.
// phantom star: source without closest counterpart within ID pixels in the same cycle
// Created: Yoshifusa Ita, 18-Oct-05
// gcc -Wall -O2 -o lonesome lonesome.c -lm (Linux)
// gcc -O2 -o lonesome lonesome.c -lm (Solaris)
// Modified: 2010/12/03 (F. Egusa) nexp -> nexp * 3
//           2011/07/20 (F. Egusa) not to read unexisting files

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#define ID 15.0 
#define MAXDATA 30000

struct list{
  char fname[500];
  char filter[10];
  double ra;
  double dec;
  int expid;
  long pointid;
  int subid;
  char aot[10];
  int flag;
  int pair;
};

struct coo{
  char name[500];
  float x[MAXDATA];
  float y[MAXDATA];
  float m[MAXDATA];
  float d[MAXDATA];
  float dmin1[MAXDATA];
  float dmin2[MAXDATA];
  float n;
  int flag[MAXDATA];
};

int main(int argc, char **argv){
  FILE *fp, *fp2, *fptmp;
  struct list *flist;
  struct coo  *data;
  char temp[500], text[500], prefix[20], fname[500];
  int i, j, k, n, npair, nfile;
  int *nexp;
  double min;


  // $B;H$$$+$?(B
  if(argc!=3){
    puts("lonesome filename prefix");
    puts("Example: lonesome pair0001_S11.list_long SemfCcDlnw");
    exit(1);
  }


  // prefix
  strcpy(prefix,argv[2]);


  // $B%$%s%W%C%H%U%!%$%k$rFI$_9~$`(B
  if(!(fp=fopen(argv[1],"r"))){
    printf("cannot read %s\n", argv[1]);
    exit(2);
  }
  flist = (struct list *)malloc(sizeof(struct list)*500);
  i=0;
  while(fgets(temp, sizeof(temp), fp)!=NULL){
    sscanf(temp,"%s %s %lf %lf %d %ld %d %s",
	   text,
	   flist[i].filter,
	   &flist[i].ra,
	   &flist[i].dec,
	   &flist[i].expid,
	   &flist[i].pointid,
	   &flist[i].subid,
	   flist[i].aot);
    j = strlen(text);
    strncpy(flist[i].fname, &(*(text+0)), j-1); // .fname=F*_?00
    flist[i].flag = 0;
    flist[i].pair = 0;
    i++;
  }
  nfile = i;
  fclose(fp);


  // $B%Z%"%j%s%03+;O(B&lonesome$B%U%!%$%k$r:n$k(B
  // lonesome????.list: list of frames in the same cycle
  npair = 0;
  for(i=0;i<nfile;i++){
    if(flist[i].flag==0){
      npair++;
      // $B%U%!%$%k$K=q$-9~$`0Y$N=`Hw(B
      sprintf(text,"lonesome%04d.list",npair);
      if(!(fp=fopen(text,"w"))){
	printf("cannot write %s\n", text);
	exit(2);
      }
      for(j=0;j<nfile;j++){
	if(flist[j].flag==0){
	  if(strcmp(flist[i].fname,flist[j].fname)==0){
	    sprintf(text, "%s%s%1d.fits.coo.1", prefix, flist[j].fname, flist[j].expid);
	    // write only an existing file name into the list (2011/07/20 FE)
	    if((fptmp=fopen(text,"r"))) {
	      fprintf(fp,"%s\n",text);
	      flist[i].flag = 1;
	      flist[j].flag = 1;
	    }
	  }
	}
      }
      fclose(fp);
    }
  }

  // lonesome$B%U%!%$%k$rFI9~$s$GH/F0(B
  nexp = (int *)malloc(sizeof(int)*npair*3);
  data = (struct coo *)malloc(sizeof(struct coo)*3);
  for(i=1;i<=npair;i++){
    sprintf(fname,"lonesome%04d.list", i);
    fp=fopen(fname,"r");
    k=0;
    while(fgets(temp, sizeof(temp), fp)!=NULL){
      n = strlen(temp);
      strcpy(text, "");
      strncpy(text, &(*(temp+0)), n-1);
      // added 070329
      text[n-1] = '\0';
      strcpy(data[k].name, text); // S*.fits.coo.1
      fp2=fopen(text,"r");
      j=0;
      while( fgets(temp, sizeof(temp), fp2)!=NULL && j < MAXDATA-1 ){
	sscanf(temp,"%f %f %f",
	       &data[k].x[j],
	       &data[k].y[j],
	       &data[k].m[j]);
	data[k].flag[j]=0;
	j++;
      }
      fclose(fp2);
      data[k].n=j; // # of sources in *.coo.1
      k++;
    }
    fclose(fp);
    sprintf(temp, "rm -rf %s\n", fname);
    system(temp); // delete 'lonesome*.list'

    nexp[npair]=k; // expid$B$,$J$s$3$"$k$+!#:GBg#3(B - no need to be array?

    // calculate minimum distance for each source
    if(nexp[npair]>1){
      // 1 vs 2
      // 1
      for(j=0;j<data[0].n;j++){
	min=5E10;
	for(k=0;k<data[1].n;k++){
	  data[1].d[k] = sqrt( pow( (data[0].x[j]-data[1].x[k]), 2) + pow( (data[0].y[j]-data[1].y[k]), 2) );
	  if(data[1].d[k] < min) min = data[1].d[k];
	}
	data[0].dmin1[j] = min;
      }
      // 2
      for(k=0;k<data[1].n;k++){
	min=5E10;
	for(j=0;j<data[0].n;j++){
	  data[0].d[j] = sqrt( pow( (data[0].x[j]-data[1].x[k]), 2) + pow( (data[0].y[j]-data[1].y[k]), 2) );
	  if(data[0].d[j] < min) min = data[0].d[j];
	}
	data[1].dmin1[k] = min;
      }
      if(nexp[npair]==3){
	// 1 vs 3
	// 1
	for(j=0;j<data[0].n;j++){
	  min=5E10;
	  for(k=0;k<data[2].n;k++){
	    data[2].d[k] = sqrt( pow( (data[0].x[j]-data[2].x[k]), 2) + pow( (data[0].y[j]-data[2].y[k]), 2) );
	    if(data[2].d[k] < min) min = data[2].d[k];
	  }
	  data[0].dmin2[j] = min;
	}
	// 3
	for(k=0;k<data[2].n;k++){
	  min=5E10;
	  for(j=0;j<data[0].n;j++){
	    data[0].d[j] = sqrt( pow( (data[0].x[j]-data[2].x[k]), 2) + pow( (data[0].y[j]-data[2].y[k]), 2) );
	    if(data[0].d[j] < min) min = data[0].d[j];
	  }
	  data[2].dmin1[k] = min;
	}
	// 2 vs 3
	// 2
	for(j=0;j<data[1].n;j++){
	  min=5E10;
	  for(k=0;k<data[2].n;k++){
	    data[2].d[k] = sqrt( pow( (data[1].x[j]-data[2].x[k]), 2) + pow( (data[1].y[j]-data[2].y[k]), 2) );
	    if(data[2].d[k] < min) min = data[2].d[k];
	  }
	  data[1].dmin2[j] = min;
	}
	// 3
	for(k=0;k<data[2].n;k++){
	  min=5E10;
	  for(j=0;j<data[1].n;j++){
	    data[1].d[j] = sqrt( pow( (data[1].x[j]-data[2].x[k]), 2) + pow( (data[1].y[j]-data[2].y[k]), 2) );
	    if(data[1].d[j] < min) min = data[1].d[j];
	  }
	  data[2].dmin2[k] = min;
	}
      }

      // *.coo.1$B%U%!%$%k$r>e=q$-(B
      // if no counterparts within ID pixels, the source is removed.
      for(j=0;j<nexp[npair];j++){
	fp=fopen(data[j].name, "w");
	for(k=0;k<data[j].n;k++){
	  if(data[j].dmin1[k] < ID || data[j].dmin2[k] < ID){
          //	  if(data[j].dmin1[k] < ID && data[j].dmin2[k] < ID){
	    fprintf(fp, "%f %f %f\n", data[j].x[k], data[j].y[k], data[j].m[k]);
	  }
	}
	fclose(fp);
      }
    } // nexp[npair] > 1

  }

  return 0;
}
