// mkflatpair.c
// To make pair for coadd
// Created: Yoshifusa Ita, 1-Feb-06
// gcc -Wall -O2 -o mkflatpair mkflatpair.c -lm (Linux)
// gcc -O2 -o mkflatpair mkflatpair.c -lm (Solaris)

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

struct irc{
  char line[256];
  char fname[256];
  char filter[256];
  int pair_flag;
};

int main(int argc, char **argv){
  FILE *fp;
  struct irc *data;
  int n_data;
  int i,j,k;
  char text[512];

  // $B;H$$$+$?(B
  if(argc!=3){
    puts("Usage: mkflatpair input.list 120");
    exit(1);
  }

  // $B%$%s%W%C%H%U%!%$%k$rFI$_9~$`(B
  if(!(fp=fopen(argv[1],"r"))){
    printf("cannot read %s\n", argv[1]);
    exit(2);
  }

  // $B%G!<%?$N?t$K$h$C$F%a%b%j3d$jEv$F(B
  n_data = atoi(argv[2]);
  data = (struct irc *)malloc(sizeof(struct irc)*n_data);

  // $B%G!<%?$rFI$_9~$s$G9=B$BN$K3JG<(B
  i=0;
  while(fgets(text, sizeof(text), fp)!=NULL){
    strcpy(data[i].line, text);
    sscanf(text,"%s %s", data[i].fname, data[i].filter);
    data[i].pair_flag = 0;
    i++;
  }
  n_data = i;
  fclose(fp);

  // $B%Z%"%j%s%03+;O(B
  k = 0;
  for(i=0;i<n_data;i++){
    if(data[i].pair_flag==0){
      k++;
      // $B%U%!%$%k$K=q$-9~$`0Y$N=`Hw(B
      sprintf(text,"pair%04d.list",k);
      if(!(fp=fopen(text,"w"))){
	printf("cannot write %s\n", text);
	exit(2);
      }
      for(j=0;j<n_data;j++){
	if(data[j].pair_flag==0){
	  if( strcmp(data[i].filter,data[j].filter)==0 ){
	    fprintf(fp,"%s",data[j].line);
	    data[i].pair_flag = 1;
	    data[j].pair_flag = 1;
	  }
	}
      }
      fclose(fp);
      sprintf(text,"mv pair%04d.list %s.list",k,data[i].filter);
      system(text);
    }
  }

  return 0;
}
