// wipestars.c
// 
// Created: Tomohiko Nakamura, 08-Apr-13
// gcc -Wall -O2 -o convert2mass convert2mass.c -lm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#define PI M_PI
#define deg2rad ( PI/180. )
#define rad2deg ( 180./PI )
#define FRDMIN  ( 180.0*60.0/PI ) 

#define MAX_STARS 1000

typedef struct {
  long id;
  double ra, dec;
  double x, y;
  float mag, emag;
} star_coord;


int read_inp_file(char *, star_coord *);
int read_ref_file(char *, star_coord *);
void write_inp_file(char *, star_coord *, int);
void write_ref_file(char *, star_coord *, int);
void wipe_stars(star_coord *, star_coord *,
                star_coord *, star_coord *,
                int *, int *, float);


int main(int argc, char **argv){
  int inp_star_num, ref_star_num;

  star_coord inp_stars[MAX_STARS];    // input stars
  star_coord ref_stars[MAX_STARS];    // reference stars
  star_coord inp_stars2[MAX_STARS];   // wiped input stars
  star_coord ref_stars2[MAX_STARS];   // wiped reference stars

  if(argc < 6){
    puts("Usage: a.out input.list reference.list wiped_input.list wiped_reference.list");
    exit(1);
  }

  inp_star_num = read_inp_file(argv[1], inp_stars);
  ref_star_num = read_ref_file(argv[2], ref_stars);
  wipe_stars(inp_stars, ref_stars, inp_stars2, ref_stars2, &inp_star_num, &ref_star_num, atof(argv[5]));
  write_inp_file(argv[3], inp_stars2, inp_star_num);
  write_ref_file(argv[4], ref_stars2, ref_star_num);

  printf("number of reference stars: %d\n", ref_star_num);
  printf("number of input stars: %d\n", inp_star_num);

  return 0;
}

int read_ref_file(char *filename, star_coord stars[]){
  FILE *fin;
  char text[500];

  fin = fopen(filename, "r");
  int i = 0;
  while( fgets(text,sizeof(text),fin) != NULL ){
    sscanf(text, "%ld %lf %lf %lf %lf %f %f",
           &stars[i].id, &stars[i].ra, &stars[i].dec,
           &stars[i].x, &stars[i].y, &stars[i].mag, &stars[i].emag);
    i++;
    if(i>MAX_STARS-1){
      fprintf(stdout, "%s: exceeded maximum number of stars (%d)", filename, MAX_STARS);
      break;
    }
  }
  fclose(fin);
  return i;
}

int read_inp_file(char *filename, star_coord stars[]){
  FILE *fin;
  char text[500];

  fin = fopen(filename, "r");
  int i = 0;
  while( fgets(text,sizeof(text),fin) != NULL ){
    sscanf(text, "%lf %lf %f",
           &stars[i].x, &stars[i].y, &stars[i].mag);
    i++;
    if(i>MAX_STARS-1){
      fprintf(stdout, "%s: exceeded maximum number of stars (%d)", filename, MAX_STARS);
      break;
    }
  }
  fclose(fin);
  return i;
}

void write_inp_file(char *filename, star_coord stars[], int star_num){
  FILE *fout;

  fout = fopen(filename, "w");
  int i;
  for(i=0;i<star_num;i++){
    fprintf(fout, "%10.4lf %10.4lf %f\n",
            stars[i].x, stars[i].y, stars[i].mag);
  }
  fclose(fout);
}

void write_ref_file(char *filename, star_coord stars[], int star_num){
  FILE *fout;

  fout = fopen(filename, "w");
  int i;
  for(i=0;i<star_num;i++){
    fprintf(fout, "%ld %lf %lf %10.4lf %10.4lf %f %f\n",
            stars[i].id, stars[i].ra, stars[i].dec,
            stars[i].x, stars[i].y, stars[i].mag, stars[i].emag);
  }
  fclose(fout);
}

void wipe_stars(star_coord inp_stars[], star_coord ref_stars[],
                star_coord inp_stars2[], star_coord ref_stars2[],
                int *inp_star_num, int *ref_star_num, float r){
  int i,j;
  int i2 = 0;
  int j2 = 0;
  float d2;
  int flg2[MAX_STARS] = {};
  int flg;

  for(i=0;i<*inp_star_num;i++){
    flg = 0;
    for(j=0;j<*ref_star_num;j++){
      d2 = pow(inp_stars[i].x-ref_stars[j].x, 2.0) + pow(inp_stars[i].y-ref_stars[j].y, 2.0);
      if(d2<pow(r,2.0)){
        if(!flg){
          inp_stars2[i2++] = inp_stars[i];
          flg = 1;
        }
        flg2[j]++;
      }
    }
  }

  for(j=0;j<*ref_star_num;j++){
    if(flg2[j]>0){
      ref_stars2[j2++] = ref_stars[j];
    }
  }

  *inp_star_num = i2;
  *ref_star_num = j2;

}


