/**************************************************************/
/*      name     : readfits_SF_WD_BIT.c (Ver.1.0)             */
/*               : FITSեɹ                       */
/*               : SF WD BIT ǡϤ                 */
/*               :                                            */
/*      date     : 2018-02-15 Y.Ikeda(DAIKO LIMITED)          */
/*      update   :                                            */
/**************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <fitsio.h>

int main(int argc, char *argv[]);
void readfits_SF_WD_BIT(char *filename,int  spfrm,int  wdno,int bitno);
void printerror( int status);

int main(int argc, char *argv[]){
    char  filename[80];
    int   spfrm,wdno,bitno;
    if(argc == 5){
        printf("The Hinotori FITS file is %s\n", argv[1]);
        strcpy(filename, argv[1]);
        spfrm = atoi(argv[2]);
        wdno = atoi(argv[3]);
        bitno = atoi(argv[4]);
        readfits_SF_WD_BIT(filename,spfrm,wdno,bitno);
    }
    else{
        printf("Usage: readfits_SF_WD_BIT  hinotori_fits_file  SF WD BIT\n");
    }
    return(0);
}

/***************************************/
/* FITSեλ SF WD BIT  */
/***************************************/
void readfits_SF_WD_BIT(
char *filename,
int  spfrm,
int  wdno,
int  bitno )
{
    fitsfile *fptr;
    int status=0;          /* initialize status before calling fitsio routines */
    int hdutype;
    int  mrsec,mr1,mr2,fstd,bitsft;
    unsigned char ficnt;

    long firstrow = 1;
    int frames, ii, jj;
    long irows;
    char comment[80],date_obs[80];
    unsigned char header[16], telemetry[128],wddat;

    printf("FITS FILE = %s\n", filename);

    fits_open_file(&fptr, filename, READONLY, &status);
    fits_movabs_hdu(fptr, 2, &hdutype, &status);
 
    printf("hdutype =%d\n", hdutype);
 
    fits_read_key(fptr, TINT, "FRAMES", &frames, comment, &status);
    printf("Number of frames = %d \n", frames);
    printf("Comment = %s \n", comment);

    fits_read_key(fptr, TSTRING, "DATE-OBS", date_obs, comment, &status);
    printf("DATE-OBS = %s \n", date_obs);

    printf("\nYYYY-MM-DD HH:MM:SS.mmm Frame[%03d] Word[%03d]   Bit[%d]\n",spfrm,wdno,bitno);
    for(ii=1;ii<=frames;ii++){
        fits_read_tblbytes(fptr, ii, 1L, 16L, header, &status);
        fits_read_tblbytes(fptr, ii, 17L, 128L, telemetry, &status);
        mr1 = header[5];
        mr2 = header[6];
        mrsec = mr1 * 256 + mr2;
        ficnt = header[8];
        wddat = telemetry[wdno];
        if(bitno != 0)wddat = wddat << bitno;
        wddat = wddat >> 7;

        /* SF WD BITν */
        if(ficnt == spfrm){
            printf("%.4s-%02d-%02d %02d:%02d:%02d.%03d       %03d       %03d      %3d\n",
               date_obs,header[0],header[1],header[2],header[3],header[4],mrsec,header[8],telemetry[wdno],wddat);
        }
    }

    if(status !=0) printerror(status);
    fits_close_file(fptr, &status);

    printf("status = %d\n", status);
    return;
}
/*--------------------------------------------------------------------------*/
void printerror(int status)
{
    /*****************************************************/
    /* Print out cfitsio error messages and exit program */
    /*****************************************************/
    if(status){
        fits_report_error(stderr, status); /* print error report */
        exit( status );    /* terminate the program, returning error status */
    }
    return;
}
