/**************************************************************/
/*      name     : readfits_hinotori_SOX.c (Ver.1.0)          */
/*               : FITSեɤ߹SOXǡϤ  */
/*               :                                            */
/*      date     : 2018-02-13 Y.Ikeda(DAIKO LIMITED)          */
/*      update   :                                            */
/**************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <fitsio.h>

int main(int argc, char *argv[]);
void readhinotori(char *filename);
void printerror( int status);

int main(int argc, char *argv[]){
    char  filename[80];
    if(argc == 2){
        printf("The Hinotori FITS file is %s\n", argv[1]);
        strcpy(filename, argv[1]);
        readhinotori(filename);
    }
    else{
        printf("Usage: readfits_hinotori_SOX hinotori_fits_file  \n");
    }
    return(0);
}


/*************************************/
/*  HINOTORI FITS SOXǡн  */
/*************************************/
void readhinotori(char *filename)
{
    fitsfile *fptr;
    int status=0;          /* initialize status before calling fitsio routines */
    int hdutype;

    long firstrow = 1;
    int  frames,ii,jj,sfcount,fi_mae,flg,mblk;
    int  mrsec,mr1,mr2,fstd;
    int  sfdim[10000][2]; /* Super FrameγNOȽλNO */
    int  soxmode[10000];
    long irows;
    char comment[80],date_obs[80];
    unsigned char header[16],telemetry[128];
    unsigned char ficnt,dpid2,sox_md;

    printf("FITS FILE = %s\n", filename);

    fits_open_file(&fptr, filename, READONLY, &status);
    fits_movabs_hdu(fptr, 2, &hdutype, &status);
    printf("hdutype =%d\n", hdutype);

    fits_read_key(fptr, TINT, "FRAMES", &frames, comment, &status);
    printf("Number of frames = %d \n", frames);
    printf("Comment = %s \n", comment);

    fits_read_key(fptr, TSTRING, "DATE-OBS", date_obs, comment, &status);
    printf("DATE-OBS = %s \n", date_obs);

    /* Super FrameĴSOX MODE */
    sox_md = 0;
    fstd = 16;
    flg = 0;
    sfcount = 0;
    for(ii=1;ii<=frames;ii++){
        fits_read_tblbytes(fptr, ii, 1L, 16L, header, &status);
        fits_read_tblbytes(fptr, ii, 17L, 128L, telemetry, &status);
        ficnt = header[8];
        if(ficnt == 2){
            dpid2 = telemetry[67];
            sox_md = dpid2 & 0x40;
            sox_md = sox_md >> 6;
        }
        if(flg == 0){
            sfdim[sfcount][0] = ii;
            fi_mae = ficnt;
            flg = 1;
        }
        else{
            if(fi_mae >= ficnt){
                sfdim[sfcount][1] = ii - 1;
                soxmode[sfcount] = sox_md;
                sfcount++;
                sfdim[sfcount][0] = ii;
            }
        }
        fi_mae = ficnt;
    }
    sfdim[sfcount][1] = ii - 1;
    printf("ii[%d] frames[%d] SFDIM_MAX[%d]\n",ii,frames,sfcount);

    for(ii=0;ii<=sfcount;ii++){
        printf("SF[%d] : STR[%d] END[%d] SOX_MODE[%d]\n",ii,sfdim[ii][0],sfdim[ii][1],soxmode[ii]);
    }

    /* SOX DATA */
    flg = 0;
    mblk = 0;
    printf("\nYYYY-MM-DD HH:MM:SS.mmm MODE ------------SOX1---------------  ------------SOX2---------------\n");
    for(ii=1;ii<=frames;ii++){
        fits_read_tblbytes(fptr, ii, 1L, 16L, header, &status);
        fits_read_tblbytes(fptr, ii, 17L, 128L, telemetry, &status);
        mr1 = header[5];
        mr2 = header[6];
        mrsec = mr1 * 256 + mr2;
        ficnt = header[8];

        /* Super FrameSOX-MODE Ф */
        for(jj=0;jj<=sfcount;jj++){
            if(ii >= sfdim[jj][0] && ii <= sfdim[jj][1]){
                sox_md = soxmode[jj];
                break;
            }
        }
        if((flg == 0) && (mblk == 0)){
            printf("SF=%d\n",jj);
            flg = 1;
        }
        if(mblk != jj) printf("SF=%d\n",jj);

        if(sox_md == 1){
            /* PH MODEν SOX-1,SOX-2 */
            if(ficnt%2 == 0){
                /* PH MODE(CH0-CH7)ν */
                printf("%.4s-%02d-%02d %02d:%02d:%02d.%03d  PH  %03d %03d %03d %03d %03d %03d %03d %03d  %03d %03d %03d %03d %03d %03d %03d %03d\n",
                  date_obs,header[0],header[1],header[2],header[3],header[4],mrsec,
                  telemetry[fstd*0+14],telemetry[fstd*1+14],telemetry[fstd*2+14],telemetry[fstd*3+14],telemetry[fstd*4+14],telemetry[fstd*5+14],telemetry[fstd*6+14],telemetry[fstd*7+14],
                  telemetry[fstd*0+15],telemetry[fstd*1+15],telemetry[fstd*2+15],telemetry[fstd*3+15],telemetry[fstd*4+15],telemetry[fstd*5+15],telemetry[fstd*6+15],telemetry[fstd*7+15]);
            }
            else{
                /* PH MODE(CH8-CH15)ν */
                printf("%.4s-%02d-%02d %02d:%02d:%02d.%03d      %03d %03d %03d %03d %03d %03d %03d %03d  %03d %03d %03d %03d %03d %03d %03d %03d\n",
                  date_obs,header[0],header[1],header[2],header[3],header[4],mrsec,
                  telemetry[fstd*0+14],telemetry[fstd*1+14],telemetry[fstd*2+14],telemetry[fstd*3+14],telemetry[fstd*4+14],telemetry[fstd*5+14],telemetry[fstd*6+14],telemetry[fstd*7+14],
                  telemetry[fstd*0+15],telemetry[fstd*1+15],telemetry[fstd*2+15],telemetry[fstd*3+15],telemetry[fstd*4+15],telemetry[fstd*5+15],telemetry[fstd*6+15],telemetry[fstd*7+15]);
            }
        }
        else{
            /* PC MODEν SOX-1,SOX-2*/
            printf("%.4s-%02d-%02d %02d:%02d:%02d.%03d  PC  %03d %03d %03d %03d %03d %03d %03d %03d  %03d %03d %03d %03d %03d %03d %03d %03d\n",
              date_obs,header[0],header[1],header[2],header[3],header[4],mrsec,
              telemetry[fstd*0+14],telemetry[fstd*1+14],telemetry[fstd*2+14],telemetry[fstd*3+14],telemetry[fstd*4+14],telemetry[fstd*5+14],telemetry[fstd*6+14],telemetry[fstd*7+14],
              telemetry[fstd*0+15],telemetry[fstd*1+15],telemetry[fstd*2+15],telemetry[fstd*3+15],telemetry[fstd*4+15],telemetry[fstd*5+15],telemetry[fstd*6+15],telemetry[fstd*7+15]);
        }
        mblk = jj;
    }

    if(status !=0) printerror(status);
    fits_close_file(fptr, &status);
    printf("status = %d\n", status);

    return;
}
/*--------------------------------------------------------------------------*/
void printerror(int status)
{
    /*****************************************************/
    /* Print out cfitsio error messages and exit program */
    /*****************************************************/
    if(status){
        fits_report_error(stderr, status); /* print error report */
        exit( status );    /* terminate the program, returning error status */
    }
    return;
}
