/**************************************************************/
/*      name     : readfits_hinotori_SPIN.c (Ver.1.0)         */
/*               : HINOTORI FITSեɹ              */
/*               : SPIN ǡϤ                      */
/*               :                                            */
/*      date     : 2018-03-09 Y.Ikeda(DAIKO LIMITED)          */
/*      update   :                                            */
/**************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <fitsio.h>

int main(int argc, char *argv[]);
void readfits_HINOTORI_SPIN_DATA(char *filename);
void printerror( int status);

int main(int argc, char *argv[]){
    char  filename[80];
    if(argc == 2){
        printf("The Hinotori FITS file is %s\n", argv[1]);
        strcpy(filename, argv[1]);
        readfits_HINOTORI_SPIN_DATA(filename);
    }
    else{
        printf("Usage: readfits_hinotori_SPIN  hinotori_fits_file \n");
    }
    return(0);
}

/*******************************************/
/* HINOTORI FITSեSPIN DATA  */
/*******************************************/
void readfits_HINOTORI_SPIN_DATA(
char *filename)
{
    fitsfile *fptr;
    int status=0;          /* initialize status before calling fitsio routines */
    int hdutype;
    int  mrsec,mr1,mr2,fstd,bitsft;
    unsigned char ficnt,SPIN_FI;

    long firstrow = 1;
    int frames, ii, jj;
    long irows;
    double spin_dat;
    char comment[80],date_obs[80];
    unsigned char header[16], telemetry[128],wddat,wddat2,spn_flg[2];
    double bitdat1[16];
    /*float spin_std[16]={0.0,0.0,16000.0,8000.0,4000.0,2000.0,1000.0,500.0,
                        250.0,125.0,62.0,31.25,15.63,7.81,3.91,1.95};*/
    double spin_std[16];
    spin_std[0] = 0.0;
    spin_std[1] = 0.0;
    spin_std[2] = 16000.0;
    spin_std[3] = 8000.0;
    spin_std[4] = 4000.0;
    spin_std[5] = 2000.0;
    spin_std[6] = 1000.0;
    spin_std[7] = 500.0;
    spin_std[8] = 250.0;
    spin_std[9] = 125.0;
    spin_std[10] = 1000.0 / 16.0;
    spin_std[11] = 1000.0 / 32.0;
    spin_std[12] = 1000.0 / 64.0;
    spin_std[13] = 1000.0 / 128.0;
    spin_std[14] = 1000.0 / 256.0;
    spin_std[15] = 1000.0 / 512.0;

    SPIN_FI = 6;
    printf("FITS FILE = %s\n", filename);

    fits_open_file(&fptr, filename, READONLY, &status);
    fits_movabs_hdu(fptr, 2, &hdutype, &status);
 
    printf("hdutype =%d\n", hdutype);
 
    fits_read_key(fptr, TINT, "FRAMES", &frames, comment, &status);
    printf("Number of frames = %d \n", frames);
    printf("Comment = %s \n", comment);

    fits_read_key(fptr, TSTRING, "DATE-OBS", date_obs, comment, &status);
    printf("DATE-OBS = %s \n", date_obs);

    printf("\nYYYY-MM-DD HH:MM:SS.mmm SPN[0] SPN[1]       spin_data\n");
    for(ii=1;ii<=frames;ii++){
        fits_read_tblbytes(fptr, ii, 1L, 16L, header, &status);
        fits_read_tblbytes(fptr, ii, 17L, 128L, telemetry, &status);
        mr1 = header[5];
        mr2 = header[6];
        mrsec = mr1 * 256 + mr2;
        ficnt = header[8];

        /* SPIN DATAν */
        if(ficnt%8 == SPIN_FI){
            wddat = telemetry[65];
            wddat2 = telemetry[66];
            for(jj=0;jj<8;jj++){
                wddat = telemetry[65];
                wddat2 = telemetry[66];
                wddat = wddat << jj;
                wddat = wddat >> 7;
                bitdat1[jj] = wddat;
                if(jj < 2) spn_flg[jj] = wddat;
                wddat2 = wddat2 << jj;
                wddat2 = wddat2 >> 7;
                bitdat1[jj+8] = wddat2;
            }
            spin_dat = 0.0;
            for(jj=2;jj<16;jj++){
                spin_dat = spin_dat + bitdat1[jj] * spin_std[jj];
            }
            printf("%.4s-%02d-%02d %02d:%02d:%02d.%03d     %d      %d     %f\n",
               date_obs,header[0],header[1],header[2],header[3],header[4],mrsec,spn_flg[0],spn_flg[1],spin_dat);
        }
    }

    if(status !=0) printerror(status);
    fits_close_file(fptr, &status);

    printf("status = %d\n", status);
    return;
}
/*--------------------------------------------------------------------------*/
void printerror(int status)
{
    /*****************************************************/
    /* Print out cfitsio error messages and exit program */
    /*****************************************************/
    if(status){
        fits_report_error(stderr, status); /* print error report */
        exit( status );    /* terminate the program, returning error status */
    }
    return;
}
