/**************************************************************/
/*      name     : readfits_hinotori_SUN_Angle2.c (Ver.1.0)   */
/*               : HINOTORI FITSեɹ              */
/*               : ۳ ǡϤ()      */
/*               :                                            */
/*      date     : 2018-03-12 Y.Ikeda(DAIKO LIMITED)          */
/*      update   :                                            */
/**************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <fitsio.h>

int main(int argc, char *argv[]);
void readfits_HINOTORI_SUN_Angle2(char *filename);
void printerror( int status);

int main(int argc, char *argv[]){
    char  filename[80];
    if(argc == 2){
        printf("The Hinotori FITS file is %s\n", argv[1]);
        strcpy(filename, argv[1]);
        readfits_HINOTORI_SUN_Angle2(filename);
    }
    else{
        printf("Usage: readfits_hinotori_SUN_Angle2  hinotori_fits_file \n");
    }
    return(0);
}

/***********************************************/
/* HINOTORI FITSեSUN_Angle DATA */
/***********************************************/
void readfits_HINOTORI_SUN_Angle2(
char *filename)
{
    fitsfile *fptr;
    int status=0;          /* initialize status before calling fitsio routines */
    int hdutype;
    int  mrsec,mr1,mr2,fstd,bitsft;
    unsigned char ficnt,SAS_FI;

    long firstrow = 1;
    int frames, ii, jj;
    long irows;
    float sas_dat;
    char comment[80],date_obs[80];
    unsigned char header[16], telemetry[128],wddat,wddat2,sas_flg,fr_flg;
    float bitdat1[16];
    float asas_std[8]={0.0,0.0,16.0,8.0,4.0,2.0,1.0,0.5};
    float ssas_std[8]={0.0,64.0,32.0,16.0,8.0,4.0,2.0,1.0};

    SAS_FI = 3;
    printf("FITS FILE = %s\n", filename);

    fits_open_file(&fptr, filename, READONLY, &status);
    fits_movabs_hdu(fptr, 2, &hdutype, &status);
 
    printf("hdutype =%d\n", hdutype);
 
    fits_read_key(fptr, TINT, "FRAMES", &frames, comment, &status);
    printf("Number of frames = %d \n", frames);
    printf("Comment = %s \n", comment);

    fits_read_key(fptr, TSTRING, "DATE-OBS", date_obs, comment, &status);
    printf("DATE-OBS = %s \n", date_obs);

    printf("\nYYYY-MM-DD HH:MM:SS.mmm FLG[0]        sas_dat   F/R\n");
    for(ii=1;ii<=frames;ii++){
        fits_read_tblbytes(fptr, ii, 1L, 16L, header, &status);
        fits_read_tblbytes(fptr, ii, 17L, 128L, telemetry, &status);
        mr1 = header[5];
        mr2 = header[6];
        mrsec = mr1 * 256 + mr2;
        ficnt = header[8];

        /* SAS DATAν */
        fr_flg = 0;
        sas_flg = 0;
        if(ficnt%8 == SAS_FI){
            wddat = telemetry[66];
            for(jj=0;jj<8;jj++){
                wddat = telemetry[66];
                wddat = wddat << jj;
                wddat = wddat >> 7;
                bitdat1[jj] = wddat;
                if(jj == 0) sas_flg = wddat;
                if((jj == 1) && (sas_flg == 1)) fr_flg = wddat;
            }
            sas_dat = 0.0;
            if(sas_flg == 1){
                for(jj=2;jj<8;jj++){
                    sas_dat = sas_dat + bitdat1[jj] * asas_std[jj];
                }
            }
            else{
                for(jj=1;jj<8;jj++){
                    sas_dat = sas_dat + bitdat1[jj] * ssas_std[jj];
                }
            }
            if(sas_flg == 1){
                printf("%.4s-%02d-%02d %02d:%02d:%02d.%03d     %d  ASAS   %f   %d\n",
                   date_obs,header[0],header[1],header[2],header[3],header[4],mrsec,sas_flg,sas_dat,fr_flg);
            }
            else{
                printf("%.4s-%02d-%02d %02d:%02d:%02d.%03d     %d  SSAS   %f \n",
                   date_obs,header[0],header[1],header[2],header[3],header[4],mrsec,sas_flg,sas_dat);
            }
        }
    }

    if(status !=0) printerror(status);
    fits_close_file(fptr, &status);

    printf("status = %d\n", status);
    return;
}
/*--------------------------------------------------------------------------*/
void printerror(int status)
{
    /*****************************************************/
    /* Print out cfitsio error messages and exit program */
    /*****************************************************/
    if(status){
        fits_report_error(stderr, status); /* print error report */
        exit( status );    /* terminate the program, returning error status */
    }
    return;
}
