;+
; NAME: eis_status_sts1_conversions.pro
;
; PURPOSE: To convert EIS status 1 parameters from telemetered values
;          to engineering values
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------
; files - string array of filenames in time order
; output - string pathname to where to write ps files
;
pro hk2_status_check, files, lu
  tmp = eis_get_daily_data(files, 'TR_MODE',  1,  1, maxp1, minp1, start_time, end_time)
  tmp = eis_get_daily_data(files, 'UFSAUSE',  2,  1, maxp2, minp2)
  tmp = eis_get_daily_data(files, 'UFSBUSE',  3,  1, maxp3, minp3)
  tmp = eis_get_daily_data(files, 'SC_ATT_X', 4,  1, maxp4, minp4)
  tmp = eis_get_daily_data(files, 'SC_ATT_Y', 5,  1, maxp5, minp5)
  tmp = eis_get_daily_data(files, 'SC_ATT_Z', 6,  1, maxp6, minp6)

  title_str = 'HK2 status                      min            max'

  frmt = 'count'
  p0_str  = eis_param_string('TR_MODE               ', frmt, minp1,  maxp1)
  p1_str  = eis_param_string('UFSAUSE               ', frmt, minp2,  maxp2)
  p2_str  = eis_param_string('UFSBUSE               ', frmt, minp3,  maxp3)
  p3_str  = eis_param_string('SC_ATT_X              ', frmt, minp4,  maxp4)
  p4_str  = eis_param_string('SC_ATT_Y              ', frmt, minp5,  maxp5)
  p5_str  = eis_param_string('SC_ATT_Z              ', frmt, minp6,  maxp6)

  if n_elements(lu) ne 0 then begin
     print, '	hk2_status_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu
  endif

 end


pro eis_status_hk2_check, dir, lu

  print, 'eis_status_hk2_check'

    files = findfile(dir + 'eis_hk2_*fits*', count=count)
    if count eq 0 then begin
;        print, 'eis_status_hk2_check'
        print, '	No files'
        return
    endif

    if n_elements(lu) ne 0 then begin
;        print, 'eis_status_hk2_check'
        hk2_status_check, files, lu
        return
    endif

    status_check, files

end
