;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	11/May/2007 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------

function eis_num2str, num, type=type
    format_str = '(F8.3)'
    if keyword_set(type) then begin
        case type of
            'volts'  : format_str = '(F10.2)'
            'amps'   : format_str = '(F10.3)'
            'temp'   : format_str = '(F10.2)'
            'degC'   : format_str = '(F10.2)'
            'count'  : format_str = '(I10)'
            'zcount' : format_str = '("    0x",Z04)'
            'hex2'   : format_str = '("      0x",Z02)'
            ''       : format_str = '(I10)'
            else     : format_str = '(F10.3)'	; Not really needed
        endcase
    endif
    return, strtrim(string(num,format=format_str), 0)
;    return, strtrim(string(num), 2)
end

