function eis_convert_mhc_temperature, rawArray, p29, p30

    a = 0.001471704
    b = 0.000237583
    c = 0.000000105

    zero_ref = p29 - '4000'x
    ref      = p30 - '4000'x
    thermistor_voltage = 305.2e-6 * ((rawArray - '4000'X) - zero_ref)
    drive_current = 305.2e-6 * (ref - zero_ref) / 1000

    i = where(drive_current eq 0.0, count)
    if count ne 0 then drive_current[i] = -1.0
    thermistor_resistance = thermistor_voltage / drive_current
    return, (1/(a + (b * alog(thermistor_resistance)) + (c * (alog(thermistor_resistance)^3)))) - 273.13
;    return, 1/(a + b * alog(thermistor_resistance) + c * alog(thermistor_resistance^3)) - 273.13
end
