;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006 v1.0 mcrw wrote
;       15/Nov/2006  v1.1 mcrw minor corrections
;       03/Dec/2006  v1.2 mcrw minor corrections
;
;-------------------------------------------------------------------------------------------------
pro aocs1_parameters, files, output, end_time

    p0  = eis_get_daily_data(files,'SAT_ROT',   1,  1, maxp1,  minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'UFSAXANG',  2,  1, maxp2,  minp2)
    p2  = eis_get_daily_data(files,'UFSAYANG',  3,  1, maxp3,  minp3)
    p3  = eis_get_daily_data(files,'UFSBXANG',  4,  1, maxp4,  minp4)
    p4  = eis_get_daily_data(files,'UFSBYANG',  5,  1, maxp5,  minp5)
    p5  = eis_get_daily_data(files,'ERRANGZ',   6,  1, maxp6,  minp6)

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

;;;    x = lindgen(n_elements(p0))*5
    x = lindgen(n_elements(p0))*1

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/eis_aocs1_parameters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp1-1,maxp1+1], $
      title='SAT_ROT',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp2-1,maxp2+1], $
      title='UFSAXANG',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp3-1,maxp3+1], $
      title='UFSAYANG   ',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp4-1,maxp4+1], $
      title='UFSBXANG',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p4,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp5-1,maxp5+1], $
      title='UFSBYANG',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p5,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp6-1,maxp6+1], $
      title='ERRANGZ',ytitle='Raw',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro aocs1_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME', 1,  2, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  2, maxp2, minp2)

;;;    x = lindgen(n_elements(p0))*10
    x = lindgen(n_elements(p0))*1

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/aocs1_spacecraft.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='TIME',ytitle='None',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='SEQ_COUNTER',ytitle='None',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro eis_status_aocs1_conversions, dir, output, end_time

    files = findfile(dir + 'eis_aocs1_*fits', count=count)
    if count eq 0 then begin
        print, 'eis_status_aocs1_conversions : No files'
        return
    endif

    aocs1_parameters, files, output, end_time
    aocs1_spacecraft, files, output, end_time

end
