;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006 v1.0 mcrw wrote
;       15/Nov/2006  v1.1 mcrw minor corrections
;       03/Dec/2006  v1.2 mcrw minor corrections
;
;-------------------------------------------------------------------------------------------------
pro mdp_parameters, files, output, end_time

    p0  = eis_get_daily_data(files,'CMD_EIS_SRQ_CNT',  1,  1, maxp1,  minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'CMD_EIS_DHU_CNT',  2,  1, maxp2,  minp2)
    p2  = eis_get_daily_data(files,'STS_EIS_RP1_CNT',  3,  1, maxp3,  minp3)
    p3  = eis_get_daily_data(files,'STS_EIS_RP2_CNT',  4,  1, maxp4,  minp4)
    p4  = eis_get_daily_data(files,'STS_EIS_RP3_CNT',  5,  1, maxp5,  minp5)
    p5  = eis_get_daily_data(files,'STS_EIS_RP4_CNT',  6,  1, maxp6,  minp6)
    p6  = eis_get_daily_data(files,'STS_EIS_ERR',      7,  1, maxp7,  minp7)
    p7  = eis_get_daily_data(files,'STS_EIS_RCV',      8,  1, maxp8,  minp8)
    p8  = eis_get_daily_data(files,'STS_EIS_ERR_TIM',  9,  1, maxp9,  minp9)
    p9  = eis_get_daily_data(files,'IMG_EIS_BUSY',    10,  1, maxp10, minp10)
    p10 = eis_get_daily_data(files,'IMG_EIS_QUE_SIZ', 11,  1, maxp11, minp11)
    p11 = eis_get_daily_data(files,'IMG_EIS_RCV_CNT', 12,  1, maxp12, minp12)
    p12 = eis_get_daily_data(files,'IMG_EIS_RCV_SIZ', 13,  1, maxp13, minp13)
    p13 = eis_get_daily_data(files,'EIS_FLR_FLG',     14,  1, maxp14, minp14)
    p14 = eis_get_daily_data(files,'EIS_FLR_LOC_X',   15,  1, maxp15, minp15)
    p15 = eis_get_daily_data(files,'EIS_FLR_LOC_Y',   16,  1, maxp16, minp16)

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

;;;    x = lindgen(n_elements(p0))*5
    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/eis_mdp_parameters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp1-1,maxp1+1], $
      title='CMD_EIS_SRQ_CNT',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp2-1,maxp2+1], $
      title='CMD_EIS_DHU_CNT',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp3-1,maxp3+1], $
      title='STS_EIS_RP1_CNT',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp4-1,maxp4+1], $
      title='STS_EIS_RP2_CNT',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p4,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp5-1,maxp5+1], $
      title='STS_EIS_RP3_CNT',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p5,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp6-1,maxp6+1], $
      title='STS_EIS_RP4_CNT',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p6,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[-1,2], $
      title='STS_EIS_ERR',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p7,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp8-1,maxp8+1], $
      title='STS_EIS_RCV',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p8,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp9-1,maxp9+1], $
      title='STS_EIS_ERR_TIM',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p9,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp10-1,maxp10+1], $
      title='IMG_EIS_BUSY',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p10,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp11-1,maxp11+1], $
      title='IMG_EIS_QUE_SIZ',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p11,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp12-1,maxp12+1], $
      title='IMG_EIS_RCV_CNT',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p12,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp13-1,maxp13+1], $
      title='IMG_EIS_RCV_SIZ',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p13,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp14-1,maxp14+1], $
      title='EIS_FLR_FLG',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p14,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp15-1,maxp15+1], $
      title='EIS_FLR_LOC_X',ytitle='Raw',charsize=cs,/ynozero

;;;    utplot,x,p15,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, psym=10, $
    utplot,x,p15,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp16-1,maxp16+1], $
      title='EIS_FLR_LOC_Y',ytitle='Raw',charsize=cs,/ynozero
;;;    oplot,x,p15,psym=2

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro mdp_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME', 1,  2, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  2, maxp2, minp2)

;;;    x = lindgen(n_elements(p0))*10
    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/mdp_spacecraft.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='TIME',ytitle='None',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='SEQ_COUNTER',ytitle='None',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro eis_status_mdp_conversions, dir, output, end_time

    files = findfile(dir + 'eis_eismdp_*fits', count=count)
    if count eq 0 then begin
        print, 'eis_status_mdp_conversions : No files'
        return
    endif

    mdp_parameters, files, output, end_time
    mdp_spacecraft, files, output, end_time

end
