;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006 v1.0 mcrw wrote
;       15/Nov/2006  v1.1 mcrw minor corrections
;       03/Dec/2006  v1.2 mcrw minor corrections
;
;-------------------------------------------------------------------------------------------------
pro sot_parameters, files, output, end_time

    p0  = eis_get_daily_data(files,'MDP_DSC_V_SAT',  1,  1, maxp1,  minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'MDP_DSC_V_SUN',  2,  1, maxp2,  minp2)
    p2  = eis_get_daily_data(files,'MDP_DSC_V_ETH',  3,  1, maxp3,  minp3)
    p3  = eis_get_daily_data(files,'MDP_DSC_V_RST',  4,  1, maxp4,  minp4)

;;;    x = lindgen(n_elements(p0))*5
    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/eis_sot_parameters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp1-1,maxp1+1], $
      title='MDP_DSC_V_SAT',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp2-1,maxp2+1], $
      title='MDP_DSC_V_SUN',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp3-1,maxp3+1], $
      title='MDP_DSC_V_ETH',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp4-1,maxp4+1], $
      title='MDP_DSC_V_RST',ytitle='Raw',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro sot_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME',        1,  2, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  2, maxp2, minp2)

;;;    x = lindgen(n_elements(p0))*10
    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/sot_spacecraft.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='TIME',ytitle='None',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='SEQ_COUNTER',ytitle='None',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro eis_status_sot_conversions, dir, output, end_time

    files = findfile(dir + 'eis_sot_*fits', count=count)
    if count eq 0 then begin
        print, 'eis_status_sot_conversions : No files'
        return
    endif

    sot_parameters, files, output, end_time
    sot_spacecraft, files, output, end_time

end
